/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.action.teleport;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.InventoryTargetable;
import com.ssblur.scriptor.helpers.targetable.ItemTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/ssblur/scriptor/word/action/teleport/SwapAction;", "Lcom/ssblur/scriptor/api/word/Action;", "<init>", "()V", "apply", "", "caster", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "targetable", "descriptors", "", "Lcom/ssblur/scriptor/api/word/Descriptor;", "(Lcom/ssblur/scriptor/helpers/targetable/Targetable;Lcom/ssblur/scriptor/helpers/targetable/Targetable;[Lcom/ssblur/scriptor/api/word/Descriptor;)V", "teleport", "from", "to", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "scriptor"})
public class SwapAction
extends Action {
    @Override
    public void apply(@NotNull Targetable caster, @NotNull Targetable targetable, @NotNull Descriptor[] descriptors) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
        if (targetable.getLevel().isClientSide) {
            return;
        }
        this.teleport(caster, targetable);
        this.teleport(targetable, caster);
    }

    protected final void teleport(@NotNull Targetable from, @NotNull Targetable to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (from instanceof InventoryTargetable && to instanceof InventoryTargetable && ((InventoryTargetable)((Object)from)).getContainer() != null && ((InventoryTargetable)((Object)to)).getContainer() != null) {
            ItemStack itemStack;
            if (((InventoryTargetable)((Object)from)).shouldIgnoreTargetedSlot()) {
                Container container = ((InventoryTargetable)((Object)from)).getContainer();
                Intrinsics.checkNotNull((Object)container);
                ItemStack itemStack2 = container.getItem(((InventoryTargetable)((Object)from)).getTargetedSlot());
                itemStack = itemStack2;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItem(...)");
            } else {
                Container container = ((InventoryTargetable)((Object)from)).getContainer();
                Intrinsics.checkNotNull((Object)container);
                ItemStack itemStack3 = container.getItem(((InventoryTargetable)((Object)from)).getFirstFilledSlot());
                itemStack = itemStack3;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"getItem(...)");
            }
            ItemStack itemStack4 = itemStack;
            Container container = ((InventoryTargetable)((Object)to)).getContainer();
            Intrinsics.checkNotNull((Object)container);
            if (container.canPlaceItem(((InventoryTargetable)((Object)to)).getTargetedSlot(), itemStack4)) {
                int n;
                ItemStack newItemStack = itemStack4.copy();
                newItemStack.setCount(1);
                if (((InventoryTargetable)((Object)to)).shouldIgnoreTargetedSlot()) {
                    InventoryTargetable inventoryTargetable = (InventoryTargetable)((Object)to);
                    Intrinsics.checkNotNull((Object)newItemStack);
                    n = inventoryTargetable.getFirstMatchingSlot(newItemStack);
                } else {
                    n = ((InventoryTargetable)((Object)to)).getTargetedSlot();
                }
                int slot = n;
                Container container2 = ((InventoryTargetable)((Object)to)).getContainer();
                Intrinsics.checkNotNull((Object)container2);
                ItemStack itemStack5 = container2.getItem(slot);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack5, (String)"getItem(...)");
                ItemStack itemStack2 = itemStack5;
                if (itemStack2.isEmpty()) {
                    itemStack4.shrink(1);
                    Container container3 = ((InventoryTargetable)((Object)to)).getContainer();
                    Intrinsics.checkNotNull((Object)container3);
                    container3.setItem(slot, newItemStack);
                } else if (ItemStack.isSameItemSameComponents((ItemStack)itemStack2, (ItemStack)itemStack4)) {
                    itemStack4.shrink(1);
                    itemStack2.grow(1);
                }
            }
        } else if (from instanceof ItemTargetable && to instanceof InventoryTargetable && ((InventoryTargetable)((Object)to)).getContainer() != null) {
            ItemStack itemStack = ((ItemTargetable)from).getTargetItem();
            Container container = ((InventoryTargetable)((Object)to)).getContainer();
            Intrinsics.checkNotNull((Object)container);
            if (container.canPlaceItem(((InventoryTargetable)((Object)to)).getTargetedSlot(), itemStack)) {
                int n;
                ItemStack newItemStack = itemStack.copy();
                newItemStack.setCount(1);
                if (((InventoryTargetable)((Object)to)).shouldIgnoreTargetedSlot()) {
                    InventoryTargetable inventoryTargetable = (InventoryTargetable)((Object)to);
                    Intrinsics.checkNotNull((Object)newItemStack);
                    n = inventoryTargetable.getFirstMatchingSlot(newItemStack);
                } else {
                    n = ((InventoryTargetable)((Object)to)).getTargetedSlot();
                }
                int slot = n;
                Container container4 = ((InventoryTargetable)((Object)to)).getContainer();
                Intrinsics.checkNotNull((Object)container4);
                ItemStack itemStack6 = container4.getItem(slot);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack6, (String)"getItem(...)");
                ItemStack itemStack2 = itemStack6;
                if (itemStack2.isEmpty()) {
                    itemStack.shrink(1);
                    Container container5 = ((InventoryTargetable)((Object)to)).getContainer();
                    Intrinsics.checkNotNull((Object)container5);
                    container5.setItem(slot, newItemStack);
                } else if (ItemStack.isSameItemSameComponents((ItemStack)itemStack2, (ItemStack)itemStack)) {
                    itemStack.shrink(1);
                    itemStack2.grow(1);
                }
            }
        } else if (from instanceof ItemTargetable && ((ItemTargetable)from).shouldTargetItem()) {
            ItemStack itemStack = ((ItemTargetable)from).getTargetItem();
            itemStack.shrink(1);
            ItemStack newItemStack = itemStack.copy();
            newItemStack.setCount(1);
            ItemEntity entity = new ItemEntity(to.getLevel(), to.getTargetPos().x(), to.getTargetPos().y() + 1.0, to.getTargetPos().z(), newItemStack);
            to.getLevel().addFreshEntity((Entity)entity);
        } else if (from instanceof EntityTargetable && ((EntityTargetable)from).getTargetEntity() instanceof LivingEntity) {
            Entity entity = ((EntityTargetable)from).getTargetEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            LivingEntity living = (LivingEntity)entity;
            Level level = living.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            Level level2 = level;
            if (level2 != to.getLevel()) {
                Level level3 = to.getLevel();
                Intrinsics.checkNotNull((Object)level3, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel toLevel = (ServerLevel)level3;
                toLevel.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, new ChunkPos(to.getTargetBlockPos()), 1, (Object)living.getId());
                living.teleportTo(toLevel, to.getTargetPos().x, to.getTargetPos().y, to.getTargetPos().z, SetsKt.emptySet(), living.getYRot(), living.getXRot());
                living.stopRiding();
                if (living instanceof Player) {
                    if (living.isSleeping()) {
                        ((Player)living).stopSleepInBed(true, true);
                    }
                    ((Player)living).onUpdateAbilities();
                }
            }
            if (living instanceof PathfinderMob) {
                ((PathfinderMob)living).getNavigation().stop();
            }
            living.teleportTo(to.getTargetPos().x, to.getTargetPos().y, to.getTargetPos().z);
            living.setDeltaMovement(0.0, 0.0, 0.0);
            living.resetFallDistance();
        }
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(6.0, Word.COSTTYPE.ADDITIVE);
    }
}

