/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.action.potions;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.descriptor.duration.DurationDescriptor;
import com.ssblur.scriptor.word.descriptor.power.StrengthDescriptor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ+\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016\u00a2\u0006\u0002\u0010\"JA\u0010#\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010&J\b\u0010\b\u001a\u00020\tH\u0016R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lcom/ssblur/scriptor/word/action/potions/PotionAction;", "Lcom/ssblur/scriptor/api/word/Action;", "mobEffect", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/effect/MobEffect;", "durationScale", "", "strengthScale", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "<init>", "(Lnet/minecraft/core/Holder;DDLcom/ssblur/scriptor/api/word/Word$Cost;)V", "getMobEffect", "()Lnet/minecraft/core/Holder;", "setMobEffect", "(Lnet/minecraft/core/Holder;)V", "getDurationScale", "()D", "setDurationScale", "(D)V", "getStrengthScale", "setStrengthScale", "getCost", "()Lcom/ssblur/scriptor/api/word/Word$Cost;", "setCost", "(Lcom/ssblur/scriptor/api/word/Word$Cost;)V", "apply", "", "caster", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "targetable", "descriptors", "", "Lcom/ssblur/scriptor/api/word/Descriptor;", "(Lcom/ssblur/scriptor/helpers/targetable/Targetable;Lcom/ssblur/scriptor/helpers/targetable/Targetable;[Lcom/ssblur/scriptor/api/word/Descriptor;)V", "applyToPosition", "strength", "duration", "(Lcom/ssblur/scriptor/helpers/targetable/Targetable;Lcom/ssblur/scriptor/helpers/targetable/Targetable;[Lcom/ssblur/scriptor/api/word/Descriptor;DD)V", "scriptor"})
public class PotionAction
extends Action {
    @NotNull
    private Holder<MobEffect> mobEffect;
    private double durationScale;
    private double strengthScale;
    @NotNull
    private Word.Cost cost;

    public PotionAction(@NotNull Holder<MobEffect> mobEffect, double durationScale, double strengthScale, @NotNull Word.Cost cost) {
        Intrinsics.checkNotNullParameter(mobEffect, (String)"mobEffect");
        Intrinsics.checkNotNullParameter((Object)cost, (String)"cost");
        this.mobEffect = mobEffect;
        this.durationScale = durationScale;
        this.strengthScale = strengthScale;
        this.cost = cost;
    }

    @NotNull
    public final Holder<MobEffect> getMobEffect() {
        return this.mobEffect;
    }

    public final void setMobEffect(@NotNull Holder<MobEffect> holder) {
        Intrinsics.checkNotNullParameter(holder, (String)"<set-?>");
        this.mobEffect = holder;
    }

    public final double getDurationScale() {
        return this.durationScale;
    }

    public final void setDurationScale(double d) {
        this.durationScale = d;
    }

    public final double getStrengthScale() {
        return this.strengthScale;
    }

    public final void setStrengthScale(double d) {
        this.strengthScale = d;
    }

    @NotNull
    public final Word.Cost getCost() {
        return this.cost;
    }

    public final void setCost(@NotNull Word.Cost cost) {
        Intrinsics.checkNotNullParameter((Object)cost, (String)"<set-?>");
        this.cost = cost;
    }

    @Override
    public void apply(@NotNull Targetable caster, @NotNull Targetable targetable, @NotNull Descriptor[] descriptors) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
        double strength = 0.0;
        double duration = 2.0;
        int n = descriptors.length;
        for (int i = 0; i < n; ++i) {
            Descriptor d = descriptors[i];
            if (d instanceof StrengthDescriptor) {
                strength += ((StrengthDescriptor)((Object)d)).strengthModifier();
            }
            if (!(d instanceof DurationDescriptor)) continue;
            duration += ((DurationDescriptor)((Object)d)).durationModifier();
        }
        strength = Math.max(strength, 0.0);
        strength *= this.strengthScale;
        duration *= this.durationScale;
        if (targetable instanceof EntityTargetable && ((EntityTargetable)targetable).getTargetEntity() instanceof LivingEntity) {
            Entity entity = ((EntityTargetable)targetable).getTargetEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            ((LivingEntity)entity).addEffect(new MobEffectInstance(this.mobEffect, (int)Math.round(duration), (int)Math.floor(strength)));
        } else {
            this.applyToPosition(caster, targetable, descriptors, strength, duration);
        }
    }

    public void applyToPosition(@Nullable Targetable caster, @Nullable Targetable targetable, @Nullable Descriptor[] descriptors, double strength, double duration) {
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return this.cost;
    }
}

