/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.action;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.helpers.ItemTargetableHelper;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.mixin.BlockPlaceContextAccessor;
import com.ssblur.scriptor.network.client.ParticleNetwork;
import com.ssblur.scriptor.registry.colorable.ColorableBlockRegistry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J+\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/ssblur/scriptor/word/action/PlaceBlockAction;", "Lcom/ssblur/scriptor/api/word/Action;", "<init>", "()V", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "apply", "", "caster", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "targetable", "descriptors", "", "Lcom/ssblur/scriptor/api/word/Descriptor;", "(Lcom/ssblur/scriptor/helpers/targetable/Targetable;Lcom/ssblur/scriptor/helpers/targetable/Targetable;[Lcom/ssblur/scriptor/api/word/Descriptor;)V", "scriptor"})
public final class PlaceBlockAction
extends Action {
    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(1.5, Word.COSTTYPE.ADDITIVE);
    }

    @Override
    public void apply(@NotNull Targetable caster, @NotNull Targetable targetable, @NotNull Descriptor[] descriptors) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
        int color = CustomColors.INSTANCE.getColor(descriptors);
        BlockPos pos = targetable.getTargetBlockPos();
        Level level = targetable.getLevel();
        if (!level.getBlockState(pos).canBeReplaced()) {
            return;
        }
        ItemStack itemFocus = ItemTargetableHelper.INSTANCE.getTargetItemStack(caster, false, PlaceBlockAction::apply$lambda$0);
        if (itemFocus.getItem() instanceof BlockItem) {
            Item item = itemFocus.getItem();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.minecraft.world.item.BlockItem");
            InteractionResult interactionResult = ((BlockItem)item).place(BlockPlaceContextAccessor.createBlockPlaceContext(level, null, InteractionHand.MAIN_HAND, itemFocus, new BlockHitResult(targetable.getTargetPos(), targetable.getFacing(), targetable.getTargetBlockPos(), false)));
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"place(...)");
            InteractionResult status = interactionResult;
            if (!status.consumesAction()) {
                ParticleNetwork.INSTANCE.fizzle(level, targetable.getTargetBlockPos());
            }
        } else {
            ColorableBlockRegistry.INSTANCE.getDYE_COLORABLE_BLOCKS().getMAGIC_BLOCK().setColor(color, level, pos);
        }
    }

    private static final boolean apply$lambda$0(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getItem() instanceof BlockItem;
    }
}

