/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.action;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.ItemTargetableHelper;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.ItemTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.descriptor.duration.DurationDescriptor;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/ssblur/scriptor/word/action/InflameAction;", "Lcom/ssblur/scriptor/api/word/Action;", "<init>", "()V", "apply", "", "caster", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "targetable", "descriptors", "", "Lcom/ssblur/scriptor/api/word/Descriptor;", "(Lcom/ssblur/scriptor/helpers/targetable/Targetable;Lcom/ssblur/scriptor/helpers/targetable/Targetable;[Lcom/ssblur/scriptor/api/word/Descriptor;)V", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "scriptor"})
public final class InflameAction
extends Action {
    @Override
    public void apply(@NotNull Targetable caster, @NotNull Targetable targetable, @NotNull Descriptor[] descriptors) {
        RecipeManager.CachedCheck check;
        Optional recipe;
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
        double seconds = 2.0;
        for (Descriptor d : descriptors) {
            if (!(d instanceof DurationDescriptor)) continue;
            seconds += ((DurationDescriptor)((Object)d)).durationModifier();
        }
        if (targetable instanceof ItemTargetable && ((ItemTargetable)targetable).shouldTargetItem()) {
            RecipeManager.CachedCheck check2 = RecipeManager.createCheck((RecipeType)RecipeType.SMELTING);
            Optional recipe2 = check2.getRecipeFor((RecipeInput)new SingleRecipeInput(((ItemTargetable)targetable).getTargetItem()), targetable.getLevel());
            if (recipe2.isPresent() && !((SmeltingRecipe)((RecipeHolder)recipe2.get()).value()).getIngredients().isEmpty()) {
                ItemStack[] itemStackArray = ((Ingredient)((SmeltingRecipe)((RecipeHolder)recipe2.get()).value()).getIngredients().get(0)).getItems();
                Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getItems(...)");
                if (!(((Object[])itemStackArray).length == 0)) {
                    int count = ((Ingredient)((SmeltingRecipe)((RecipeHolder)recipe2.get()).value()).getIngredients().get(0)).getItems()[0].getCount();
                    ((ItemTargetable)targetable).getTargetItem().shrink(count);
                    Vec3 pos = targetable.getTargetPos();
                    ItemEntity entity = new ItemEntity(targetable.getLevel(), pos.x(), pos.y() + 1.0, pos.z(), ((SmeltingRecipe)((RecipeHolder)recipe2.get()).value()).getResultItem((HolderLookup.Provider)targetable.getLevel().registryAccess()));
                    caster.getLevel().addFreshEntity((Entity)entity);
                }
            }
            return;
        }
        ItemStack itemTarget = ItemTargetableHelper.INSTANCE.getTargetItemStack(targetable);
        if (!itemTarget.isEmpty() && (recipe = (check = RecipeManager.createCheck((RecipeType)RecipeType.SMELTING)).getRecipeFor((RecipeInput)new SingleRecipeInput(itemTarget), targetable.getLevel())).isPresent() && ((SmeltingRecipe)((RecipeHolder)recipe.get()).value()).getIngredients().size() > 0) {
            ItemStack[] itemStackArray = ((Ingredient)((SmeltingRecipe)((RecipeHolder)recipe.get()).value()).getIngredients().get(0)).getItems();
            Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getItems(...)");
            if (!(((Object[])itemStackArray).length == 0)) {
                int count = ((Ingredient)((SmeltingRecipe)((RecipeHolder)recipe.get()).value()).getIngredients().get(0)).getItems()[0].getCount();
                itemTarget.shrink(count);
                ItemStack itemStack = ((SmeltingRecipe)((RecipeHolder)recipe.get()).value()).getResultItem((HolderLookup.Provider)targetable.getLevel().registryAccess());
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getResultItem(...)");
                ItemTargetableHelper.INSTANCE.depositItemStack(targetable, itemStack);
                return;
            }
        }
        if (targetable instanceof EntityTargetable) {
            ((EntityTargetable)targetable).getTargetEntity().setRemainingFireTicks((int)Math.round(seconds * (double)20));
        } else {
            BlockPos pos = targetable.getTargetBlockPos();
            Level level = targetable.getLevel();
            if (!level.getBlockState(pos).canBeReplaced()) {
                return;
            }
            BlockState blockState2 = BaseFireBlock.getState((BlockGetter)((BlockGetter)level), (BlockPos)pos);
            level.setBlock(pos, blockState2, 11);
            if (caster instanceof EntityTargetable && ((EntityTargetable)caster).getTargetEntity() instanceof Player) {
                level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            } else {
                level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            }
        }
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(2.0, Word.COSTTYPE.ADDITIVE);
    }
}

