/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.action;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.ItemTargetableHelper;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.InventoryTargetable;
import com.ssblur.scriptor.helpers.targetable.ItemTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$BG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0006J\b\u0010\u0002\u001a\u00020\u001cH\u0016J+\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0005H\u0016\u00a2\u0006\u0002\u0010#R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/ssblur/scriptor/word/action/CommandAction;", "Lcom/ssblur/scriptor/api/word/Action;", "cost", "", "blockTargetCommand", "", "", "entityTargetCommand", "itemTargetCommand", "<init>", "(D[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V", "getCost", "()D", "setCost", "(D)V", "", "getEntityTargetCommand", "()Ljava/util/List;", "setEntityTargetCommand", "(Ljava/util/List;)V", "getBlockTargetCommand", "setBlockTargetCommand", "getItemTargetCommand", "setItemTargetCommand", "addEntityTargetCommand", "", "addItemTargetCommand", "addBlockTargetCommand", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "apply", "caster", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "targetable", "descriptors", "Lcom/ssblur/scriptor/api/word/Descriptor;", "(Lcom/ssblur/scriptor/helpers/targetable/Targetable;Lcom/ssblur/scriptor/helpers/targetable/Targetable;[Lcom/ssblur/scriptor/api/word/Descriptor;)V", "Companion", "scriptor"})
public final class CommandAction
extends Action {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double cost;
    @NotNull
    private List<String> entityTargetCommand;
    @NotNull
    private List<String> blockTargetCommand;
    @NotNull
    private List<String> itemTargetCommand;

    @JvmOverloads
    public CommandAction(double cost, @NotNull String[] blockTargetCommand, @NotNull String[] entityTargetCommand, @NotNull String[] itemTargetCommand) {
        Intrinsics.checkNotNullParameter((Object)blockTargetCommand, (String)"blockTargetCommand");
        Intrinsics.checkNotNullParameter((Object)entityTargetCommand, (String)"entityTargetCommand");
        Intrinsics.checkNotNullParameter((Object)itemTargetCommand, (String)"itemTargetCommand");
        this.cost = cost;
        this.entityTargetCommand = CollectionsKt.toMutableList((Collection)ArraysKt.filterNotNull((Object[])entityTargetCommand));
        this.blockTargetCommand = CollectionsKt.toMutableList((Collection)ArraysKt.filterNotNull((Object[])blockTargetCommand));
        this.itemTargetCommand = CollectionsKt.toMutableList((Collection)ArraysKt.filterNotNull((Object[])itemTargetCommand));
    }

    public /* synthetic */ CommandAction(double d, String[] stringArray, String[] stringArray2, String[] stringArray3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            stringArray = new String[]{};
        }
        if ((n & 4) != 0) {
            stringArray2 = new String[]{};
        }
        if ((n & 8) != 0) {
            stringArray3 = new String[]{};
        }
        this(d, stringArray, stringArray2, stringArray3);
    }

    public final double getCost() {
        return this.cost;
    }

    public final void setCost(double d) {
        this.cost = d;
    }

    @NotNull
    public final List<String> getEntityTargetCommand() {
        return this.entityTargetCommand;
    }

    public final void setEntityTargetCommand(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.entityTargetCommand = list;
    }

    @NotNull
    public final List<String> getBlockTargetCommand() {
        return this.blockTargetCommand;
    }

    public final void setBlockTargetCommand(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.blockTargetCommand = list;
    }

    @NotNull
    public final List<String> getItemTargetCommand() {
        return this.itemTargetCommand;
    }

    public final void setItemTargetCommand(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.itemTargetCommand = list;
    }

    public final void addEntityTargetCommand(@NotNull String entityTargetCommand) {
        Intrinsics.checkNotNullParameter((Object)entityTargetCommand, (String)"entityTargetCommand");
        this.entityTargetCommand.add(entityTargetCommand);
    }

    public final void addItemTargetCommand(@NotNull String itemTargetCommand) {
        Intrinsics.checkNotNullParameter((Object)itemTargetCommand, (String)"itemTargetCommand");
        this.itemTargetCommand.add(itemTargetCommand);
    }

    public final void addBlockTargetCommand(@NotNull String blockTargetCommand) {
        Intrinsics.checkNotNullParameter((Object)blockTargetCommand, (String)"blockTargetCommand");
        this.blockTargetCommand.add(blockTargetCommand);
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return Word.Cost.Companion.add(this.cost);
    }

    @Override
    public void apply(@NotNull Targetable caster, @NotNull Targetable targetable, @NotNull Descriptor[] descriptors) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
        String casterString = "@s";
        ArmorStand tempCasterEntity = null;
        ArmorStand tempItemEntity = null;
        if (caster instanceof EntityTargetable) {
            Entity entity = ((EntityTargetable)caster).getTargetEntity();
            casterString = Companion.getTargetSelector(entity);
        } else {
            Level level = caster.getLevel();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel level2 = (ServerLevel)level;
            BlockPos blockPos = caster.getOrigin();
            Intrinsics.checkNotNull((Object)blockPos);
            tempCasterEntity = (ArmorStand)EntityType.ARMOR_STAND.spawn(level2, blockPos, MobSpawnType.COMMAND);
            if (tempCasterEntity != null) {
                casterString = Companion.getTargetSelector((Entity)tempCasterEntity);
                tempCasterEntity.setCustomName((Component)Component.translatable((String)"block.scriptor.casting_lectern"));
            }
        }
        List commandToParse = new ArrayList();
        Vec3 pos = targetable.getTargetPos();
        if (!ItemTargetableHelper.INSTANCE.getTargetItemStack(targetable).isEmpty() && !this.itemTargetCommand.isEmpty()) {
            String targetString = "@s";
            if (targetable instanceof EntityTargetable) {
                targetString = Companion.getTargetSelector(((EntityTargetable)targetable).getTargetEntity());
            }
            if (caster.getLevel() instanceof ServerLevel) {
                Level level = caster.getLevel();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel level3 = (ServerLevel)level;
                tempItemEntity = (ArmorStand)EntityType.ARMOR_STAND.spawn(level3, targetable.getTargetBlockPos(), MobSpawnType.COMMAND);
                if (tempItemEntity != null) {
                    tempItemEntity.setItemSlot(EquipmentSlot.MAINHAND, ItemTargetableHelper.INSTANCE.getTargetItemStack(targetable).copy());
                    tempItemEntity.setCustomName((Component)Component.translatable((String)"command.scriptor.magic_name"));
                    for (String string : this.itemTargetCommand) {
                        var14_18 = "execute at %s as %s run %s";
                        var15_19 = new Object[]{Companion.getTargetSelector((Entity)tempItemEntity), Companion.getTargetSelector((Entity)tempItemEntity), Companion.substituteTargetStrings(string, casterString, targetString)};
                        String string2 = String.format((String)var14_18, Arrays.copyOf(var15_19, var15_19.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        commandToParse.add(string2);
                    }
                }
            } else if (caster instanceof EntityTargetable && ((EntityTargetable)caster).getTargetEntity() instanceof Player) {
                Entity entity = ((EntityTargetable)caster).getTargetEntity();
                Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
                ((Player)entity).sendSystemMessage((Component)Component.translatable((String)"command.scriptor.no_item_commands_creative"));
            }
        } else if (targetable instanceof EntityTargetable && !((Collection)this.entityTargetCommand).isEmpty()) {
            Entity entity = ((EntityTargetable)targetable).getTargetEntity();
            String targetString = Companion.getTargetSelector(entity);
            for (String string : this.entityTargetCommand) {
                var14_18 = "execute at %s as %s run %s";
                var15_19 = new Object[]{targetString, targetString, Companion.substituteTargetStrings(string, casterString, targetString)};
                String string3 = String.format((String)var14_18, Arrays.copyOf(var15_19, var15_19.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                commandToParse.add(string3);
            }
        } else {
            for (String i : this.blockTargetCommand) {
                Locale locale = Locale.US;
                String string = "execute positioned %f %f %f in %s run %s";
                var14_18 = new Object[]{pos.x, pos.y, pos.z, targetable.getLevel().dimension().location(), Companion.substituteTargetStrings(i, casterString, "@e[distance=..1]")};
                String string4 = String.format(locale, string, Arrays.copyOf(var14_18, ((Object[])var14_18).length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                commandToParse.add(string4);
            }
        }
        if (targetable.getLevel().getServer() == null) {
            return;
        }
        MinecraftServer minecraftServer = targetable.getLevel().getServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        Commands commands = minecraftServer.getCommands();
        for (String command : commandToParse) {
            CommandDispatcher commandDispatcher = commands.getDispatcher();
            Vec3 vec3 = targetable.getTargetPos();
            Vec2 vec2 = new Vec2(0.0f, 0.0f);
            Level level = targetable.getLevel();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            Component component = (Component)Component.translatable((String)"command.scriptor.magic_name");
            MinecraftServer minecraftServer2 = targetable.getLevel().getServer();
            Intrinsics.checkNotNull((Object)minecraftServer2);
            ParseResults parseResults = commandDispatcher.parse(command, (Object)new CommandSourceStack(CommandSource.NULL, vec3, vec2, serverLevel, 4, "Magic", component, minecraftServer2, null));
            commands.performCommand(parseResults, command);
        }
        ArmorStand armorStand = tempCasterEntity;
        if (armorStand != null) {
            armorStand.remove(Entity.RemovalReason.DISCARDED);
        }
        if (tempItemEntity != null) {
            if (targetable instanceof InventoryTargetable) {
                if (((InventoryTargetable)((Object)targetable)).getContainer() != null) {
                    Container container = ((InventoryTargetable)((Object)targetable)).getContainer();
                    Intrinsics.checkNotNull((Object)container);
                    container.setItem(((InventoryTargetable)((Object)targetable)).getTargetedSlot(), tempItemEntity.getItemBySlot(EquipmentSlot.MAINHAND));
                }
            } else if (targetable instanceof ItemTargetable) {
                ((ItemTargetable)targetable).getTargetItem().setCount(0);
                ItemStack itemStack = tempItemEntity.getItemBySlot(EquipmentSlot.MAINHAND);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
                ItemTargetableHelper.INSTANCE.depositItemStack(targetable, itemStack);
            }
            tempItemEntity.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @JvmOverloads
    public CommandAction(double cost, @NotNull String[] blockTargetCommand, @NotNull String[] entityTargetCommand) {
        Intrinsics.checkNotNullParameter((Object)blockTargetCommand, (String)"blockTargetCommand");
        Intrinsics.checkNotNullParameter((Object)entityTargetCommand, (String)"entityTargetCommand");
        this(cost, blockTargetCommand, entityTargetCommand, null, 8, null);
    }

    @JvmOverloads
    public CommandAction(double cost, @NotNull String[] blockTargetCommand) {
        Intrinsics.checkNotNullParameter((Object)blockTargetCommand, (String)"blockTargetCommand");
        this(cost, blockTargetCommand, null, null, 12, null);
    }

    @JvmOverloads
    public CommandAction(double cost) {
        this(cost, null, null, null, 14, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005\u00a8\u0006\f"}, d2={"Lcom/ssblur/scriptor/word/action/CommandAction$Companion;", "", "<init>", "()V", "getTargetSelector", "", "entity", "Lnet/minecraft/world/entity/Entity;", "substituteTargetStrings", "string", "casterString", "targetString", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTargetSelector(@NotNull Entity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            UUID uuid = entity.getUUID();
            long l = uuid.getLeastSignificantBits();
            long m = uuid.getMostSignificantBits();
            String string = "@e[nbt={UUID:[I;%d,%d,%d,%d]}]";
            Object[] objectArray = new Object[]{(int)(m >> 32), (int)m, (int)(l >> 32), (int)l};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        @NotNull
        public final String substituteTargetStrings(@NotNull String string, @NotNull String casterString, @NotNull String targetString) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Intrinsics.checkNotNullParameter((Object)casterString, (String)"casterString");
            Intrinsics.checkNotNullParameter((Object)targetString, (String)"targetString");
            String string2 = casterString.substring(0, casterString.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String string3 = StringsKt.replace$default((String)string, (String)"@caster[", (String)(string2 + ","), (boolean)false, (int)4, null);
            String string4 = targetString.substring(0, targetString.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string3, (String)"@target[", (String)(string4 + ","), (boolean)false, (int)4, null), (String)"@caster", (String)casterString, (boolean)false, (int)4, null), (String)"@target", (String)targetString, (boolean)false, (int)4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

