/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.action;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.ItemTargetableHelper;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.descriptor.power.StrengthDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/ssblur/scriptor/word/action/BreakBlockAction;", "Lcom/ssblur/scriptor/api/word/Action;", "<init>", "()V", "apply", "", "caster", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "targetable", "descriptors", "", "Lcom/ssblur/scriptor/api/word/Descriptor;", "(Lcom/ssblur/scriptor/helpers/targetable/Targetable;Lcom/ssblur/scriptor/helpers/targetable/Targetable;[Lcom/ssblur/scriptor/api/word/Descriptor;)V", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "Companion", "scriptor"})
public final class BreakBlockAction
extends Action {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static HashMap<String, Integer> toolLevelsList = new HashMap();

    @Override
    public void apply(@NotNull Targetable caster, @NotNull Targetable targetable, @NotNull Descriptor[] descriptors) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
        if (targetable.getLevel().isClientSide) {
            return;
        }
        double strength = 1.0;
        for (Descriptor d : descriptors) {
            if (!(d instanceof StrengthDescriptor)) continue;
            strength += ((StrengthDescriptor)((Object)d)).strengthModifier();
        }
        ItemStack itemTarget = ItemTargetableHelper.INSTANCE.getTargetItemStack(targetable, false, BreakBlockAction::apply$lambda$0);
        if (!itemTarget.isEmpty() && itemTarget.isDamageableItem()) {
            itemTarget.setDamageValue(itemTarget.getDamageValue() + (int)Math.round(strength));
            return;
        }
        BlockPos pos = targetable.getOffsetBlockPos();
        BlockState state = targetable.getLevel().getBlockState(pos);
        if (state.getBlock().defaultDestroyTime() < 0.0f) {
            return;
        }
        Level level = targetable.getLevel();
        Set tags = state.getBlock().builtInRegistryHolder().tags().collect(Collectors.toSet());
        int neededStrength = 0;
        for (TagKey tag : tags) {
            if (!toolLevelsList.containsKey(tag.location().toString())) continue;
            Integer n = toolLevelsList.get(tag.location().toString());
            Intrinsics.checkNotNull((Object)n);
            neededStrength = ((Number)n).intValue();
        }
        if (strength > (double)neededStrength) {
            if (caster instanceof EntityTargetable) {
                if (((EntityTargetable)caster).getTargetEntity() instanceof Player) {
                    Block block = state.getBlock();
                    Entity entity = ((EntityTargetable)caster).getTargetEntity();
                    Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
                    block.playerDestroy(level, (Player)entity, pos, state, level.getBlockEntity(pos), new ItemStack((ItemLike)Items.NETHERITE_PICKAXE));
                }
                v3 = level.destroyBlock(pos, false, ((EntityTargetable)caster).getTargetEntity(), (int)Math.round(strength));
            } else {
                v3 = level.destroyBlock(pos, true, null, (int)Math.round(strength));
            }
        }
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(1.0, Word.COSTTYPE.ADDITIVE);
    }

    private static final boolean apply$lambda$0(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isEmpty() && it.isDamageableItem();
    }

    static {
        ((Map)toolLevelsList).put("minecraft:needs_stone_tool", 1);
        ((Map)toolLevelsList).put("minecraft:needs_iron_tool", 2);
        ((Map)toolLevelsList).put("minecraft:needs_diamond_tool", 3);
        ((Map)toolLevelsList).put("minecraft:needs_netherite_tool", 4);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R8\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\bj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/ssblur/scriptor/word/action/BreakBlockAction$Companion;", "", "<init>", "()V", "toolLevelsList", "Lkotlin/collections/HashMap;", "", "", "Ljava/util/HashMap;", "getToolLevelsList", "()Ljava/util/HashMap;", "setToolLevelsList", "(Ljava/util/HashMap;)V", "Ljava/util/HashMap;", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HashMap<String, Integer> getToolLevelsList() {
            return toolLevelsList;
        }

        public final void setToolLevelsList(@NotNull HashMap<String, Integer> hashMap) {
            Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
            toolLevelsList = hashMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

