/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.resources;

import com.google.common.collect.HashBiMap;
import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.error.WordNotFoundException;
import com.ssblur.scriptor.registry.words.WordRegistry;
import com.ssblur.scriptor.word.PartialSpell;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.unfocused.ModInitializer;
import com.ssblur.unfocused.data.DataLoaderRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u0007R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/ssblur/scriptor/resources/Engravings;", "", "<init>", "()V", "engravings", "", "Lnet/minecraft/resources/ResourceLocation;", "Lcom/ssblur/scriptor/resources/Engravings$EngravingResource;", "getEngravings", "()Ljava/util/Map;", "getRandomEngraving", "EngravingResource", "scriptor"})
public final class Engravings {
    @NotNull
    public static final Engravings INSTANCE = new Engravings();
    @NotNull
    private static final Map<ResourceLocation, EngravingResource> engravings = DataLoaderRegistry.INSTANCE.registerSimpleDataLoader((ModInitializer)ScriptorMod.INSTANCE, "scriptor/engravings", Reflection.getOrCreateKotlinClass(EngravingResource.class));

    private Engravings() {
    }

    @NotNull
    public final Map<ResourceLocation, EngravingResource> getEngravings() {
        return engravings;
    }

    @NotNull
    public final EngravingResource getRandomEngraving() {
        return (EngravingResource)((Map.Entry)CollectionsKt.random((Collection)engravings.entrySet(), (Random)((Random)Random.Default))).getValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/ssblur/scriptor/resources/Engravings$EngravingResource;", "", "<init>", "()V", "spell", "Lcom/ssblur/scriptor/resources/Engravings$EngravingResource$SpellResource;", "getSpell", "()Lcom/ssblur/scriptor/resources/Engravings$EngravingResource$SpellResource;", "setSpell", "(Lcom/ssblur/scriptor/resources/Engravings$EngravingResource$SpellResource;)V", "generateSpell", "Lcom/ssblur/scriptor/word/Spell;", "PartialSpellResource", "SpellResource", "scriptor"})
    @SourceDebugExtension(value={"SMAP\nEngravings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Engravings.kt\ncom/ssblur/scriptor/resources/Engravings$EngravingResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,35:1\n1557#2:36\n1628#2,3:37\n37#3,2:40\n37#3,2:42\n*S KotlinDebug\n*F\n+ 1 Engravings.kt\ncom/ssblur/scriptor/resources/Engravings$EngravingResource\n*L\n23#1:36\n23#1:37,3\n24#1:40,2\n28#1:42,2\n*E\n"})
    public static final class EngravingResource {
        @Nullable
        private SpellResource spell;

        @Nullable
        public final SpellResource getSpell() {
            return this.spell;
        }

        public final void setSpell(@Nullable SpellResource spellResource) {
            this.spell = spellResource;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Spell generateSpell() {
            List spells = new ArrayList();
            SpellResource spellResource = this.spell;
            Intrinsics.checkNotNull((Object)spellResource);
            for (PartialSpellResource spell : spellResource.getSpells()) {
                Action action;
                void $this$mapTo$iv$iv;
                if ((Action)WordRegistry.INSTANCE.getActionRegistry().get((Object)spell.getAction()) == null) {
                    throw new WordNotFoundException(spell.getAction());
                }
                Iterable $this$map$iv = spell.getDescriptors();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Descriptor descriptor = (Descriptor)WordRegistry.INSTANCE.getDescriptorRegistry().get((Object)it);
                    if (descriptor == null) {
                        throw new WordNotFoundException((String)it);
                    }
                    collection.add(descriptor);
                }
                List descriptors = (List)destination$iv$iv;
                Collection collection = spells;
                Collection $this$toTypedArray$iv = descriptors;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Descriptor[] descriptorArray = thisCollection$iv.toArray(new Descriptor[0]);
                collection.add(new PartialSpell(action, Arrays.copyOf(descriptorArray, descriptorArray.length)));
            }
            HashBiMap<String, Subject> hashBiMap = WordRegistry.INSTANCE.getSubjectRegistry();
            SpellResource spellResource2 = this.spell;
            Intrinsics.checkNotNull((Object)spellResource2);
            Subject subject = (Subject)hashBiMap.get((Object)spellResource2.getSubject());
            if (subject == null) {
                SpellResource spellResource3 = this.spell;
                Intrinsics.checkNotNull((Object)spellResource3);
                throw new WordNotFoundException(spellResource3.getSubject());
            }
            Collection $this$toTypedArray$iv = spells;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PartialSpell[] partialSpellArray = thisCollection$iv.toArray(new PartialSpell[0]);
            return new Spell(subject, Arrays.copyOf(partialSpellArray, partialSpellArray.length));
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/ssblur/scriptor/resources/Engravings$EngravingResource$PartialSpellResource;", "", "action", "", "descriptors", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getAction", "()Ljava/lang/String;", "setAction", "(Ljava/lang/String;)V", "getDescriptors", "()Ljava/util/List;", "setDescriptors", "(Ljava/util/List;)V", "scriptor"})
        public static final class PartialSpellResource {
            @NotNull
            private String action;
            @NotNull
            private List<String> descriptors;

            public PartialSpellResource(@NotNull String action, @NotNull List<String> descriptors) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
                this.action = action;
                this.descriptors = descriptors;
            }

            @NotNull
            public final String getAction() {
                return this.action;
            }

            public final void setAction(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.action = string;
            }

            @NotNull
            public final List<String> getDescriptors() {
                return this.descriptors;
            }

            public final void setDescriptors(@NotNull List<String> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.descriptors = list;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/ssblur/scriptor/resources/Engravings$EngravingResource$SpellResource;", "", "subject", "", "spells", "", "Lcom/ssblur/scriptor/resources/Engravings$EngravingResource$PartialSpellResource;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getSubject", "()Ljava/lang/String;", "setSubject", "(Ljava/lang/String;)V", "getSpells", "()Ljava/util/List;", "setSpells", "(Ljava/util/List;)V", "scriptor"})
        public static final class SpellResource {
            @NotNull
            private String subject;
            @NotNull
            private List<PartialSpellResource> spells;

            public SpellResource(@NotNull String subject, @NotNull List<PartialSpellResource> spells) {
                Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
                Intrinsics.checkNotNullParameter(spells, (String)"spells");
                this.subject = subject;
                this.spells = spells;
            }

            @NotNull
            public final String getSubject() {
                return this.subject;
            }

            public final void setSubject(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.subject = string;
            }

            @NotNull
            public final List<PartialSpellResource> getSpells() {
                return this.spells;
            }

            public final void setSpells(@NotNull List<PartialSpellResource> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.spells = list;
            }
        }
    }
}

