/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.registry;

import com.google.gson.JsonObject;
import com.ssblur.scriptor.helpers.generators.CommunityModeGenerator;
import com.ssblur.scriptor.helpers.generators.DebugGenerator;
import com.ssblur.scriptor.helpers.generators.MixedGroupGenerator;
import com.ssblur.scriptor.helpers.generators.StaticTokenGenerator;
import com.ssblur.scriptor.helpers.generators.TokenGenerator;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0017J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00172\u0006\u0010 \u001a\u00020\u000fJ\u0018\u0010#\u001a\u00020$2\b\u0010 \u001a\u0004\u0018\u00010\u00062\u0006\u0010%\u001a\u00020\u0007J\u0012\u0010&\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\u0006J\"\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\u000f2\b\u0010%\u001a\u0004\u0018\u00010\u00062\b\u0010)\u001a\u0004\u0018\u00010\u0013J\u0010\u0010*\u001a\u0004\u0018\u00010\u00062\u0006\u0010(\u001a\u00020\u000fJ\u0010\u0010+\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0006J\u001c\u0010,\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000f2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\u0013H\u0007R<\u0010\u0004\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\bj\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u0007`\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR<\u0010\u000e\u001a\"\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00060\bj\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0006`\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\fR<\u0010\u0012\u001a\"\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00130\bj\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0013`\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\fR8\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00170\bj\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0017`\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\u0018\u0010\n\"\u0004\b\u0019\u0010\fR\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010.\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00100R\u0011\u00103\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00100R\u0011\u00105\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00100\u00a8\u00067"}, d2={"Lcom/ssblur/scriptor/registry/TokenGeneratorRegistry;", "", "<init>", "()V", "generators", "Lkotlin/collections/HashMap;", "Lnet/minecraft/resources/ResourceLocation;", "Lcom/ssblur/scriptor/helpers/generators/TokenGenerator;", "Ljava/util/HashMap;", "getGenerators", "()Ljava/util/HashMap;", "setGenerators", "(Ljava/util/HashMap;)V", "Ljava/util/HashMap;", "generatorBindings", "", "getGeneratorBindings", "setGeneratorBindings", "generatorBindingConfig", "Lcom/google/gson/JsonObject;", "getGeneratorBindingConfig", "setGeneratorBindingConfig", "generatorGenerators", "Lcom/ssblur/scriptor/helpers/generators/TokenGenerator$TokenGeneratorGenerator;", "getGeneratorGenerators", "setGeneratorGenerators", "defaultGenerator", "getDefaultGenerator", "()Lnet/minecraft/resources/ResourceLocation;", "setDefaultGenerator", "(Lnet/minecraft/resources/ResourceLocation;)V", "registerGeneratorGenerator", "key", "generatorGenerator", "getGeneratorGenerator", "registerGenerator", "", "generator", "getGenerator", "registerBinding", "word", "parameters", "getBinding", "registerDefaultGenerator", "generateWord", "object", "MIXED_GROUP", "getMIXED_GROUP", "()Lcom/ssblur/scriptor/helpers/generators/TokenGenerator$TokenGeneratorGenerator;", "STATIC_TOKEN", "getSTATIC_TOKEN", "COMMUNITY", "getCOMMUNITY", "DEBUG", "getDEBUG", "scriptor"})
public final class TokenGeneratorRegistry {
    @NotNull
    public static final TokenGeneratorRegistry INSTANCE = new TokenGeneratorRegistry();
    @NotNull
    private static HashMap<ResourceLocation, TokenGenerator> generators = new HashMap();
    @NotNull
    private static HashMap<String, ResourceLocation> generatorBindings = new HashMap();
    @NotNull
    private static HashMap<String, JsonObject> generatorBindingConfig = new HashMap();
    @NotNull
    private static HashMap<String, TokenGenerator.TokenGeneratorGenerator> generatorGenerators = new HashMap();
    @Nullable
    private static ResourceLocation defaultGenerator;
    @NotNull
    private static final TokenGenerator.TokenGeneratorGenerator MIXED_GROUP;
    @NotNull
    private static final TokenGenerator.TokenGeneratorGenerator STATIC_TOKEN;
    @NotNull
    private static final TokenGenerator.TokenGeneratorGenerator COMMUNITY;
    @NotNull
    private static final TokenGenerator.TokenGeneratorGenerator DEBUG;

    private TokenGeneratorRegistry() {
    }

    @NotNull
    public final HashMap<ResourceLocation, TokenGenerator> getGenerators() {
        return generators;
    }

    public final void setGenerators(@NotNull HashMap<ResourceLocation, TokenGenerator> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        generators = hashMap;
    }

    @NotNull
    public final HashMap<String, ResourceLocation> getGeneratorBindings() {
        return generatorBindings;
    }

    public final void setGeneratorBindings(@NotNull HashMap<String, ResourceLocation> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        generatorBindings = hashMap;
    }

    @NotNull
    public final HashMap<String, JsonObject> getGeneratorBindingConfig() {
        return generatorBindingConfig;
    }

    public final void setGeneratorBindingConfig(@NotNull HashMap<String, JsonObject> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        generatorBindingConfig = hashMap;
    }

    @NotNull
    public final HashMap<String, TokenGenerator.TokenGeneratorGenerator> getGeneratorGenerators() {
        return generatorGenerators;
    }

    public final void setGeneratorGenerators(@NotNull HashMap<String, TokenGenerator.TokenGeneratorGenerator> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        generatorGenerators = hashMap;
    }

    @Nullable
    public final ResourceLocation getDefaultGenerator() {
        return defaultGenerator;
    }

    public final void setDefaultGenerator(@Nullable ResourceLocation resourceLocation) {
        defaultGenerator = resourceLocation;
    }

    @NotNull
    public final TokenGenerator.TokenGeneratorGenerator registerGeneratorGenerator(@NotNull String key, @NotNull TokenGenerator.TokenGeneratorGenerator generatorGenerator) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)generatorGenerator, (String)"generatorGenerator");
        ((Map)generatorGenerators).put(key, generatorGenerator);
        return generatorGenerator;
    }

    @Nullable
    public final TokenGenerator.TokenGeneratorGenerator getGeneratorGenerator(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return generatorGenerators.get(key);
    }

    public final void registerGenerator(@Nullable ResourceLocation key, @NotNull TokenGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        ((Map)generators).put(key, generator);
    }

    @Nullable
    public final TokenGenerator getGenerator(@Nullable ResourceLocation key) {
        return generators.get(key);
    }

    public final void registerBinding(@NotNull String word, @Nullable ResourceLocation generator, @Nullable JsonObject parameters) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        ((Map)generatorBindings).put(word, generator);
        ((Map)generatorBindingConfig).put(word, parameters);
    }

    @Nullable
    public final ResourceLocation getBinding(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return generatorBindings.getOrDefault(word, defaultGenerator);
    }

    public final void registerDefaultGenerator(@Nullable ResourceLocation generator) {
        defaultGenerator = generator;
    }

    @JvmOverloads
    @NotNull
    public final String generateWord(@NotNull String word, @Nullable JsonObject object) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        TokenGenerator tokenGenerator = this.getGenerator(this.getBinding(word));
        Intrinsics.checkNotNull((Object)tokenGenerator);
        return tokenGenerator.generateToken(word, object);
    }

    public static /* synthetic */ String generateWord$default(TokenGeneratorRegistry tokenGeneratorRegistry, String string, JsonObject jsonObject, int n, Object object) {
        if ((n & 2) != 0) {
            jsonObject = generatorBindingConfig.get(string);
        }
        return tokenGeneratorRegistry.generateWord(string, jsonObject);
    }

    @NotNull
    public final TokenGenerator.TokenGeneratorGenerator getMIXED_GROUP() {
        return MIXED_GROUP;
    }

    @NotNull
    public final TokenGenerator.TokenGeneratorGenerator getSTATIC_TOKEN() {
        return STATIC_TOKEN;
    }

    @NotNull
    public final TokenGenerator.TokenGeneratorGenerator getCOMMUNITY() {
        return COMMUNITY;
    }

    @NotNull
    public final TokenGenerator.TokenGeneratorGenerator getDEBUG() {
        return DEBUG;
    }

    @JvmOverloads
    @NotNull
    public final String generateWord(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return TokenGeneratorRegistry.generateWord$default(this, word, null, 2, null);
    }

    private static final TokenGenerator MIXED_GROUP$lambda$0(JsonObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new MixedGroupGenerator(it);
    }

    private static final TokenGenerator STATIC_TOKEN$lambda$1(JsonObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new StaticTokenGenerator(it);
    }

    private static final TokenGenerator COMMUNITY$lambda$2(JsonObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new CommunityModeGenerator(it);
    }

    private static final TokenGenerator DEBUG$lambda$3(JsonObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DebugGenerator(it);
    }

    static {
        MIXED_GROUP = INSTANCE.registerGeneratorGenerator("mixed_groups", TokenGeneratorRegistry::MIXED_GROUP$lambda$0);
        STATIC_TOKEN = INSTANCE.registerGeneratorGenerator("static_token", TokenGeneratorRegistry::STATIC_TOKEN$lambda$1);
        COMMUNITY = INSTANCE.registerGeneratorGenerator("community", TokenGeneratorRegistry::COMMUNITY$lambda$2);
        DEBUG = INSTANCE.registerGeneratorGenerator("debug", TokenGeneratorRegistry::DEBUG$lambda$3);
    }
}

