/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.network.server;

import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.block.ScriptorBlocks;
import com.ssblur.scriptor.blockentity.ChalkBlockEntity;
import com.ssblur.scriptor.blockentity.EngravingBlockEntity;
import com.ssblur.scriptor.data.components.BookOfBooksData;
import com.ssblur.scriptor.data.components.ScriptorDataComponents;
import com.ssblur.scriptor.data.saved_data.DictionarySavedData;
import com.ssblur.scriptor.helpers.LimitedBookSerializer;
import com.ssblur.scriptor.item.books.BookOfBooks;
import com.ssblur.scriptor.item.tools.Chalk;
import com.ssblur.scriptor.network.client.ScriptorNetworkS2C;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.scriptor.word.subject.InventorySubject;
import com.ssblur.unfocused.network.NetworkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006\u001a\u001b\u001c\u001d\u001e\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0019\u001a\u00020\u0007R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\t\u00a8\u0006 "}, d2={"Lcom/ssblur/scriptor/network/server/ScriptorNetworkC2S;", "", "<init>", "()V", "sendChalk", "Lkotlin/Function1;", "Lcom/ssblur/scriptor/network/server/ScriptorNetworkC2S$SendChalk;", "", "getSendChalk", "()Lkotlin/jvm/functions/Function1;", "creativeIdentify", "Lcom/ssblur/scriptor/network/server/ScriptorNetworkC2S$CreativeIdentify;", "getCreativeIdentify", "identify", "Lcom/ssblur/scriptor/network/server/ScriptorNetworkC2S$Identify;", "getIdentify", "creativeEnchant", "Lcom/ssblur/scriptor/network/server/ScriptorNetworkC2S$CreativeEnchant;", "getCreativeEnchant", "scroll", "Lcom/ssblur/scriptor/network/server/ScriptorNetworkC2S$Scroll;", "getScroll", "useBook", "Lcom/ssblur/scriptor/network/server/ScriptorNetworkC2S$UseBook;", "getUseBook", "register", "SendChalk", "CreativeIdentify", "Identify", "CreativeEnchant", "Scroll", "UseBook", "scriptor"})
public final class ScriptorNetworkC2S {
    @NotNull
    public static final ScriptorNetworkC2S INSTANCE = new ScriptorNetworkC2S();
    @NotNull
    private static final Function1<SendChalk, Unit> sendChalk;
    @NotNull
    private static final Function1<CreativeIdentify, Unit> creativeIdentify;
    @NotNull
    private static final Function1<Identify, Unit> identify;
    @NotNull
    private static final Function1<CreativeEnchant, Unit> creativeEnchant;
    @NotNull
    private static final Function1<Scroll, Unit> scroll;
    @NotNull
    private static final Function1<UseBook, Unit> useBook;

    private ScriptorNetworkC2S() {
    }

    @NotNull
    public final Function1<SendChalk, Unit> getSendChalk() {
        return sendChalk;
    }

    @NotNull
    public final Function1<CreativeIdentify, Unit> getCreativeIdentify() {
        return creativeIdentify;
    }

    @NotNull
    public final Function1<Identify, Unit> getIdentify() {
        return identify;
    }

    @NotNull
    public final Function1<CreativeEnchant, Unit> getCreativeEnchant() {
        return creativeEnchant;
    }

    @NotNull
    public final Function1<Scroll, Unit> getScroll() {
        return scroll;
    }

    @NotNull
    public final Function1<UseBook, Unit> getUseBook() {
        return useBook;
    }

    public final void register() {
    }

    private static final void sendChalk$lambda$0(SendChalk payload, ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!(itemStack.getItem() instanceof Chalk)) {
            itemStack = player.getItemInHand(InteractionHand.OFF_HAND);
        }
        if (!(itemStack.getItem() instanceof Chalk)) {
            return;
        }
        BlockPos pos = payload.getHitResult().getBlockPos().relative(payload.getHitResult().getDirection());
        if (player.level().getBlockState(pos).canBeReplaced()) {
            Level level = player.level();
            ChalkBlockEntity blockEntity = null;
            if (payload.getPermanent()) {
                level.setBlock(pos, ((Block)ScriptorBlocks.INSTANCE.getENGRAVING().get()).defaultBlockState(), 11);
                Intrinsics.checkNotNull((Object)pos);
                BlockState blockState = level.getBlockState(pos);
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
                blockEntity = new EngravingBlockEntity(pos, blockState);
            } else {
                level.setBlock(pos, ((Block)ScriptorBlocks.INSTANCE.getCHALK().get()).defaultBlockState(), 11);
                Intrinsics.checkNotNull((Object)pos);
                BlockState blockState = level.getBlockState(pos);
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
                blockEntity = new ChalkBlockEntity(pos, blockState);
            }
            blockEntity.setWord(itemStack.getHoverName().getString());
            blockEntity.setFacing(player.getDirection());
            level.setBlockEntity((BlockEntity)blockEntity);
            BlockState blockState = level.getBlockState(pos);
            level.sendBlockUpdated(pos, blockState, blockState, 11);
        }
    }

    private static final void creativeIdentify$lambda$1(CreativeIdentify payload, ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Level level = player.level();
        if (level instanceof ServerLevel) {
            List<String> list = DictionarySavedData.Companion.computeIfAbsent((ServerLevel)level).parseComponents(payload.getSpell());
            if (list == null) {
                return;
            }
            List<String> tokens = list;
            ScriptorNetworkS2C.INSTANCE.getIdentify().invoke((Object)new ScriptorNetworkS2C.Identify(CollectionsKt.filterNotNull((Iterable)tokens), payload.getSlot()), (Object)CollectionsKt.listOf((Object)player));
        }
    }

    private static final void identify$lambda$2(Identify payload, ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Level level = player.level();
        Object object = player.containerMenu.getItems().get(payload.getSlot());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ItemStack item = (ItemStack)object;
        ItemStack carried = player.containerMenu.getCarried();
        if (carried.isEmpty()) {
            return;
        }
        WrittenBookContent text = (WrittenBookContent)item.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (text != null && level instanceof ServerLevel) {
            List list = DictionarySavedData.Companion.computeIfAbsent((ServerLevel)level).parseComponents(LimitedBookSerializer.INSTANCE.decodeText(text));
            if (list == null || (list = CollectionsKt.filterNotNull((Iterable)list)) == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) {
                return;
            }
            List tokens = list;
            List identified = (List)item.get(ScriptorDataComponents.INSTANCE.getIDENTIFIED());
            identified = identified == null ? new ArrayList() : new ArrayList(identified);
            for (String token : tokens) {
                if (((ArrayList)identified).contains(token)) continue;
                ((Collection)identified).add(token);
            }
            item.set(ScriptorDataComponents.INSTANCE.getIDENTIFIED(), (Object)identified);
            carried.shrink(1);
            player.getCooldowns().addCooldown(carried.getItem(), 10);
        }
    }

    private static final void creativeEnchant$lambda$4(CreativeEnchant payload, ServerPlayer player) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            WrittenBookContent writtenBookContent = (WrittenBookContent)payload.getItem().get(DataComponents.WRITTEN_BOOK_CONTENT);
            if (writtenBookContent == null) {
                return;
            }
            WrittenBookContent text = writtenBookContent;
            Level level = player.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            List list = DictionarySavedData.Companion.computeIfAbsent((ServerLevel)level).parseComponents(LimitedBookSerializer.INSTANCE.decodeText(text));
            if (list == null || (list = CollectionsKt.filterNotNull((Iterable)list)) == null) break block1;
            List it = list;
            boolean bl = false;
            ScriptorNetworkS2C.INSTANCE.getCreativeBook().invoke((Object)new ScriptorNetworkS2C.CreativeBook(it, payload.getSlot()), (Object)CollectionsKt.listOf((Object)player));
        }
    }

    private static final void scroll$lambda$5(Scroll payload, ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack item = player.getItemInHand(payload.getHand());
        if (item.getItem() instanceof BookOfBooks) {
            BookOfBooksData bookOfBooksData = (BookOfBooksData)item.get(ScriptorDataComponents.INSTANCE.getBOOK_OF_BOOKS());
            if (bookOfBooksData == null) {
                return;
            }
            BookOfBooksData book = bookOfBooksData;
            List<ItemStack> list = book.items();
            if (list.isEmpty()) {
                return;
            }
            int slot = book.active();
            slot += (int)Math.signum(payload.getAmount()) + list.size();
            item.set(ScriptorDataComponents.INSTANCE.getBOOK_OF_BOOKS(), (Object)new BookOfBooksData(list, slot %= list.size()));
        }
    }

    private static final void useBook$lambda$6(UseBook payload, ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Level level = player.level();
        int slot = payload.getSlot();
        Object object = player.containerMenu.getItems().get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ItemStack item = (ItemStack)object;
        ItemStack carried = player.containerMenu.getCarried();
        if (carried.isEmpty()) {
            return;
        }
        WrittenBookContent text = (WrittenBookContent)carried.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (text != null && level instanceof ServerLevel) {
            Spell spell = DictionarySavedData.Companion.computeIfAbsent((ServerLevel)level).parse(LimitedBookSerializer.INSTANCE.decodeText(text));
            if (spell == null) {
                return;
            }
            Spell spell2 = spell;
            if (spell2.getSubject() instanceof InventorySubject) {
                Subject subject = spell2.getSubject();
                Intrinsics.checkNotNull((Object)subject, (String)"null cannot be cast to non-null type com.ssblur.scriptor.word.subject.InventorySubject");
                ((InventorySubject)((Object)subject)).castOnItem(spell2, (Player)player, item);
                player.getCooldowns().addCooldown(carried.getItem(), (int)Math.round(spell2.cost() * (double)7));
            }
        }
    }

    static {
        ResourceLocation resourceLocation = ScriptorMod.INSTANCE.location("server_receive_chalk_message");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        sendChalk = NetworkManager.INSTANCE.registerC2S(resourceLocation, Reflection.getOrCreateKotlinClass(SendChalk.class), ScriptorNetworkC2S::sendChalk$lambda$0);
        ResourceLocation resourceLocation2 = ScriptorMod.INSTANCE.location("server_cursor_use_scrollc");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"location(...)");
        creativeIdentify = NetworkManager.INSTANCE.registerC2S(resourceLocation2, Reflection.getOrCreateKotlinClass(CreativeIdentify.class), ScriptorNetworkC2S::creativeIdentify$lambda$1);
        ResourceLocation resourceLocation3 = ScriptorMod.INSTANCE.location("server_cursor_use_scroll");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"location(...)");
        identify = NetworkManager.INSTANCE.registerC2S(resourceLocation3, Reflection.getOrCreateKotlinClass(Identify.class), ScriptorNetworkC2S::identify$lambda$2);
        ResourceLocation resourceLocation4 = ScriptorMod.INSTANCE.location("server_cursor_use_bookc");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation4, (String)"location(...)");
        creativeEnchant = NetworkManager.INSTANCE.registerC2S(resourceLocation4, Reflection.getOrCreateKotlinClass(CreativeEnchant.class), ScriptorNetworkC2S::creativeEnchant$lambda$4);
        ResourceLocation resourceLocation5 = ScriptorMod.INSTANCE.location("server_scroll_networkc");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation5, (String)"location(...)");
        scroll = NetworkManager.INSTANCE.registerC2S(resourceLocation5, Reflection.getOrCreateKotlinClass(Scroll.class), ScriptorNetworkC2S::scroll$lambda$5);
        ResourceLocation resourceLocation6 = ScriptorMod.INSTANCE.location("server_cursor_use_book");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation6, (String)"location(...)");
        useBook = NetworkManager.INSTANCE.registerC2S(resourceLocation6, Reflection.getOrCreateKotlinClass(UseBook.class), ScriptorNetworkC2S::useBook$lambda$6);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/ssblur/scriptor/network/server/ScriptorNetworkC2S$CreativeEnchant;", "", "slot", "", "item", "Lnet/minecraft/world/item/ItemStack;", "<init>", "(ILnet/minecraft/world/item/ItemStack;)V", "getSlot", "()I", "getItem", "()Lnet/minecraft/world/item/ItemStack;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "scriptor"})
    public static final class CreativeEnchant {
        private final int slot;
        @NotNull
        private final ItemStack item;

        public CreativeEnchant(int slot, @NotNull ItemStack item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            this.slot = slot;
            this.item = item;
        }

        public final int getSlot() {
            return this.slot;
        }

        @NotNull
        public final ItemStack getItem() {
            return this.item;
        }

        public final int component1() {
            return this.slot;
        }

        @NotNull
        public final ItemStack component2() {
            return this.item;
        }

        @NotNull
        public final CreativeEnchant copy(int slot, @NotNull ItemStack item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return new CreativeEnchant(slot, item);
        }

        public static /* synthetic */ CreativeEnchant copy$default(CreativeEnchant creativeEnchant, int n, ItemStack itemStack, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = creativeEnchant.slot;
            }
            if ((n2 & 2) != 0) {
                itemStack = creativeEnchant.item;
            }
            return creativeEnchant.copy(n, itemStack);
        }

        @NotNull
        public String toString() {
            return "CreativeEnchant(slot=" + this.slot + ", item=" + this.item + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.slot);
            result = result * 31 + this.item.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CreativeEnchant)) {
                return false;
            }
            CreativeEnchant creativeEnchant = (CreativeEnchant)other;
            if (this.slot != creativeEnchant.slot) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.item, (Object)creativeEnchant.item);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/ssblur/scriptor/network/server/ScriptorNetworkC2S$CreativeIdentify;", "", "slot", "", "spell", "", "<init>", "(ILjava/lang/String;)V", "getSlot", "()I", "getSpell", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "scriptor"})
    public static final class CreativeIdentify {
        private final int slot;
        @NotNull
        private final String spell;

        public CreativeIdentify(int slot, @NotNull String spell) {
            Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
            this.slot = slot;
            this.spell = spell;
        }

        public final int getSlot() {
            return this.slot;
        }

        @NotNull
        public final String getSpell() {
            return this.spell;
        }

        public final int component1() {
            return this.slot;
        }

        @NotNull
        public final String component2() {
            return this.spell;
        }

        @NotNull
        public final CreativeIdentify copy(int slot, @NotNull String spell) {
            Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
            return new CreativeIdentify(slot, spell);
        }

        public static /* synthetic */ CreativeIdentify copy$default(CreativeIdentify creativeIdentify, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = creativeIdentify.slot;
            }
            if ((n2 & 2) != 0) {
                string = creativeIdentify.spell;
            }
            return creativeIdentify.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "CreativeIdentify(slot=" + this.slot + ", spell=" + this.spell + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.slot);
            result = result * 31 + this.spell.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CreativeIdentify)) {
                return false;
            }
            CreativeIdentify creativeIdentify = (CreativeIdentify)other;
            if (this.slot != creativeIdentify.slot) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.spell, (Object)creativeIdentify.spell);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/ssblur/scriptor/network/server/ScriptorNetworkC2S$Identify;", "", "slot", "", "<init>", "(I)V", "getSlot", "()I", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "scriptor"})
    public static final class Identify {
        private final int slot;

        public Identify(int slot) {
            this.slot = slot;
        }

        public final int getSlot() {
            return this.slot;
        }

        public final int component1() {
            return this.slot;
        }

        @NotNull
        public final Identify copy(int slot) {
            return new Identify(slot);
        }

        public static /* synthetic */ Identify copy$default(Identify identify, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = identify.slot;
            }
            return identify.copy(n);
        }

        @NotNull
        public String toString() {
            return "Identify(slot=" + this.slot + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.slot);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Identify)) {
                return false;
            }
            Identify identify = (Identify)other;
            return this.slot == identify.slot;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/ssblur/scriptor/network/server/ScriptorNetworkC2S$Scroll;", "", "hand", "Lnet/minecraft/world/InteractionHand;", "amount", "", "<init>", "(Lnet/minecraft/world/InteractionHand;D)V", "getHand", "()Lnet/minecraft/world/InteractionHand;", "getAmount", "()D", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "scriptor"})
    public static final class Scroll {
        @NotNull
        private final InteractionHand hand;
        private final double amount;

        public Scroll(@NotNull InteractionHand hand, double amount) {
            Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
            this.hand = hand;
            this.amount = amount;
        }

        @NotNull
        public final InteractionHand getHand() {
            return this.hand;
        }

        public final double getAmount() {
            return this.amount;
        }

        @NotNull
        public final InteractionHand component1() {
            return this.hand;
        }

        public final double component2() {
            return this.amount;
        }

        @NotNull
        public final Scroll copy(@NotNull InteractionHand hand, double amount) {
            Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
            return new Scroll(hand, amount);
        }

        public static /* synthetic */ Scroll copy$default(Scroll scroll, InteractionHand interactionHand, double d, int n, Object object) {
            if ((n & 1) != 0) {
                interactionHand = scroll.hand;
            }
            if ((n & 2) != 0) {
                d = scroll.amount;
            }
            return scroll.copy(interactionHand, d);
        }

        @NotNull
        public String toString() {
            return "Scroll(hand=" + this.hand + ", amount=" + this.amount + ")";
        }

        public int hashCode() {
            int result = this.hand.hashCode();
            result = result * 31 + Double.hashCode(this.amount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Scroll)) {
                return false;
            }
            Scroll scroll = (Scroll)other;
            if (this.hand != scroll.hand) {
                return false;
            }
            return Double.compare(this.amount, scroll.amount) == 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/ssblur/scriptor/network/server/ScriptorNetworkC2S$SendChalk;", "", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "permanent", "", "<init>", "(Lnet/minecraft/world/phys/BlockHitResult;Z)V", "getHitResult", "()Lnet/minecraft/world/phys/BlockHitResult;", "getPermanent", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "scriptor"})
    public static final class SendChalk {
        @NotNull
        private final BlockHitResult hitResult;
        private final boolean permanent;

        public SendChalk(@NotNull BlockHitResult hitResult, boolean permanent) {
            Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
            this.hitResult = hitResult;
            this.permanent = permanent;
        }

        @NotNull
        public final BlockHitResult getHitResult() {
            return this.hitResult;
        }

        public final boolean getPermanent() {
            return this.permanent;
        }

        @NotNull
        public final BlockHitResult component1() {
            return this.hitResult;
        }

        public final boolean component2() {
            return this.permanent;
        }

        @NotNull
        public final SendChalk copy(@NotNull BlockHitResult hitResult, boolean permanent) {
            Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
            return new SendChalk(hitResult, permanent);
        }

        public static /* synthetic */ SendChalk copy$default(SendChalk sendChalk, BlockHitResult blockHitResult, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                blockHitResult = sendChalk.hitResult;
            }
            if ((n & 2) != 0) {
                bl = sendChalk.permanent;
            }
            return sendChalk.copy(blockHitResult, bl);
        }

        @NotNull
        public String toString() {
            return "SendChalk(hitResult=" + this.hitResult + ", permanent=" + this.permanent + ")";
        }

        public int hashCode() {
            int result = this.hitResult.hashCode();
            result = result * 31 + Boolean.hashCode(this.permanent);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SendChalk)) {
                return false;
            }
            SendChalk sendChalk = (SendChalk)other;
            if (!Intrinsics.areEqual((Object)this.hitResult, (Object)sendChalk.hitResult)) {
                return false;
            }
            return this.permanent == sendChalk.permanent;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/ssblur/scriptor/network/server/ScriptorNetworkC2S$UseBook;", "", "slot", "", "<init>", "(I)V", "getSlot", "()I", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "scriptor"})
    public static final class UseBook {
        private final int slot;

        public UseBook(int slot) {
            this.slot = slot;
        }

        public final int getSlot() {
            return this.slot;
        }

        public final int component1() {
            return this.slot;
        }

        @NotNull
        public final UseBook copy(int slot) {
            return new UseBook(slot);
        }

        public static /* synthetic */ UseBook copy$default(UseBook useBook, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = useBook.slot;
            }
            return useBook.copy(n);
        }

        @NotNull
        public String toString() {
            return "UseBook(slot=" + this.slot + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.slot);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UseBook)) {
                return false;
            }
            UseBook useBook = (UseBook)other;
            return this.slot == useBook.slot;
        }
    }
}

