/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.network.client;

import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.helpers.ParticleQueue;
import com.ssblur.scriptor.particle.MagicParticleData;
import com.ssblur.unfocused.network.NetworkManager;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u0012\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016R)\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/ssblur/scriptor/network/client/ParticleNetwork;", "", "<init>", "()V", "send", "Lkotlin/Function2;", "Lcom/ssblur/scriptor/network/client/ParticleNetwork$Payload;", "", "Lnet/minecraft/world/entity/player/Player;", "", "getSend", "()Lkotlin/jvm/functions/Function2;", "fizzle", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "wither", "magicTrail", "color", "", "from", "Lnet/minecraft/world/phys/Vec3;", "to", "TYPE", "Payload", "scriptor"})
public final class ParticleNetwork {
    @NotNull
    public static final ParticleNetwork INSTANCE = new ParticleNetwork();
    @NotNull
    private static final Function2<Payload, List<? extends Player>, Unit> send;

    private ParticleNetwork() {
    }

    @NotNull
    public final Function2<Payload, List<? extends Player>, Unit> getSend() {
        return send;
    }

    public final void fizzle(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Payload payload = new Payload(TYPE.FIZZLE, 0, new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), null, 8, null);
        List list = level.players();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        send.invoke((Object)payload, (Object)list);
    }

    public final void wither(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Payload payload = new Payload(TYPE.WITHER, 0, new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), null, 8, null);
        List list = level.players();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        send.invoke((Object)payload, (Object)list);
    }

    public final void magicTrail(@NotNull Level level, int color, @NotNull Vec3 from, @NotNull Vec3 to) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Payload payload = new Payload(TYPE.MAGIC, color, from, to);
        List list = level.players();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        send.invoke((Object)payload, (Object)list);
    }

    private static final void send$lambda$0(Payload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Random random = new Random();
        TYPE type = payload.getParticleType();
        block0 : switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: {
                for (int i = 0; i < 9; ++i) {
                    ParticleQueue.queue$default(ParticleQueue.INSTANCE, (ParticleOptions)new DustParticleOptions(type.getColor(), 1.0f), payload.getFrom().x() - (double)0.25f + (double)random.nextFloat(1.5f), payload.getFrom().y() + (double)0.5f + (double)random.nextFloat(0.7f), payload.getFrom().z() - (double)0.25f + (double)random.nextFloat(1.5f), 0.0, 0.0, 0.0, 112, null);
                }
                break;
            }
            case 3: {
                int c = payload.getColor();
                CustomColors.RGB rGB = CustomColors.INSTANCE.splitIntoRGB(c);
                int r = rGB.component1();
                int g = rGB.component2();
                int b = rGB.component3();
                double steps = 16.0;
                int i = 1;
                int n = (int)steps;
                if (i > n) break;
                while (true) {
                    Vec3 vec3 = payload.getFrom();
                    Vec3 vec32 = payload.getTo();
                    Intrinsics.checkNotNull((Object)vec32);
                    Vec3 pos = vec3.lerp(vec32, (double)i / steps);
                    ParticleQueue.INSTANCE.queue(MagicParticleData.Companion.magic(r, g, b), pos.x(), pos.y(), pos.z(), 0.0, 0.0, 0.0);
                    if (i == n) break block0;
                    ++i;
                }
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    static {
        ResourceLocation resourceLocation = ScriptorMod.INSTANCE.location("client_particle");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        send = NetworkManager.INSTANCE.registerS2C(resourceLocation, Reflection.getOrCreateKotlinClass(Payload.class), ParticleNetwork::send$lambda$0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J3\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/ssblur/scriptor/network/client/ParticleNetwork$Payload;", "", "particleType", "Lcom/ssblur/scriptor/network/client/ParticleNetwork$TYPE;", "color", "", "from", "Lnet/minecraft/world/phys/Vec3;", "to", "<init>", "(Lcom/ssblur/scriptor/network/client/ParticleNetwork$TYPE;ILnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;)V", "getParticleType", "()Lcom/ssblur/scriptor/network/client/ParticleNetwork$TYPE;", "getColor", "()I", "getFrom", "()Lnet/minecraft/world/phys/Vec3;", "getTo", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "scriptor"})
    public static final class Payload {
        @NotNull
        private final TYPE particleType;
        private final int color;
        @NotNull
        private final Vec3 from;
        @Nullable
        private final Vec3 to;

        public Payload(@NotNull TYPE particleType, int color, @NotNull Vec3 from, @Nullable Vec3 to) {
            Intrinsics.checkNotNullParameter((Object)((Object)particleType), (String)"particleType");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            this.particleType = particleType;
            this.color = color;
            this.from = from;
            this.to = to;
        }

        public /* synthetic */ Payload(TYPE tYPE, int n, Vec3 vec3, Vec3 vec32, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                vec32 = null;
            }
            this(tYPE, n, vec3, vec32);
        }

        @NotNull
        public final TYPE getParticleType() {
            return this.particleType;
        }

        public final int getColor() {
            return this.color;
        }

        @NotNull
        public final Vec3 getFrom() {
            return this.from;
        }

        @Nullable
        public final Vec3 getTo() {
            return this.to;
        }

        @NotNull
        public final TYPE component1() {
            return this.particleType;
        }

        public final int component2() {
            return this.color;
        }

        @NotNull
        public final Vec3 component3() {
            return this.from;
        }

        @Nullable
        public final Vec3 component4() {
            return this.to;
        }

        @NotNull
        public final Payload copy(@NotNull TYPE particleType, int color, @NotNull Vec3 from, @Nullable Vec3 to) {
            Intrinsics.checkNotNullParameter((Object)((Object)particleType), (String)"particleType");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            return new Payload(particleType, color, from, to);
        }

        public static /* synthetic */ Payload copy$default(Payload payload, TYPE tYPE, int n, Vec3 vec3, Vec3 vec32, int n2, Object object) {
            if ((n2 & 1) != 0) {
                tYPE = payload.particleType;
            }
            if ((n2 & 2) != 0) {
                n = payload.color;
            }
            if ((n2 & 4) != 0) {
                vec3 = payload.from;
            }
            if ((n2 & 8) != 0) {
                vec32 = payload.to;
            }
            return payload.copy(tYPE, n, vec3, vec32);
        }

        @NotNull
        public String toString() {
            return "Payload(particleType=" + this.particleType + ", color=" + this.color + ", from=" + this.from + ", to=" + this.to + ")";
        }

        public int hashCode() {
            int result = this.particleType.hashCode();
            result = result * 31 + Integer.hashCode(this.color);
            result = result * 31 + this.from.hashCode();
            result = result * 31 + (this.to == null ? 0 : this.to.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Payload)) {
                return false;
            }
            Payload payload = (Payload)other;
            if (this.particleType != payload.particleType) {
                return false;
            }
            if (this.color != payload.color) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.from, (Object)payload.from)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.to, (Object)payload.to);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/ssblur/scriptor/network/client/ParticleNetwork$TYPE;", "", "color", "Lorg/joml/Vector3f;", "<init>", "(Ljava/lang/String;ILorg/joml/Vector3f;)V", "getColor", "()Lorg/joml/Vector3f;", "FIZZLE", "WITHER", "MAGIC", "scriptor"})
    public static final class TYPE
    extends Enum<TYPE> {
        @NotNull
        private final Vector3f color;
        public static final /* enum */ TYPE FIZZLE = new TYPE(new Vector3f(0.2f, 0.2f, 0.2f));
        public static final /* enum */ TYPE WITHER = new TYPE(new Vector3f(0.1f, 0.1f, 0.1f));
        public static final /* enum */ TYPE MAGIC = new TYPE(new Vector3f(0.0f, 0.0f, 0.0f));
        private static final /* synthetic */ TYPE[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private TYPE(Vector3f color) {
            this.color = color;
        }

        @NotNull
        public final Vector3f getColor() {
            return this.color;
        }

        public static TYPE[] values() {
            return (TYPE[])$VALUES.clone();
        }

        public static TYPE valueOf(String value) {
            return Enum.valueOf(TYPE.class, value);
        }

        @NotNull
        public static EnumEntries<TYPE> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = tYPEArray = new TYPE[]{TYPE.FIZZLE, TYPE.WITHER, TYPE.MAGIC};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TYPE.values().length];
            try {
                nArray[TYPE.FIZZLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TYPE.WITHER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TYPE.MAGIC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

