/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.item.books;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.data.components.ScriptorDataComponents;
import com.ssblur.scriptor.helpers.ComponentHelper;
import com.ssblur.scriptor.helpers.LimitedBookSerializer;
import com.ssblur.scriptor.helpers.SpellbookHelper;
import com.ssblur.scriptor.item.ScriptorTabs;
import com.ssblur.scriptor.item.books.BookOfBooks;
import com.ssblur.scriptor.item.interfaces.ItemWithCustomRenderer;
import com.ssblur.scriptor.network.server.ScriptorNetworkC2S;
import com.ssblur.unfocused.tab.CreativeTabs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0016J.\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J0\u0010 \u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0014H\u0016JZ\u0010&\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020'2\u0006\u0010#\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020(2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010,\u001a\u00020(2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020$H\u0016J2\u00102\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u00103\u001a\u00020$2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020$H\u0016\u00a8\u00064"}, d2={"Lcom/ssblur/scriptor/item/books/Spellbook;", "Lnet/minecraft/world/item/WrittenBookItem;", "Lcom/ssblur/scriptor/item/interfaces/ItemWithCustomRenderer;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "interactionHand", "Lnet/minecraft/world/InteractionHand;", "getName", "Lnet/minecraft/network/chat/Component;", "itemStack", "overrideStackedOnOther", "", "slot", "Lnet/minecraft/world/inventory/Slot;", "clickAction", "Lnet/minecraft/world/inventory/ClickAction;", "appendHoverText", "", "Lnet/minecraft/world/item/Item$TooltipContext;", "list", "", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "inventoryTick", "entity", "Lnet/minecraft/world/entity/Entity;", "i", "", "bl", "render", "Lnet/minecraft/client/player/AbstractClientPlayer;", "", "pitch", "hand", "swingProgress", "readyProgress", "matrix", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "lightLevel", "drawPage", "page", "scriptor"})
@SourceDebugExtension(value={"SMAP\nSpellbook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Spellbook.kt\ncom/ssblur/scriptor/item/books/Spellbook\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,247:1\n37#2,2:248\n*S KotlinDebug\n*F\n+ 1 Spellbook.kt\ncom/ssblur/scriptor/item/books/Spellbook\n*L\n104#1:248,2\n*E\n"})
public class Spellbook
extends WrittenBookItem
implements ItemWithCustomRenderer {
    public Spellbook(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        CreativeTabs.INSTANCE.tab((Item)this, ScriptorTabs.INSTANCE.getSCRIPTOR_SPELLBOOKS_TAB());
        SpellbookHelper.INSTANCE.setSPELLBOOKS(CollectionsKt.plus((Collection)SpellbookHelper.INSTANCE.getSPELLBOOKS(), (Object)this));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        if (level.isClientSide) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)player.getItemInHand(interactionHand));
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
            return interactionResultHolder;
        }
        ItemStack item = player.getItemInHand(interactionHand);
        Intrinsics.checkNotNull((Object)item);
        SpellbookHelper.castFromItem$default(SpellbookHelper.INSTANCE, item, player, null, null, null, 28, null);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)player.getItemInHand(interactionHand));
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
        return interactionResultHolder;
    }

    @NotNull
    public Component getName(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        String title = (String)itemStack.get(ScriptorDataComponents.INSTANCE.getTOME_NAME());
        if (title != null) {
            MutableComponent mutableComponent = Component.translatable((String)title);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            return (Component)mutableComponent;
        }
        Component component = super.getName(itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getName(...)");
        return component;
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack itemStack, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)clickAction, (String)"clickAction");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (Intrinsics.areEqual((Object)itemStack.get(ScriptorDataComponents.INSTANCE.getINVENTORY_CAST()), (Object)true) && clickAction == ClickAction.SECONDARY && !slot.getItem().isEmpty() && !(slot.getItem().getItem() instanceof BookOfBooks)) {
            if (player.getCooldowns().isOnCooldown((Item)this)) {
                return true;
            }
            Level level = player.level();
            if (!level.isClientSide) {
                return true;
            }
            if (player.isCreative()) {
                return false;
            }
            ScriptorNetworkC2S.INSTANCE.getUseBook().invoke((Object)new ScriptorNetworkC2S.UseBook(slot.index));
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        List identified;
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        super.appendHoverText(itemStack, level, list, tooltipFlag);
        if (itemStack.get(DataComponents.WRITTEN_BOOK_CONTENT) == null) {
            MutableComponent mutableComponent = Component.translatable((String)"lore.scriptor.no_spell").withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            list.add((Component)mutableComponent);
        }
        if ((identified = (List)itemStack.get(ScriptorDataComponents.INSTANCE.getIDENTIFIED())) != null) {
            if (Screen.hasShiftDown()) {
                for (String key : identified) {
                    void $this$toTypedArray$iv;
                    Object object = key;
                    Regex regex = new Regex(":");
                    int n = 2;
                    object = regex.split((CharSequence)object, n);
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] parts = thisCollection$iv.toArray(new String[0]);
                    if (parts.length == 2) {
                        ComponentHelper.INSTANCE.updateTooltipWith(list, parts[0] + ".scriptor." + parts[1], new Object[0]);
                        continue;
                    }
                    ScriptorMod.INSTANCE.getLOGGER().error("Invalid Identify entry: " + key);
                }
            } else {
                ComponentHelper.INSTANCE.updateTooltipWith(list, "extra.scriptor.tome_identified", new Object[0]);
            }
            ComponentHelper.INSTANCE.addCommunityDisclaimer(list, itemStack);
        }
    }

    public void inventoryTick(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Entity entity, int i, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!level.isClientSide && itemStack.get(ScriptorDataComponents.INSTANCE.getINVENTORY_CAST()) == null) {
            itemStack.set(ScriptorDataComponents.INSTANCE.getINVENTORY_CAST(), (Object)SpellbookHelper.INSTANCE.isInventoryCaster(itemStack, (ServerLevel)level));
        }
        super.inventoryTick(itemStack, level, entity, i, bl);
    }

    @Override
    public boolean render(@NotNull AbstractClientPlayer player, float i, float pitch, @NotNull InteractionHand hand, float swingProgress, @NotNull ItemStack itemStack, float readyProgress, @Nullable PoseStack matrix, @NotNull MultiBufferSource buffer, int lightLevel) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (matrix == null) {
            return false;
        }
        matrix.pushPose();
        boolean inRightHand = hand == InteractionHand.MAIN_HAND ^ player.getMainArm() == HumanoidArm.LEFT;
        float s = -0.4f * Mth.sin((float)(Mth.sqrt((float)swingProgress) * (float)Math.PI));
        float rxx = 0.2f * Mth.sin((float)(Mth.sqrt((float)swingProgress) * ((float)Math.PI * 2)));
        float lxxx = -0.2f * Mth.sin((float)(swingProgress * (float)Math.PI));
        float v = inRightHand ? 1.0f : -1.0f;
        matrix.translate(v * s, rxx, lxxx);
        matrix.translate(v * 0.56f, -0.52f + readyProgress * -0.6f, -0.72f);
        float g = Mth.sin((float)(swingProgress * swingProgress * (float)Math.PI));
        matrix.mulPose(Axis.YP.rotationDegrees(v * (45.0f + g * -20.0f)));
        float h = Mth.sin((float)(Mth.sqrt((float)swingProgress) * (float)Math.PI));
        matrix.mulPose(Axis.ZP.rotationDegrees(v * h * -20.0f));
        matrix.mulPose(Axis.XP.rotationDegrees(h * -80.0f));
        matrix.mulPose(Axis.YP.rotationDegrees(v * -45.0f));
        if (inRightHand) {
            Spellbook $this$render_u24lambda_u240 = this;
            boolean bl = false;
            matrix.pushPose();
            matrix.translate(-0.3, 0.4, 0.05);
            matrix.scale(0.003f, 0.003f, 0.003f);
            matrix.mulPose(Axis.ZP.rotationDegrees(183.0f));
            matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
            matrix.mulPose(Axis.XP.rotationDegrees(-48.5f));
            matrix.mulPose(Axis.YP.rotationDegrees(-25.0f));
            $this$render_u24lambda_u240.drawPage(itemStack, 0, matrix, buffer, lightLevel);
            matrix.popPose();
            Spellbook $this$render_u24lambda_u241 = this;
            boolean bl2 = false;
            matrix.pushPose();
            matrix.translate(-0.07f, 0.37f, 0.0f);
            matrix.scale(0.003f, 0.003f, 0.003f);
            matrix.mulPose(Axis.ZP.rotationDegrees(183.0f));
            matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
            matrix.mulPose(Axis.XP.rotationDegrees(-49.75f));
            matrix.mulPose(Axis.YP.rotationDegrees(20.0f));
            $this$render_u24lambda_u241.drawPage(itemStack, 1, matrix, buffer, lightLevel);
            matrix.popPose();
        } else {
            matrix.translate(0.31f, 0.0f, 0.0f);
            Spellbook $this$render_u24lambda_u242 = this;
            boolean bl = false;
            matrix.pushPose();
            matrix.translate(-0.31, 0.4, 0.05);
            matrix.scale(0.003f, 0.003f, 0.003f);
            matrix.mulPose(Axis.ZP.rotationDegrees(180.0f));
            matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
            matrix.mulPose(Axis.XP.rotationDegrees(-48.5f));
            matrix.mulPose(Axis.YP.rotationDegrees(-25.0f));
            $this$render_u24lambda_u242.drawPage(itemStack, 0, matrix, buffer, lightLevel);
            matrix.popPose();
            Spellbook $this$render_u24lambda_u243 = this;
            boolean bl3 = false;
            matrix.pushPose();
            matrix.translate(-0.07f, 0.38f, 0.0f);
            matrix.scale(0.003f, 0.003f, 0.003f);
            matrix.mulPose(Axis.ZP.rotationDegrees(183.0f));
            matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
            matrix.mulPose(Axis.XP.rotationDegrees(-49.75f));
            matrix.mulPose(Axis.YP.rotationDegrees(20.0f));
            $this$render_u24lambda_u243.drawPage(itemStack, 1, matrix, buffer, lightLevel);
            matrix.popPose();
        }
        matrix.popPose();
        return false;
    }

    public void drawPage(@NotNull ItemStack itemStack, int page, @Nullable PoseStack matrix, @NotNull MultiBufferSource buffer, int lightLevel) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (matrix == null) {
            return;
        }
        Font font = Minecraft.getInstance().font;
        WrittenBookContent tag = (WrittenBookContent)itemStack.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (tag != null) {
            List pages = tag.pages();
            List sequence = new ArrayList();
            if (page >= pages.size()) {
                String title = (String)itemStack.get(ScriptorDataComponents.INSTANCE.getTOME_NAME());
                if (title != null) {
                    List list = font.split(FormattedText.of((String)I18n.get((String)title, (Object[])new Object[0])), 80);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"split(...)");
                    v1 = sequence.addAll(list);
                } else {
                    List list = font.split(FormattedText.of((String)((String)tag.title().get(true))), 80);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"split(...)");
                    v1 = sequence.addAll(list);
                }
                List list = font.split(FormattedText.of((String)("By " + tag.author())), 80);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"split(...)");
                sequence.addAll(list);
            } else {
                sequence = font.split(FormattedText.of((String)LimitedBookSerializer.INSTANCE.decodeText(tag)), 80);
            }
            int n = ((Collection)sequence).size();
            for (int iter = 0; iter < n; ++iter) {
                Font font2 = Minecraft.getInstance().font;
                Object e = sequence.get(iter);
                Intrinsics.checkNotNull(e);
                font2.drawInBatch((FormattedCharSequence)e, -17.0f, (float)(-45 + 8 * iter), 0, false, matrix.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, lightLevel);
            }
        }
    }

    @Override
    public void worldRender(@NotNull AbstractClientPlayer player, @NotNull InteractionHand hand, @NotNull ItemStack itemStack, @Nullable PoseStack matrix, @NotNull MultiBufferSource buffer) {
        ItemWithCustomRenderer.DefaultImpls.worldRender(this, player, hand, itemStack, matrix, buffer);
    }
}

