/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.item.books;

import com.ssblur.scriptor.config.ScriptorConfig;
import com.ssblur.scriptor.data.components.ScriptorDataComponents;
import com.ssblur.scriptor.helpers.SpellbookHelper;
import com.ssblur.scriptor.item.ScriptorTabs;
import com.ssblur.scriptor.item.books.BookOfBooks;
import com.ssblur.scriptor.network.server.ScriptorNetworkC2S;
import com.ssblur.unfocused.tab.CreativeTabs;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006\u001f"}, d2={"Lcom/ssblur/scriptor/item/books/SpellScroll;", "Lnet/minecraft/world/item/WrittenBookItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "interactionHand", "Lnet/minecraft/world/InteractionHand;", "getName", "Lnet/minecraft/network/chat/Component;", "itemStack", "overrideStackedOnOther", "", "slot", "Lnet/minecraft/world/inventory/Slot;", "clickAction", "Lnet/minecraft/world/inventory/ClickAction;", "appendHoverText", "", "Lnet/minecraft/world/item/Item$TooltipContext;", "list", "", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "scriptor"})
public final class SpellScroll
extends WrittenBookItem {
    public SpellScroll(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        CreativeTabs.INSTANCE.tab((Item)this, ScriptorTabs.INSTANCE.getSCRIPTOR_SPELLBOOKS_TAB());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        if (level.isClientSide) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)player.getItemInHand(interactionHand));
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
            return interactionResultHolder;
        }
        ItemStack item = player.getItemInHand(interactionHand);
        Intrinsics.checkNotNull((Object)item);
        boolean result = SpellbookHelper.INSTANCE.castFromItem(item, player, (Integer)ScriptorConfig.INSTANCE.getSCROLL_MAX_COST().invoke(), (Integer)ScriptorConfig.INSTANCE.getSCROLL_COOLDOWN_MULTIPLIER().invoke(), (Function2<? super Player, ? super Integer, Unit>)((Function2)(arg_0, arg_1) -> SpellScroll.use$lambda$0(this, arg_0, arg_1)));
        if (result) {
            player.getItemInHand(interactionHand).shrink(1);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)player.getItemInHand(interactionHand));
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)player.getItemInHand(interactionHand));
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
        return interactionResultHolder;
    }

    @NotNull
    public Component getName(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        String title = (String)itemStack.get(ScriptorDataComponents.INSTANCE.getTOME_NAME());
        if (title != null) {
            MutableComponent mutableComponent = Component.translatable((String)title);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            return (Component)mutableComponent;
        }
        Component component = super.getName(itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getName(...)");
        return component;
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack itemStack, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)clickAction, (String)"clickAction");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (clickAction == ClickAction.SECONDARY && !slot.getItem().isEmpty() && !(slot.getItem().getItem() instanceof BookOfBooks)) {
            if (player.getCooldowns().isOnCooldown((Item)this)) {
                return true;
            }
            Level level = player.level();
            if (!level.isClientSide) {
                return true;
            }
            if (player.isCreative()) {
                return false;
            }
            ScriptorNetworkC2S.INSTANCE.getUseBook().invoke((Object)new ScriptorNetworkC2S.UseBook(slot.index));
            return true;
        }
        return false;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        super.appendHoverText(itemStack, level, list, tooltipFlag);
        if (itemStack.get(DataComponents.WRITTEN_BOOK_CONTENT) == null) {
            MutableComponent mutableComponent = Component.translatable((String)"lore.scriptor.no_spell").withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            list.add((Component)mutableComponent);
        }
        Component.translatable((String)"lore.scriptor.spell_scroll").withStyle(ChatFormatting.WHITE);
    }

    private static final Unit use$lambda$0(SpellScroll this$0, Player ply, int time) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ply, (String)"ply");
        ply.getCooldowns().addCooldown((Item)this$0, time);
        return Unit.INSTANCE;
    }
}

