/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.item.books;

import com.ssblur.scriptor.helpers.LimitedBookSerializer;
import com.ssblur.scriptor.item.books.Spellbook;
import com.ssblur.scriptor.network.server.ScriptorNetworkC2S;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/ssblur/scriptor/item/books/IdentifyScroll;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "overrideStackedOnOther", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "slot", "Lnet/minecraft/world/inventory/Slot;", "clickAction", "Lnet/minecraft/world/inventory/ClickAction;", "player", "Lnet/minecraft/world/entity/player/Player;", "appendHoverText", "", "level", "Lnet/minecraft/world/item/Item$TooltipContext;", "list", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "scriptor"})
public final class IdentifyScroll
extends Item {
    public IdentifyScroll(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean overrideStackedOnOther(@NotNull ItemStack itemStack, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)clickAction, (String)"clickAction");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (clickAction == ClickAction.SECONDARY && !slot.getItem().isEmpty() && slot.getItem().getItem() instanceof Spellbook) {
            if (player.getCooldowns().isOnCooldown((Item)this)) {
                return true;
            }
            Level level = player.level();
            if (!level.isClientSide) {
                return true;
            }
            if (player.isCreative()) {
                WrittenBookContent book;
                WrittenBookContent writtenBookContent = book = (WrittenBookContent)slot.getItem().get(DataComponents.WRITTEN_BOOK_CONTENT);
                if (writtenBookContent != null) {
                    WrittenBookContent it = writtenBookContent;
                    boolean bl = false;
                    String spell = LimitedBookSerializer.INSTANCE.decodeText(it);
                    ScriptorNetworkC2S.INSTANCE.getCreativeIdentify().invoke((Object)new ScriptorNetworkC2S.CreativeIdentify(slot.index, spell));
                    player.getCooldowns().addCooldown((Item)this, 10);
                }
            } else {
                ScriptorNetworkC2S.INSTANCE.getIdentify().invoke((Object)new ScriptorNetworkC2S.Identify(slot.index));
            }
            return true;
        }
        return false;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        super.appendHoverText(itemStack, level, list, tooltipFlag);
        MutableComponent mutableComponent = Component.translatable((String)"extra.scriptor.use_identify").withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        list.add((Component)mutableComponent);
    }
}

