/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.item.books;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ssblur.scriptor.data.components.BookOfBooksData;
import com.ssblur.scriptor.data.components.ScriptorDataComponents;
import com.ssblur.scriptor.helpers.SpellbookHelper;
import com.ssblur.scriptor.item.books.Spellbook;
import com.ssblur.scriptor.item.interfaces.ItemWithCustomRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0016J.\u0010\"\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0&2\u0006\u0010'\u001a\u00020(H\u0016JZ\u0010)\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020,2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u00100\u001a\u00020,2\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0006H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u00067"}, d2={"Lcom/ssblur/scriptor/item/books/BookOfBooks;", "Lnet/minecraft/world/item/Item;", "Lcom/ssblur/scriptor/item/interfaces/ItemWithCustomRenderer;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "capacity", "", "<init>", "(Lnet/minecraft/world/item/Item$Properties;I)V", "getCapacity", "()I", "setCapacity", "(I)V", "overrideOtherStackedOnMe", "", "book", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "slot", "Lnet/minecraft/world/inventory/Slot;", "clickAction", "Lnet/minecraft/world/inventory/ClickAction;", "player", "Lnet/minecraft/world/entity/player/Player;", "slotAccess", "Lnet/minecraft/world/entity/SlotAccess;", "getName", "Lnet/minecraft/network/chat/Component;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "level", "Lnet/minecraft/world/level/Level;", "interactionHand", "Lnet/minecraft/world/InteractionHand;", "appendHoverText", "", "Lnet/minecraft/world/item/Item$TooltipContext;", "list", "", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "render", "Lnet/minecraft/client/player/AbstractClientPlayer;", "i", "", "pitch", "hand", "swingProgress", "readyProgress", "matrix", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "lightLevel", "Companion", "scriptor"})
public final class BookOfBooks
extends Item
implements ItemWithCustomRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int capacity;

    public BookOfBooks(@NotNull Item.Properties properties, int capacity) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.capacity = capacity;
        SpellbookHelper.INSTANCE.setSPELLBOOKS(CollectionsKt.plus((Collection)SpellbookHelper.INSTANCE.getSPELLBOOKS(), (Object)this));
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final void setCapacity(int n) {
        this.capacity = n;
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack book, @NotNull ItemStack itemStack, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player, @NotNull SlotAccess slotAccess) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)clickAction, (String)"clickAction");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)slotAccess, (String)"slotAccess");
        if (clickAction != ClickAction.SECONDARY || !slot.allowModification(player)) {
            return false;
        }
        if (itemStack.isEmpty()) {
            Companion.remove(book, slotAccess);
        } else if (itemStack.getItem() instanceof Spellbook && Companion.getInventory(book).size() < this.capacity) {
            Companion.add(book, itemStack);
        } else {
            return false;
        }
        return true;
    }

    @NotNull
    public Component getName(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        ItemStack item = Companion.getActiveItem(itemStack);
        if (!item.isEmpty()) {
            Object[] objectArray = new Object[]{item.getHoverName().getString()};
            MutableComponent mutableComponent = Component.translatable((String)"item.scriptor.book_of_books_2", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            return (Component)mutableComponent;
        }
        Component component = super.getName(itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getName(...)");
        return component;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        InteractionResultHolder result = super.use(level, player, interactionHand);
        ItemStack book = player.getItemInHand(interactionHand);
        Intrinsics.checkNotNull((Object)book);
        boolean castResult = SpellbookHelper.castFromItem$default(SpellbookHelper.INSTANCE, Companion.getActiveItem(book), player, null, null, null, 28, null);
        if (castResult) {
            Intrinsics.checkNotNull((Object)result);
            return result;
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)player.getItemInHand(interactionHand));
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
        return interactionResultHolder;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        super.appendHoverText(itemStack, level, list, tooltipFlag);
        List<ItemStack> inventory = Companion.getInventory(itemStack);
        if (inventory.size() == 0) {
            MutableComponent mutableComponent = Component.translatable((String)"lore.scriptor.empty_book_1").withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            list.add((Component)mutableComponent);
            MutableComponent mutableComponent2 = Component.translatable((String)"lore.scriptor.empty_book_2").withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"withStyle(...)");
            list.add((Component)mutableComponent2);
        }
        int n = ((Collection)inventory).size();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            if (i == Companion.getActiveSlot(itemStack)) {
                Object[] objectArray = new Object[]{inventory.get(i).getHoverName().getString()};
                MutableComponent mutableComponent = Component.translatable((String)"lore.scriptor.active_book", (Object[])objectArray).withStyle(ChatFormatting.GREEN);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
                bl = list.add((Component)mutableComponent);
                continue;
            }
            MutableComponent mutableComponent = Component.literal((String)inventory.get(i).getHoverName().getString()).withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            bl = list.add((Component)mutableComponent);
        }
        MutableComponent mutableComponent = Component.translatable((String)"lore.scriptor.book_scroll").withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        list.add((Component)mutableComponent);
    }

    @Override
    public boolean render(@NotNull AbstractClientPlayer player, float i, float pitch, @NotNull InteractionHand hand, float swingProgress, @NotNull ItemStack itemStack, float readyProgress, @Nullable PoseStack matrix, @NotNull MultiBufferSource buffer, int lightLevel) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ItemStack itemStack2 = player.getItemInHand(hand);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItemInHand(...)");
        if (Companion.getActiveItem(itemStack2).getItem() instanceof ItemWithCustomRenderer) {
            ItemStack itemStack3 = player.getItemInHand(hand);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"getItemInHand(...)");
            Item item = Companion.getActiveItem(itemStack3).getItem();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.ssblur.scriptor.item.interfaces.ItemWithCustomRenderer");
            ItemWithCustomRenderer itemWithCustomRenderer = (ItemWithCustomRenderer)item;
            ItemStack itemStack4 = player.getItemInHand(hand);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"getItemInHand(...)");
            return itemWithCustomRenderer.render(player, i, pitch, hand, swingProgress, Companion.getActiveItem(itemStack4), readyProgress, matrix, buffer, lightLevel);
        }
        return false;
    }

    @Override
    public void worldRender(@NotNull AbstractClientPlayer player, @NotNull InteractionHand hand, @NotNull ItemStack itemStack, @Nullable PoseStack matrix, @NotNull MultiBufferSource buffer) {
        ItemWithCustomRenderer.DefaultImpls.worldRender(this, player, hand, itemStack, matrix, buffer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"Lcom/ssblur/scriptor/item/books/BookOfBooks$Companion;", "", "<init>", "()V", "getInventory", "", "Lnet/minecraft/world/item/ItemStack;", "book", "getActiveSlot", "", "getActiveItem", "remove", "", "slotAccess", "Lnet/minecraft/world/entity/SlotAccess;", "add", "item", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<ItemStack> getInventory(@NotNull ItemStack book) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            BookOfBooksData bookOfBooksData = (BookOfBooksData)book.get(ScriptorDataComponents.INSTANCE.getBOOK_OF_BOOKS());
            if (bookOfBooksData == null) {
                return CollectionsKt.emptyList();
            }
            BookOfBooksData data = bookOfBooksData;
            return data.items();
        }

        public final int getActiveSlot(@NotNull ItemStack book) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            BookOfBooksData bookOfBooksData = (BookOfBooksData)book.get(ScriptorDataComponents.INSTANCE.getBOOK_OF_BOOKS());
            if (bookOfBooksData == null) {
                return 0;
            }
            BookOfBooksData data = bookOfBooksData;
            return data.active();
        }

        @NotNull
        public final ItemStack getActiveItem(@NotNull ItemStack book) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            int slot = this.getActiveSlot(book);
            List<ItemStack> inventory = this.getInventory(book);
            if (inventory.isEmpty()) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            if (inventory.size() <= slot) {
                return inventory.get(inventory.size() - 1);
            }
            return inventory.get(slot);
        }

        public final void remove(@NotNull ItemStack book, @NotNull SlotAccess slotAccess) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            Intrinsics.checkNotNullParameter((Object)slotAccess, (String)"slotAccess");
            if (!slotAccess.get().isEmpty()) {
                return;
            }
            BookOfBooksData bookOfBooksData = (BookOfBooksData)book.get(ScriptorDataComponents.INSTANCE.getBOOK_OF_BOOKS());
            if (bookOfBooksData == null) {
                return;
            }
            BookOfBooksData data = bookOfBooksData;
            ArrayList list = new ArrayList(data.items());
            if (list.isEmpty()) {
                return;
            }
            ItemStack item = (ItemStack)list.remove(list.size() - 1);
            book.set(ScriptorDataComponents.INSTANCE.getBOOK_OF_BOOKS(), (Object)new BookOfBooksData(list, data.active()));
            slotAccess.set(item);
        }

        public final void add(@NotNull ItemStack book, @NotNull ItemStack item) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            if (item.isEmpty()) {
                return;
            }
            ItemStack insert = item.copyWithCount(1);
            item.shrink(1);
            BookOfBooksData data = (BookOfBooksData)book.get(ScriptorDataComponents.INSTANCE.getBOOK_OF_BOOKS());
            if (data == null) {
                data = new BookOfBooksData(CollectionsKt.emptyList(), 0);
            }
            List list = CollectionsKt.toMutableList((Collection)data.items());
            Intrinsics.checkNotNull((Object)insert);
            list.add(insert);
            book.set(ScriptorDataComponents.INSTANCE.getBOOK_OF_BOOKS(), (Object)new BookOfBooksData(list, data.active()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

