/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.item.books;

import com.ssblur.scriptor.advancement.ScriptorAdvancements;
import com.ssblur.scriptor.data.components.ScriptorDataComponents;
import com.ssblur.scriptor.data.saved_data.DictionarySavedData;
import com.ssblur.scriptor.helpers.LimitedBookSerializer;
import com.ssblur.scriptor.helpers.SpellbookHelper;
import com.ssblur.scriptor.resources.Tomes;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.unfocused.advancement.GenericTrigger;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\u0006\u0010\u0010\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/ssblur/scriptor/item/books/AncientSpellbook;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "tier", "", "<init>", "(Lnet/minecraft/world/item/Item$Properties;I)V", "getTier", "()I", "setTier", "(I)V", "appendHoverText", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/item/Item$TooltipContext;", "list", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "interactionHand", "Lnet/minecraft/world/InteractionHand;", "scriptor"})
public final class AncientSpellbook
extends Item {
    private int tier;

    public AncientSpellbook(@NotNull Item.Properties properties, int tier) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.tier = tier;
    }

    public final int getTier() {
        return this.tier;
    }

    public final void setTier(int n) {
        this.tier = n;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        super.appendHoverText(itemStack, level, list, tooltipFlag);
        MutableComponent mutableComponent = Component.translatable((String)"extra.scriptor.tome_description").withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        list.add((Component)mutableComponent);
        Object[] objectArray = new Object[]{this.tier};
        MutableComponent mutableComponent2 = Component.translatable((String)"extra.scriptor.tome_tier", (Object[])objectArray).withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"withStyle(...)");
        list.add((Component)mutableComponent2);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        InteractionResultHolder result = super.use(level, player, interactionHand);
        if (!level.isClientSide) {
            Tomes.TomeResource resource;
            ServerLevel server = (ServerLevel)level;
            player.sendSystemMessage((Component)Component.translatable((String)"extra.scriptor.tome_use"));
            if (!player.isCreative()) {
                player.getCooldowns().addCooldown((Item)this, 20);
            }
            if ((resource = Tomes.INSTANCE.getRandomTome(this.tier, player)).getSpell().getSpells().length > 1) {
                ((GenericTrigger)ScriptorAdvancements.INSTANCE.getCOMPLEX_SPELL().get()).trigger((ServerPlayer)player);
            }
            Spell spell = resource.getSpell();
            String sentence = DictionarySavedData.Companion.computeIfAbsent(server).generate(spell);
            ItemStack spellbook = LimitedBookSerializer.INSTANCE.createSpellbook(resource.getAuthor(), resource.getName(), sentence, resource.getItem());
            spellbook.set(ScriptorDataComponents.INSTANCE.getINVENTORY_CAST(), (Object)SpellbookHelper.INSTANCE.isInventoryCaster(spellbook, (ServerLevel)level));
            if (!player.addItem(spellbook)) {
                ItemEntity entity = new ItemEntity(level, player.getX(), player.getY() + 1.0, player.getZ() + 1.0, spellbook);
                ((ServerLevel)level).addFreshEntity((Entity)entity);
            }
            Object[] objectArray = new Object[]{Component.translatable((String)resource.getName())};
            player.sendSystemMessage((Component)Component.translatable((String)"extra.scriptor.spell_get", (Object[])objectArray));
            if (!player.isCreative()) {
                player.getItemInHand(interactionHand).shrink(1);
            }
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)player.getItemInHand(interactionHand));
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        Intrinsics.checkNotNull((Object)result);
        return result;
    }
}

