/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.item.books;

import com.ssblur.scriptor.resources.Scraps;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\u0006\u0010\u0010\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/ssblur/scriptor/item/books/AncientScrap;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "tier", "", "<init>", "(Lnet/minecraft/world/item/Item$Properties;I)V", "getTier", "()I", "setTier", "(I)V", "appendHoverText", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/item/Item$TooltipContext;", "list", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "interactionHand", "Lnet/minecraft/world/InteractionHand;", "scriptor"})
public final class AncientScrap
extends Item {
    private int tier;

    public AncientScrap(@NotNull Item.Properties properties, int tier) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.tier = tier;
    }

    public final int getTier() {
        return this.tier;
    }

    public final void setTier(int n) {
        this.tier = n;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        super.appendHoverText(itemStack, level, list, tooltipFlag);
        MutableComponent mutableComponent = Component.translatable((String)"extra.scriptor.scrap_description").withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        list.add((Component)mutableComponent);
        Object[] objectArray = new Object[]{this.tier};
        MutableComponent mutableComponent2 = Component.translatable((String)"extra.scriptor.scrap_tier", (Object[])objectArray).withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"withStyle(...)");
        list.add((Component)mutableComponent2);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        InteractionResultHolder result = super.use(level, player, interactionHand);
        if (!level.isClientSide) {
            ItemStack scrap;
            player.sendSystemMessage((Component)Component.translatable((String)"extra.scriptor.scrap_use"));
            if (!player.isCreative()) {
                player.getCooldowns().addCooldown((Item)this, 20);
            }
            if (!player.addItem(scrap = Scraps.INSTANCE.getRandomScrapItem(this.tier, player))) {
                ItemEntity entity = new ItemEntity(level, player.getX(), player.getY() + 1.0, player.getZ() + 1.0, scrap);
                level.addFreshEntity((Entity)entity);
            }
            player.sendSystemMessage((Component)Component.translatable((String)"extra.scriptor.scrap_get"));
            if (!player.isCreative()) {
                player.getItemInHand(interactionHand).shrink(1);
            }
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)player.getItemInHand(interactionHand));
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        Intrinsics.checkNotNull((Object)result);
        return result;
    }
}

