/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers.targetable;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\n\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\u000e\u0010\u000f\u001a\u00020#2\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010(\u001a\u00020\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0006\u0010+\u001a\u00020\u0000R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0000X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010$\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0013R\u0011\u0010&\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001bR\u0011\u0010)\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0013\u00a8\u0006,"}, d2={"Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/world/phys/Vec3;", "<init>", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;)V", "Lorg/joml/Vector3f;", "(Lnet/minecraft/world/level/Level;Lorg/joml/Vector3f;)V", "Lnet/minecraft/core/BlockPos;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "targetPos", "getTargetPos", "()Lnet/minecraft/world/phys/Vec3;", "setTargetPos", "(Lnet/minecraft/world/phys/Vec3;)V", "origin", "getOrigin", "()Lnet/minecraft/core/BlockPos;", "getLevel", "()Lnet/minecraft/world/level/Level;", "setLevel", "(Lnet/minecraft/world/level/Level;)V", "direction", "Lnet/minecraft/core/Direction;", "getDirection", "()Lnet/minecraft/core/Direction;", "setDirection", "(Lnet/minecraft/core/Direction;)V", "finalTargetable", "getFinalTargetable", "()Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "setFinalTargetable", "(Lcom/ssblur/scriptor/helpers/targetable/Targetable;)V", "", "targetBlockPos", "getTargetBlockPos", "facing", "getFacing", "setFacing", "offsetBlockPos", "getOffsetBlockPos", "simpleCopy", "scriptor"})
public class Targetable {
    @NotNull
    private Vec3 targetPos;
    @Nullable
    private final BlockPos origin;
    @NotNull
    private Level level;
    @Nullable
    private Direction direction;
    @Nullable
    private Targetable finalTargetable;

    @NotNull
    public final Vec3 getTargetPos() {
        return this.targetPos;
    }

    public final void setTargetPos(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.targetPos = vec3;
    }

    @Nullable
    public BlockPos getOrigin() {
        return this.origin;
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    public final void setLevel(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"<set-?>");
        this.level = level;
    }

    @Nullable
    public final Direction getDirection() {
        return this.direction;
    }

    public final void setDirection(@Nullable Direction direction) {
        this.direction = direction;
    }

    @Nullable
    public Targetable getFinalTargetable() {
        return this.finalTargetable;
    }

    public void setFinalTargetable(@Nullable Targetable targetable) {
        this.finalTargetable = targetable;
    }

    public Targetable(@NotNull Level level, @NotNull Vec3 pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.finalTargetable = this;
        this.targetPos = pos;
        this.level = level;
    }

    public Targetable(@NotNull Level level, @NotNull Vector3f pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.finalTargetable = this;
        this.targetPos = new Vec3((double)pos.x(), (double)pos.y(), (double)pos.z());
        this.level = level;
    }

    public Targetable(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.finalTargetable = this;
        this.targetPos = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        this.level = level;
    }

    public final void setTargetPos(@NotNull Vector3f targetPos) {
        Intrinsics.checkNotNullParameter((Object)targetPos, (String)"targetPos");
        this.targetPos = new Vec3((double)targetPos.x(), (double)targetPos.y(), (double)targetPos.z());
    }

    @NotNull
    public final BlockPos getTargetBlockPos() {
        return new BlockPos((int)Math.floor(this.targetPos.x), (int)Math.floor(this.targetPos.y), (int)Math.floor(this.targetPos.z));
    }

    @NotNull
    public final Direction getFacing() {
        if (this.direction != null) {
            Direction direction = this.direction;
            Intrinsics.checkNotNull((Object)direction);
            return direction;
        }
        return Direction.UP;
    }

    @NotNull
    public final Targetable setFacing(@Nullable Direction direction) {
        this.direction = direction;
        return this;
    }

    @NotNull
    public final BlockPos getOffsetBlockPos() {
        if (this.direction != null) {
            BlockPos blockPos = this.getTargetBlockPos();
            Direction direction = this.direction;
            Intrinsics.checkNotNull((Object)direction);
            BlockPos blockPos2 = blockPos.relative(direction.getOpposite());
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"relative(...)");
            return blockPos2;
        }
        return this.getTargetBlockPos();
    }

    @NotNull
    public final Targetable simpleCopy() {
        Targetable out = new Targetable(this.level, this.targetPos);
        out.setFacing(this.getFacing());
        return out;
    }
}

