/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers.targetable;

import com.ssblur.scriptor.blockentity.CastingLecternBlockEntity;
import com.ssblur.scriptor.helpers.targetable.InventoryTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0007\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/ssblur/scriptor/helpers/targetable/LecternTargetable;", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "Lcom/ssblur/scriptor/helpers/targetable/InventoryTargetable;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/world/phys/Vec3;", "<init>", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;)V", "Lorg/joml/Vector3f;", "(Lnet/minecraft/world/level/Level;Lorg/joml/Vector3f;)V", "Lnet/minecraft/core/BlockPos;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "targetedSlot", "", "getTargetedSlot", "()I", "setTargetedSlot", "(I)V", "container", "Lnet/minecraft/world/Container;", "getContainer", "()Lnet/minecraft/world/Container;", "origin", "getOrigin", "()Lnet/minecraft/core/BlockPos;", "scriptor"})
public final class LecternTargetable
extends Targetable
implements InventoryTargetable {
    private int targetedSlot;
    @Nullable
    private final Container container;

    @Override
    public int getTargetedSlot() {
        return this.targetedSlot;
    }

    @Override
    public void setTargetedSlot(int n) {
        this.targetedSlot = n;
    }

    public LecternTargetable(@NotNull Level level, @NotNull Vec3 pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        super(level, pos);
        this.setTargetedSlot(0);
    }

    public LecternTargetable(@NotNull Level level, @NotNull Vector3f pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        super(level, new Vec3((double)pos.x, (double)pos.y, (double)pos.z));
        this.setTargetedSlot(0);
    }

    public LecternTargetable(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        super(level, pos);
        this.setTargetedSlot(0);
    }

    @Override
    @Nullable
    public Container getContainer() {
        if (this.getLevel().getBlockEntity(this.getTargetBlockPos()) instanceof CastingLecternBlockEntity) {
            if (this.getLevel().getBlockEntity(this.getTargetBlockPos().below()) instanceof Container) {
                return this.container;
            }
            if (this.getLevel().getBlockEntity(this.getTargetBlockPos().relative(this.getFacing().getOpposite())) instanceof Container) {
                return this.container;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public BlockPos getOrigin() {
        return this.getTargetBlockPos();
    }

    @Override
    public boolean shouldIgnoreTargetedSlot() {
        return InventoryTargetable.DefaultImpls.shouldIgnoreTargetedSlot(this);
    }

    @Override
    public void useFirstMatchingSlot(@NotNull Predicate<ItemStack> predicate) {
        InventoryTargetable.DefaultImpls.useFirstMatchingSlot(this, predicate);
    }

    @Override
    public int getFirstMatchingSlot(@NotNull Predicate<ItemStack> predicate) {
        return InventoryTargetable.DefaultImpls.getFirstMatchingSlot((InventoryTargetable)this, predicate);
    }

    @Override
    public int getFirstMatchingSlot(@NotNull ItemStack itemStack) {
        return InventoryTargetable.DefaultImpls.getFirstMatchingSlot((InventoryTargetable)this, itemStack);
    }

    @Override
    public int getFirstFilledSlot() {
        return InventoryTargetable.DefaultImpls.getFirstFilledSlot(this);
    }

    @Override
    public int getFirstMatchingSlotNotEmpty(@NotNull ItemStack itemStack) {
        return InventoryTargetable.DefaultImpls.getFirstMatchingSlotNotEmpty(this, itemStack);
    }

    @Override
    public void useFirstFilledSlot() {
        InventoryTargetable.DefaultImpls.useFirstFilledSlot(this);
    }
}

