/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers.loot;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.ssblur.scriptor.data.components.ScriptorDataComponents;
import com.ssblur.scriptor.data.saved_data.DictionarySavedData;
import com.ssblur.scriptor.item.ScriptorLoot;
import com.ssblur.scriptor.resources.Artifacts;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/ssblur/scriptor/helpers/loot/ArtifactItemFunction;", "Lnet/minecraft/world/level/storage/loot/functions/LootItemFunction;", "<init>", "()V", "getType", "Lnet/minecraft/world/level/storage/loot/functions/LootItemFunctionType;", "apply", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "lootContext", "Lnet/minecraft/world/level/storage/loot/LootContext;", "ArtifactSerializer", "scriptor"})
public final class ArtifactItemFunction
implements LootItemFunction {
    @NotNull
    public LootItemFunctionType<?> getType() {
        return (LootItemFunctionType)ScriptorLoot.INSTANCE.getARTIFACT().get();
    }

    @NotNull
    public ItemStack apply(@NotNull ItemStack itemStack, @NotNull LootContext lootContext) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)lootContext, (String)"lootContext");
        Artifacts.ArtifactResource artifact = Artifacts.INSTANCE.getRandomArtifact();
        DataComponentType<String> dataComponentType = ScriptorDataComponents.INSTANCE.getSPELL();
        ServerLevel serverLevel = lootContext.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"getLevel(...)");
        itemStack.set(dataComponentType, (Object)DictionarySavedData.Companion.computeIfAbsent(serverLevel).generate(artifact.getSpell()));
        String string = artifact.getName();
        if (string == null) {
            string = "";
        }
        itemStack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)string));
        return itemStack;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J;\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\b0\u00070\u0006\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u000b\u001a\u0002H\bH\u0016\u00a2\u0006\u0002\u0010\fJ7\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\b0\u0006\"\u0004\b\u0000\u0010\b2\u0006\u0010\u000b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u000e\u001a\u0002H\bH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/ssblur/scriptor/helpers/loot/ArtifactItemFunction$ArtifactSerializer;", "Lcom/mojang/serialization/Codec;", "Lcom/ssblur/scriptor/helpers/loot/ArtifactItemFunction;", "<init>", "()V", "decode", "Lcom/mojang/serialization/DataResult;", "Lcom/mojang/datafixers/util/Pair;", "T", "ops", "Lcom/mojang/serialization/DynamicOps;", "input", "(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", "encode", "prefix", "(Lcom/ssblur/scriptor/helpers/loot/ArtifactItemFunction;Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", "scriptor"})
    public static final class ArtifactSerializer
    implements Codec<ArtifactItemFunction> {
        @NotNull
        public <T> DataResult<Pair<ArtifactItemFunction, T>> decode(@NotNull DynamicOps<T> ops, T input) {
            Intrinsics.checkNotNullParameter(ops, (String)"ops");
            DataResult dataResult = DataResult.success(null);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"success(...)");
            return dataResult;
        }

        @NotNull
        public <T> DataResult<T> encode(@NotNull ArtifactItemFunction input, @NotNull DynamicOps<T> ops, T prefix) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter(ops, (String)"ops");
            DataResult dataResult = DataResult.success(null);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"success(...)");
            return dataResult;
        }
    }
}

