/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers.generators;

import com.google.common.reflect.TypeToken;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ssblur.scriptor.helpers.generators.TokenGenerator;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0003\u0017\u0018\u0019B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/ssblur/scriptor/helpers/generators/MixedGroupGenerator;", "Lcom/ssblur/scriptor/helpers/generators/TokenGenerator;", "obj", "Lcom/google/gson/JsonObject;", "<init>", "(Lcom/google/gson/JsonObject;)V", "totalWeight", "", "getTotalWeight", "()I", "setTotalWeight", "(I)V", "parameters", "Lcom/ssblur/scriptor/helpers/generators/MixedGroupGenerator$MixedGroupParameters;", "getParameters", "()Lcom/ssblur/scriptor/helpers/generators/MixedGroupGenerator$MixedGroupParameters;", "setParameters", "(Lcom/ssblur/scriptor/helpers/generators/MixedGroupGenerator$MixedGroupParameters;)V", "canBeDefault", "", "generateToken", "", "key", "TokenGroup", "MixedGroupParameters", "Companion", "scriptor"})
@SourceDebugExtension(value={"SMAP\nMixedGroupGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MixedGroupGenerator.kt\ncom/ssblur/scriptor/helpers/generators/MixedGroupGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public final class MixedGroupGenerator
extends TokenGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int totalWeight;
    @Nullable
    private MixedGroupParameters parameters;
    @NotNull
    private static Type PARAMETERS_TYPE;
    @NotNull
    private static Gson GSON;
    @NotNull
    private static Random RANDOM;

    public MixedGroupGenerator(@Nullable JsonObject obj) {
        block1: {
            MixedGroupParameters mixedGroupParameters = this.parameters = (MixedGroupParameters)GSON.fromJson((JsonElement)obj, PARAMETERS_TYPE);
            if (mixedGroupParameters == null) break block1;
            MixedGroupParameters it = mixedGroupParameters;
            boolean bl = false;
            TokenGroup[] tokenGroupArray = it.groups();
            int n = tokenGroupArray.length;
            for (int i = 0; i < n; ++i) {
                int weight = tokenGroupArray[i].component2();
                this.totalWeight += weight;
            }
        }
    }

    public final int getTotalWeight() {
        return this.totalWeight;
    }

    public final void setTotalWeight(int n) {
        this.totalWeight = n;
    }

    @Nullable
    public final MixedGroupParameters getParameters() {
        return this.parameters;
    }

    public final void setParameters(@Nullable MixedGroupParameters mixedGroupParameters) {
        this.parameters = mixedGroupParameters;
    }

    @Override
    public boolean canBeDefault() {
        return true;
    }

    @Override
    @NotNull
    public String generateToken(@NotNull String key, @Nullable JsonObject parameters) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        MixedGroupParameters mixedGroupParameters = this.parameters;
        Intrinsics.checkNotNull((Object)mixedGroupParameters);
        int maxTokens = mixedGroupParameters.maxTokens();
        MixedGroupParameters mixedGroupParameters2 = this.parameters;
        Intrinsics.checkNotNull((Object)mixedGroupParameters2);
        int minTokens = mixedGroupParameters2.minTokens();
        MixedGroupParameters mixedGroupParameters3 = this.parameters;
        Intrinsics.checkNotNull((Object)mixedGroupParameters3);
        int maxConsecutiveGroups = mixedGroupParameters3.maxConsecutiveGroups();
        MixedGroupParameters mixedGroupParameters4 = this.parameters;
        Intrinsics.checkNotNull((Object)mixedGroupParameters4);
        if (mixedGroupParameters4.groups().length <= 1) {
            maxConsecutiveGroups = 0;
        }
        if (parameters != null) {
            if (parameters.has("max_tokens")) {
                maxTokens = parameters.get("max_tokens").getAsInt();
            }
            if (parameters.has("min_tokens")) {
                minTokens = parameters.get("min_tokens").getAsInt();
            }
        }
        int tokens = RANDOM.nextInt(minTokens, maxTokens + 1);
        StringBuilder builder = new StringBuilder();
        TokenGroup lastGroup = null;
        int consecutiveGroups = 0;
        for (int i = 0; i < tokens; ++i) {
            TokenGroup tokenGroup = null;
            block1: do {
                int random = RANDOM.nextInt(this.totalWeight);
                MixedGroupParameters mixedGroupParameters5 = this.parameters;
                Intrinsics.checkNotNull((Object)mixedGroupParameters5);
                for (TokenGroup group : mixedGroupParameters5.groups()) {
                    if (random < group.weight()) {
                        tokenGroup = group;
                        continue block1;
                    }
                    random -= group.weight();
                }
            } while (tokenGroup == null || maxConsecutiveGroups > 0 && lastGroup == tokenGroup && consecutiveGroups >= maxConsecutiveGroups);
            if (lastGroup != tokenGroup) {
                consecutiveGroups = 0;
                lastGroup = tokenGroup;
            }
            ++consecutiveGroups;
            String[] groupTokens = tokenGroup.tokens();
            builder.append(groupTokens[RANDOM.nextInt(groupTokens.length)]);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        Type type = new TypeToken<MixedGroupParameters>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
        PARAMETERS_TYPE = type;
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GSON = gson;
        RANDOM = new Random();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/ssblur/scriptor/helpers/generators/MixedGroupGenerator$Companion;", "", "<init>", "()V", "PARAMETERS_TYPE", "Ljava/lang/reflect/Type;", "getPARAMETERS_TYPE", "()Ljava/lang/reflect/Type;", "setPARAMETERS_TYPE", "(Ljava/lang/reflect/Type;)V", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "setGSON", "(Lcom/google/gson/Gson;)V", "RANDOM", "Ljava/util/Random;", "getRANDOM", "()Ljava/util/Random;", "setRANDOM", "(Ljava/util/Random;)V", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Type getPARAMETERS_TYPE() {
            return PARAMETERS_TYPE;
        }

        public final void setPARAMETERS_TYPE(@NotNull Type type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"<set-?>");
            PARAMETERS_TYPE = type;
        }

        @NotNull
        public final Gson getGSON() {
            return GSON;
        }

        public final void setGSON(@NotNull Gson gson) {
            Intrinsics.checkNotNullParameter((Object)gson, (String)"<set-?>");
            GSON = gson;
        }

        @NotNull
        public final Random getRANDOM() {
            return RANDOM;
        }

        public final void setRANDOM(@NotNull Random random) {
            Intrinsics.checkNotNullParameter((Object)random, (String)"<set-?>");
            RANDOM = random;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J<\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u0002\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\rR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/ssblur/scriptor/helpers/generators/MixedGroupGenerator$MixedGroupParameters;", "Ljava/lang/Record;", "groups", "", "Lcom/ssblur/scriptor/helpers/generators/MixedGroupGenerator$TokenGroup;", "maxConsecutiveGroups", "", "minTokens", "maxTokens", "<init>", "([Lcom/ssblur/scriptor/helpers/generators/MixedGroupGenerator$TokenGroup;III)V", "()[Lcom/ssblur/scriptor/helpers/generators/MixedGroupGenerator$TokenGroup;", "[Lcom/ssblur/scriptor/helpers/generators/MixedGroupGenerator$TokenGroup;", "()I", "component1", "component2", "component3", "component4", "copy", "([Lcom/ssblur/scriptor/helpers/generators/MixedGroupGenerator$TokenGroup;III)Lcom/ssblur/scriptor/helpers/generators/MixedGroupGenerator$MixedGroupParameters;", "equals", "", "other", "", "hashCode", "toString", "", "scriptor"})
    public static final class MixedGroupParameters
    extends Record {
        @NotNull
        private final TokenGroup[] groups;
        private final int maxConsecutiveGroups;
        private final int minTokens;
        private final int maxTokens;

        public MixedGroupParameters(@NotNull TokenGroup[] groups, int maxConsecutiveGroups, int minTokens, int maxTokens) {
            Intrinsics.checkNotNullParameter((Object)groups, (String)"groups");
            this.groups = groups;
            this.maxConsecutiveGroups = maxConsecutiveGroups;
            this.minTokens = minTokens;
            this.maxTokens = maxTokens;
        }

        @NotNull
        public final TokenGroup[] groups() {
            return this.groups;
        }

        public final int maxConsecutiveGroups() {
            return this.maxConsecutiveGroups;
        }

        public final int minTokens() {
            return this.minTokens;
        }

        public final int maxTokens() {
            return this.maxTokens;
        }

        @NotNull
        public final TokenGroup[] component1() {
            return this.groups;
        }

        public final int component2() {
            return this.maxConsecutiveGroups;
        }

        public final int component3() {
            return this.minTokens;
        }

        public final int component4() {
            return this.maxTokens;
        }

        @NotNull
        public final MixedGroupParameters copy(@NotNull TokenGroup[] groups, int maxConsecutiveGroups, int minTokens, int maxTokens) {
            Intrinsics.checkNotNullParameter((Object)groups, (String)"groups");
            return new MixedGroupParameters(groups, maxConsecutiveGroups, minTokens, maxTokens);
        }

        public static /* synthetic */ MixedGroupParameters copy$default(MixedGroupParameters mixedGroupParameters, TokenGroup[] tokenGroupArray, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                tokenGroupArray = mixedGroupParameters.groups;
            }
            if ((n4 & 2) != 0) {
                n = mixedGroupParameters.maxConsecutiveGroups;
            }
            if ((n4 & 4) != 0) {
                n2 = mixedGroupParameters.minTokens;
            }
            if ((n4 & 8) != 0) {
                n3 = mixedGroupParameters.maxTokens;
            }
            return mixedGroupParameters.copy(tokenGroupArray, n, n2, n3);
        }

        @Override
        @NotNull
        public String toString() {
            return "MixedGroupParameters(groups=" + Arrays.toString(this.groups) + ", maxConsecutiveGroups=" + this.maxConsecutiveGroups + ", minTokens=" + this.minTokens + ", maxTokens=" + this.maxTokens + ")";
        }

        @Override
        public int hashCode() {
            int result = Arrays.hashCode(this.groups);
            result = result * 31 + Integer.hashCode(this.maxConsecutiveGroups);
            result = result * 31 + Integer.hashCode(this.minTokens);
            result = result * 31 + Integer.hashCode(this.maxTokens);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MixedGroupParameters)) {
                return false;
            }
            MixedGroupParameters mixedGroupParameters = (MixedGroupParameters)other;
            if (!Intrinsics.areEqual((Object)this.groups, (Object)mixedGroupParameters.groups)) {
                return false;
            }
            if (this.maxConsecutiveGroups != mixedGroupParameters.maxConsecutiveGroups) {
                return false;
            }
            if (this.minTokens != mixedGroupParameters.minTokens) {
                return false;
            }
            return this.maxTokens == mixedGroupParameters.maxTokens;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J(\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u0002\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/ssblur/scriptor/helpers/generators/MixedGroupGenerator$TokenGroup;", "Ljava/lang/Record;", "tokens", "", "", "weight", "", "<init>", "([Ljava/lang/String;I)V", "()[Ljava/lang/String;", "[Ljava/lang/String;", "()I", "component1", "component2", "copy", "([Ljava/lang/String;I)Lcom/ssblur/scriptor/helpers/generators/MixedGroupGenerator$TokenGroup;", "equals", "", "other", "", "hashCode", "toString", "scriptor"})
    public static final class TokenGroup
    extends Record {
        @NotNull
        private final String[] tokens;
        private final int weight;

        public TokenGroup(@NotNull String[] tokens, int weight) {
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            this.tokens = tokens;
            this.weight = weight;
        }

        @NotNull
        public final String[] tokens() {
            return this.tokens;
        }

        public final int weight() {
            return this.weight;
        }

        @NotNull
        public final String[] component1() {
            return this.tokens;
        }

        public final int component2() {
            return this.weight;
        }

        @NotNull
        public final TokenGroup copy(@NotNull String[] tokens, int weight) {
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            return new TokenGroup(tokens, weight);
        }

        public static /* synthetic */ TokenGroup copy$default(TokenGroup tokenGroup, String[] stringArray, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                stringArray = tokenGroup.tokens;
            }
            if ((n2 & 2) != 0) {
                n = tokenGroup.weight;
            }
            return tokenGroup.copy(stringArray, n);
        }

        @Override
        @NotNull
        public String toString() {
            return "TokenGroup(tokens=" + Arrays.toString(this.tokens) + ", weight=" + this.weight + ")";
        }

        @Override
        public int hashCode() {
            int result = Arrays.hashCode(this.tokens);
            result = result * 31 + Integer.hashCode(this.weight);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TokenGroup)) {
                return false;
            }
            TokenGroup tokenGroup = (TokenGroup)other;
            if (!Intrinsics.areEqual((Object)this.tokens, (Object)tokenGroup.tokens)) {
                return false;
            }
            return this.weight == tokenGroup.weight;
        }
    }
}

