/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers;

import com.ssblur.scriptor.advancement.ScriptorAdvancements;
import com.ssblur.scriptor.config.ScriptorConfig;
import com.ssblur.scriptor.data.saved_data.DictionarySavedData;
import com.ssblur.scriptor.effect.EmpoweredStatusEffect;
import com.ssblur.scriptor.helpers.LimitedBookSerializer;
import com.ssblur.scriptor.helpers.targetable.SpellbookTargetable;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.unfocused.advancement.GenericTrigger;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010JO\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u001a\b\u0002\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0015R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/ssblur/scriptor/helpers/SpellbookHelper;", "", "<init>", "()V", "SPELLBOOKS", "", "Lnet/minecraft/world/item/Item;", "getSPELLBOOKS", "()Ljava/util/List;", "setSPELLBOOKS", "(Ljava/util/List;)V", "isInventoryCaster", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/server/level/ServerLevel;", "castFromItem", "player", "Lnet/minecraft/world/entity/player/Player;", "maxCost", "", "costMultiplier", "cooldownFunc", "Lkotlin/Function2;", "", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/player/Player;Ljava/lang/Integer;Ljava/lang/Integer;Lkotlin/jvm/functions/Function2;)Z", "addCooldown", "time", "scriptor"})
public final class SpellbookHelper {
    @NotNull
    public static final SpellbookHelper INSTANCE = new SpellbookHelper();
    @NotNull
    private static List<? extends Item> SPELLBOOKS = new ArrayList();

    private SpellbookHelper() {
    }

    @NotNull
    public final List<Item> getSPELLBOOKS() {
        return SPELLBOOKS;
    }

    public final void setSPELLBOOKS(@NotNull List<? extends Item> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        SPELLBOOKS = list;
    }

    public final boolean isInventoryCaster(@NotNull ItemStack itemStack, @NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        WrittenBookContent writtenBookContent = (WrittenBookContent)itemStack.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (writtenBookContent == null) {
            return false;
        }
        WrittenBookContent text = writtenBookContent;
        Spell spell = DictionarySavedData.Companion.computeIfAbsent(level).parse(LimitedBookSerializer.INSTANCE.decodeText(text));
        return spell != null && spell.getSubject().canBeCastOnInventory();
    }

    public final boolean castFromItem(@NotNull ItemStack itemStack, @NotNull Player player, @Nullable Integer maxCost, @Nullable Integer costMultiplier, @NotNull Function2<? super Player, ? super Integer, Unit> cooldownFunc) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(cooldownFunc, (String)"cooldownFunc");
        Integer n = maxCost;
        int adjustedMaxCost = n != null ? n.intValue() : ((Number)ScriptorConfig.INSTANCE.getTOME_MAX_COST().invoke()).intValue();
        Integer n2 = costMultiplier;
        double adjustedCostMultiplier = (double)(n2 != null ? n2.intValue() : ((Number)ScriptorConfig.INSTANCE.getTOME_COOLDOWN_MULTIPLIER().invoke()).intValue()) / 100.0;
        WrittenBookContent text = (WrittenBookContent)itemStack.get(DataComponents.WRITTEN_BOOK_CONTENT);
        Level level = player.level();
        if (text == null || !(level instanceof ServerLevel)) {
            return false;
        }
        Spell spell = DictionarySavedData.Companion.computeIfAbsent((ServerLevel)level).parse(LimitedBookSerializer.INSTANCE.decodeText(text));
        if (spell != null) {
            spell.deduplicatedDescriptorsForSubjects();
            ((ServerLevel)level).playSound(null, player.blockPosition(), SoundEvents.EVOKER_CAST_SPELL, SoundSource.PLAYERS, 0.4f, ((ServerLevel)level).getRandom().nextFloat() * 1.2f + 0.6f);
            if (spell.cost() > (double)adjustedMaxCost) {
                player.sendSystemMessage((Component)Component.translatable((String)"extra.scriptor.fizzle"));
                ((GenericTrigger)ScriptorAdvancements.INSTANCE.getFIZZLE().get()).trigger((ServerPlayer)player);
                if (!((ServerPlayer)player).isCreative()) {
                    cooldownFunc.invoke((Object)player, (Object)((int)Math.round(350.0 * adjustedCostMultiplier)));
                }
                return true;
            }
            spell.cast(new SpellbookTargetable(itemStack, player, player.getInventory().selected).withTargetItem(false));
            if (!player.isCreative()) {
                double costScale = 1.0;
                block0: for (MobEffectInstance instance : player.getActiveEffects()) {
                    int n3;
                    int i;
                    if (!(instance.getEffect().value() instanceof EmpoweredStatusEffect) || (i = 0) > (n3 = instance.getAmplifier())) continue;
                    while (true) {
                        Object object = instance.getEffect().value();
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.ssblur.scriptor.effect.EmpoweredStatusEffect");
                        costScale *= (double)((EmpoweredStatusEffect)((Object)object)).getScale();
                        if (i == n3) continue block0;
                        ++i;
                    }
                }
                double adjustedCost = costScale * spell.cost() * adjustedCostMultiplier;
                cooldownFunc.invoke((Object)player, (Object)((int)Math.round(adjustedCost * (double)7)));
                return true;
            }
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean castFromItem$default(SpellbookHelper spellbookHelper, ItemStack itemStack, Player player, Integer n, Integer n2, Function2 function2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = null;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        if ((n3 & 0x10) != 0) {
            function2 = (Function2)new Function2<Player, Integer, Unit>((Object)spellbookHelper){

                public final void invoke(Player p0, int p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((SpellbookHelper)this.receiver).addCooldown(p0, p1);
                }
            };
        }
        return spellbookHelper.castFromItem(itemStack, player, n, n2, (Function2<? super Player, ? super Integer, Unit>)function2);
    }

    public final void addCooldown(@NotNull Player player, int time) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        for (Item item : SPELLBOOKS) {
            player.getCooldowns().addCooldown(item, time);
        }
    }
}

