/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.entity;

import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u00010B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001dJ\u000e\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u001dJ\u000e\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0001J\u0010\u0010\u0014\u001a\u00020#2\b\u0010\u0010\u001a\u0004\u0018\u00010'J\u0010\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010+\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0014J\b\u0010/\u001a\u00020#H\u0016R(\u0010\b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u00061"}, d2={"Lcom/ssblur/scriptor/entity/ScriptorProjectile;", "Lnet/minecraft/world/entity/Entity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "completable", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "getCompletable", "()Ljava/util/concurrent/CompletableFuture;", "setCompletable", "(Ljava/util/concurrent/CompletableFuture;)V", "origin", "Lnet/minecraft/world/phys/Vec3;", "getOrigin", "()Lnet/minecraft/world/phys/Vec3;", "setOrigin", "(Lnet/minecraft/world/phys/Vec3;)V", "collidesWithWater", "", "getCollidesWithWater", "()Z", "setCollidesWithWater", "(Z)V", "color", "", "getColor", "()I", "setColor", "(I)V", "setDuration", "", "duration", "setOwner", "owner", "Lnet/minecraft/core/BlockPos;", "readAdditionalSaveData", "compoundTag", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "tick", "Companion", "scriptor"})
public final class ScriptorProjectile
extends Entity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CompletableFuture<List<Targetable>> completable;
    @Nullable
    private Vec3 origin;
    private boolean collidesWithWater;
    @NotNull
    private static final EntityDataAccessor<Integer> DURATION;
    @NotNull
    private static final EntityDataAccessor<Integer> COLOR;
    @NotNull
    private static final EntityDataAccessor<Integer> OWNER;

    public ScriptorProjectile(@NotNull EntityType<ScriptorProjectile> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
    }

    @Nullable
    public final CompletableFuture<List<Targetable>> getCompletable() {
        return this.completable;
    }

    public final void setCompletable(@Nullable CompletableFuture<List<Targetable>> completableFuture) {
        this.completable = completableFuture;
    }

    @Nullable
    public final Vec3 getOrigin() {
        return this.origin;
    }

    public final void setOrigin(@Nullable Vec3 vec3) {
        this.origin = vec3;
    }

    public final boolean getCollidesWithWater() {
        return this.collidesWithWater;
    }

    public final void setCollidesWithWater(boolean bl) {
        this.collidesWithWater = bl;
    }

    public final int getColor() {
        Object object = this.entityData.get(COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setColor(int color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public final void setDuration(int duration) {
        this.entityData.set(DURATION, (Object)duration);
    }

    public final void setOwner(int owner) {
        this.entityData.set(OWNER, (Object)owner);
    }

    public final void setOwner(@NotNull Entity owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.setOwner(owner.getId());
    }

    public final void setOrigin(@Nullable BlockPos origin) {
        this.origin = origin == null ? null : new Vec3((double)origin.getX() + 0.5, (double)origin.getY() + 0.5, (double)origin.getZ() + 0.5);
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        CompoundTag tag = compoundTag.getCompound("scriptor:projectile_data");
        this.entityData.set(COLOR, (Object)tag.getInt("scriptor:color"));
        this.entityData.set(DURATION, (Object)tag.getInt("duration"));
        this.entityData.set(OWNER, (Object)tag.getInt("owner"));
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        CompoundTag tag = compoundTag.getCompound("scriptor:projectile_data");
        Object object = this.entityData.get(COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        tag.putInt("scriptor:color", ((Number)object).intValue());
        Object object2 = this.entityData.get(DURATION);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        tag.putInt("duration", ((Number)object2).intValue());
        Object object3 = this.entityData.get(OWNER);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        tag.putInt("owner", ((Number)object3).intValue());
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(COLOR, (Object)10494192);
        builder.define(DURATION, (Object)120);
        builder.define(OWNER, (Object)0);
    }

    public void tick() {
        block16: {
            BlockHitResult blockHitResult;
            block17: {
                Vec3 dest;
                block15: {
                    EntityHitResult entityHitResult;
                    Level level;
                    block14: {
                        block13: {
                            Integer duration;
                            level = this.level();
                            this.setDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z);
                            this.setPos(this.position().add(this.getDeltaMovement()));
                            if (level.isClientSide) {
                                return;
                            }
                            if (this.origin != null) {
                                Vec3 vec3 = this.position();
                                Vec3 vec32 = this.origin;
                                Intrinsics.checkNotNull((Object)vec32);
                                if (vec3.distanceTo(vec32) <= 1.0) {
                                    return;
                                }
                            }
                            if (this.tickCount > (duration = (Integer)this.entityData.get(DURATION)) || this.completable == null) break block13;
                            CompletableFuture<List<Targetable>> completableFuture = this.completable;
                            Intrinsics.checkNotNull(completableFuture);
                            if (!completableFuture.isDone()) break block14;
                        }
                        this.remove(Entity.RemovalReason.KILLED);
                        return;
                    }
                    dest = this.position().add(this.getDeltaMovement());
                    blockHitResult = level.clip(new ClipContext(this.position(), dest, ClipContext.Block.COLLIDER, this.collidesWithWater ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, (Entity)this));
                    if (blockHitResult.getType() != HitResult.Type.MISS) {
                        dest = blockHitResult.getLocation();
                    }
                    if ((entityHitResult = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)this.position(), (Vec3)dest, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), ScriptorProjectile::tick$lambda$0)) == null) break block15;
                    Entity entity = entityHitResult.getEntity();
                    if (entity instanceof LivingEntity) {
                        CompletableFuture<List<Targetable>> completableFuture = this.completable;
                        Intrinsics.checkNotNull(completableFuture);
                        completableFuture.complete(CollectionsKt.listOf((Object)new EntityTargetable(entity)));
                    }
                    break block16;
                }
                if (blockHitResult.getType() == HitResult.Type.MISS) break block16;
                if (this.origin == null || blockHitResult.getType() != HitResult.Type.BLOCK) break block17;
                Vec3 vec3 = this.origin;
                Intrinsics.checkNotNull((Object)vec3);
                if (vec3.distanceToSqr(dest) < 0.55) break block16;
            }
            CompletableFuture<List<Targetable>> completableFuture = this.completable;
            Intrinsics.checkNotNull(completableFuture);
            Level level = this.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            BlockPos blockPos = blockHitResult.getBlockPos().offset(blockHitResult.getDirection().getNormal());
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
            completableFuture.complete(CollectionsKt.listOf((Object)new Targetable(level, blockPos).setFacing(blockHitResult.getDirection())));
        }
    }

    private static final boolean tick$lambda$0(Entity entity) {
        return true;
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(ScriptorProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DURATION = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(ScriptorProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        COLOR = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.defineId(ScriptorProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        OWNER = entityDataAccessor3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/ssblur/scriptor/entity/ScriptorProjectile$Companion;", "", "<init>", "()V", "DURATION", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "COLOR", "OWNER", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

