/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.data.saved_data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.registry.TokenGeneratorRegistry;
import com.ssblur.scriptor.registry.words.WordRegistry;
import com.ssblur.scriptor.word.PartialSpell;
import com.ssblur.scriptor.word.Spell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0002-.B5\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0004J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u0004J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010 J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010 J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\u0004J\u001a\u0010$\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00032\b\u0010#\u001a\u0004\u0018\u00010\u0004J\u000e\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\"J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u0004H\u0016R\"\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR(\u0010\u0005\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00040\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006/"}, d2={"Lcom/ssblur/scriptor/data/saved_data/DictionarySavedData;", "Lnet/minecraft/world/level/saveddata/SavedData;", "spellStructure", "", "", "words", "Lcom/mojang/datafixers/util/Pair;", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "()V", "", "Lcom/ssblur/scriptor/data/saved_data/DictionarySavedData$WORD;", "getSpellStructure", "()Ljava/util/List;", "setSpellStructure", "(Ljava/util/List;)V", "Lcom/google/common/collect/BiMap;", "getWords", "()Lcom/google/common/collect/BiMap;", "setWords", "(Lcom/google/common/collect/BiMap;)V", "containsKey", "", "key", "containsWord", "string", "generateMissingWords", "", "parseWord", "word", "getWord", "getKey", "Lcom/ssblur/scriptor/api/word/Word;", "parse", "Lcom/ssblur/scriptor/word/Spell;", "text", "parseComponents", "generate", "spell", "save", "Lnet/minecraft/nbt/CompoundTag;", "tag", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "toString", "WORD", "Companion", "scriptor"})
@SourceDebugExtension(value={"SMAP\nDictionarySavedData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DictionarySavedData.kt\ncom/ssblur/scriptor/data/saved_data/DictionarySavedData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,396:1\n739#2,9:397\n37#3,2:406\n37#3,2:408\n37#3,2:410\n37#3,2:412\n*S KotlinDebug\n*F\n+ 1 DictionarySavedData.kt\ncom/ssblur/scriptor/data/saved_data/DictionarySavedData\n*L\n188#1:397,9\n188#1:406,2\n202#1:408,2\n255#1:410,2\n256#1:412,2\n*E\n"})
public final class DictionarySavedData
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<WORD> spellStructure;
    @NotNull
    private BiMap<String, String> words;
    @NotNull
    private static final Codec<DictionarySavedData> worldCodec;

    @NotNull
    public final List<WORD> getSpellStructure() {
        return this.spellStructure;
    }

    public final void setSpellStructure(@NotNull List<WORD> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.spellStructure = list;
    }

    @NotNull
    public final BiMap<String, String> getWords() {
        return this.words;
    }

    public final void setWords(@NotNull BiMap<String, String> biMap) {
        Intrinsics.checkNotNullParameter(biMap, (String)"<set-?>");
        this.words = biMap;
    }

    public DictionarySavedData(@NotNull List<String> spellStructure, @NotNull List<? extends Pair<String, String>> words) {
        Intrinsics.checkNotNullParameter(spellStructure, (String)"spellStructure");
        Intrinsics.checkNotNullParameter(words, (String)"words");
        this.spellStructure = spellStructure.stream().map(arg_0 -> DictionarySavedData._init_$lambda$1(DictionarySavedData::_init_$lambda$0, arg_0)).toList();
        this.words = (BiMap)HashBiMap.create();
        for (Pair<String, String> pair : words) {
            ((Map)this.words).put(pair.getFirst(), pair.getSecond());
        }
        this.generateMissingWords();
        this.setDirty();
    }

    public final boolean containsKey(@Nullable String key) {
        return this.words.containsKey((Object)key);
    }

    public final boolean containsWord(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.words.containsValue((Object)string);
    }

    public final void generateMissingWords() {
        TokenGeneratorRegistry registry = TokenGeneratorRegistry.INSTANCE;
        String token = null;
        if (!this.containsKey("other:and")) {
            while (this.containsWord(token = TokenGeneratorRegistry.generateWord$default(registry, "other:and", null, 2, null))) {
            }
            ((Map)this.words).put("other:and", token);
        }
        for (String word : WordRegistry.INSTANCE.getActionRegistry().keySet()) {
            if (this.containsKey("action:" + word)) continue;
            while (this.containsWord(token = TokenGeneratorRegistry.generateWord$default(registry, "action:" + word, null, 2, null))) {
            }
            ((Map)this.words).put("action:" + word, token);
        }
        for (String word : WordRegistry.INSTANCE.getDescriptorRegistry().keySet()) {
            if (this.containsKey("descriptor:" + word)) continue;
            while (this.containsWord(token = TokenGeneratorRegistry.generateWord$default(registry, "descriptor:" + word, null, 2, null))) {
            }
            ((Map)this.words).put("descriptor:" + word, token);
        }
        for (String word : WordRegistry.INSTANCE.getSubjectRegistry().keySet()) {
            if (this.containsKey("subject:" + word)) continue;
            while (this.containsWord(token = TokenGeneratorRegistry.generateWord$default(registry, "subject:" + word, null, 2, null))) {
            }
            ((Map)this.words).put("subject:" + word, token);
        }
    }

    public DictionarySavedData() {
        WORD[] wORDArray = new WORD[]{WORD.SUBJECT, WORD.ACTION, WORD.DESCRIPTOR};
        WORD[] basicStructure = wORDArray;
        List<WORD> structure = Arrays.asList(Arrays.copyOf(basicStructure, basicStructure.length));
        if (!ScriptorMod.INSTANCE.getCOMMUNITY_MODE()) {
            Collections.shuffle(structure);
        }
        this.spellStructure = new ArrayList();
        Intrinsics.checkNotNull(structure);
        this.spellStructure.addAll((Collection<WORD>)structure);
        this.words = (BiMap)HashBiMap.create();
        this.generateMissingWords();
        this.setDirty();
    }

    @Nullable
    public final String parseWord(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return (String)this.words.inverse().get((Object)word);
    }

    @Nullable
    public final String getWord(@Nullable String key) {
        return (String)this.words.get((Object)key);
    }

    @Nullable
    public final String getKey(@Nullable Word word) {
        String key = WordRegistry.INSTANCE.getKey(word);
        if (key != null) {
            if (word instanceof Action) {
                return "action:" + key;
            }
            if (word instanceof Subject) {
                return "subject:" + key;
            }
            if (word instanceof Descriptor) {
                return "descriptor:" + key;
            }
        }
        return null;
    }

    @Nullable
    public final String getWord(@Nullable Word word) {
        return this.getWord(this.getKey(word));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Spell parse(@Nullable String text) {
        if (text == null) {
            ScriptorMod.INSTANCE.getLOGGER().warn("No text provided to parser!");
            return null;
        }
        int position = 0;
        int tokenPosition = 0;
        try {
            Object[] objectArray;
            Collection thisCollection$iv;
            boolean $i$f$toTypedArray;
            Collection $this$toTypedArray$iv;
            void $this$toTypedArray$iv2;
            List list;
            Collection $this$dropLastWhile$iv;
            Object object = text;
            Regex regex = new Regex("[\\n\\r\\s]+");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray2 = false;
            void thisCollection$iv2 = $this$toTypedArray$iv2;
            String[] tokens = thisCollection$iv2.toArray(new String[0]);
            Subject subject = null;
            List spells = new ArrayList();
            Action action = null;
            List descriptors = new ArrayList();
            String parsed = null;
            block9: while (tokenPosition < tokens.length) {
                if (position % this.spellStructure.size() == 0 && position > 0) {
                    parsed = this.parseWord(tokens[tokenPosition]);
                    if (parsed != null && Intrinsics.areEqual((Object)parsed, (Object)"other:and")) {
                        ++tokenPosition;
                        Action action2 = action;
                        Intrinsics.checkNotNull(action2);
                        $this$toTypedArray$iv = descriptors;
                        $i$f$toTypedArray = false;
                        thisCollection$iv = $this$toTypedArray$iv;
                        objectArray = thisCollection$iv.toArray(new Descriptor[0]);
                        spells.add(new PartialSpell(action2, Arrays.copyOf(objectArray, objectArray.length)));
                        descriptors.clear();
                    } else {
                        return null;
                    }
                }
                if (position >= this.spellStructure.size() && this.spellStructure.get(position % this.spellStructure.size()) == WORD.SUBJECT) {
                    ++position;
                }
                WORD word = this.spellStructure.get(position % this.spellStructure.size());
                String wordData = this.parseWord(tokens[tokenPosition]);
                WORD wORD = word;
                switch (wORD == null ? -1 : WhenMappings.$EnumSwitchMapping$0[wORD.ordinal()]) {
                    case 1: {
                        if (wordData == null) {
                            ScriptorMod.INSTANCE.getLOGGER().debug("Failed to process spell with text: \"" + text + "\"");
                            ScriptorMod.INSTANCE.getLOGGER().debug("No word found for \"" + tokens[tokenPosition] + "\", action expected");
                            return null;
                        }
                        HashBiMap<String, Action> hashBiMap = WordRegistry.INSTANCE.getActionRegistry();
                        String string = wordData.substring(7);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        action = (Action)hashBiMap.get((Object)string);
                        break;
                    }
                    case 2: {
                        if (wordData == null || wordData.length() < 12) {
                            ++position;
                            continue block9;
                        }
                        HashBiMap<String, Descriptor> hashBiMap = WordRegistry.INSTANCE.getDescriptorRegistry();
                        String string = wordData.substring(11);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        Descriptor descriptor = (Descriptor)hashBiMap.get((Object)string);
                        if (descriptor == null) {
                            ++position;
                            continue block9;
                        }
                        descriptors.add(descriptor);
                        ++tokenPosition;
                        continue block9;
                    }
                    case 3: {
                        if (wordData == null) {
                            ScriptorMod.INSTANCE.getLOGGER().debug("Failed to process spell with text: \"" + text + "\"");
                            ScriptorMod.INSTANCE.getLOGGER().debug("Subject " + tokens[tokenPosition] + " not found");
                            return null;
                        }
                        HashBiMap<String, Subject> hashBiMap = WordRegistry.INSTANCE.getSubjectRegistry();
                        String string = wordData.substring(8);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        subject = (Subject)hashBiMap.get((Object)string);
                        break;
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                ++position;
                ++tokenPosition;
            }
            if (action != null && subject != null) {
                $this$toTypedArray$iv = descriptors;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                objectArray = thisCollection$iv.toArray(new Descriptor[0]);
                spells.add(new PartialSpell(action, Arrays.copyOf(objectArray, objectArray.length)));
                $this$toTypedArray$iv = spells;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                objectArray = thisCollection$iv.toArray(new PartialSpell[0]);
                return new Spell(subject, (PartialSpell[])Arrays.copyOf(objectArray, objectArray.length));
            }
        }
        catch (Exception e) {
            ScriptorMod.INSTANCE.getLOGGER().warn("==========================================================");
            ScriptorMod.INSTANCE.getLOGGER().warn("The below error did NOT cause a crash, this is debug info!");
            ScriptorMod.INSTANCE.getLOGGER().error("Error:", (Throwable)e);
            ScriptorMod.INSTANCE.getLOGGER().warn("==========================================================");
        }
        ScriptorMod.INSTANCE.getLOGGER().debug("Failed to process spell with text: \"" + text + "\"");
        return null;
    }

    @Nullable
    public final List<String> parseComponents(@Nullable String text) {
        Spell spell = this.parse(text);
        if (spell != null) {
            List list = new ArrayList();
            list.add(this.getKey(spell.getSubject()));
            for (PartialSpell partialSpell : spell.getSpells()) {
                list.add(this.getKey(partialSpell.getAction()));
                for (Descriptor descriptor : partialSpell.getDescriptors()) {
                    list.add(this.getKey(descriptor));
                }
            }
            return list;
        }
        return null;
    }

    @NotNull
    public final String generate(@NotNull Spell spell) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
        boolean bl2 = bl = spell.getSpells().length >= 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        StringBuilder descriptorBuilder = new StringBuilder();
        for (Descriptor descriptor : spell.getSpells()[0].deduplicatedDescriptors()) {
            descriptorBuilder.append(" ").append(this.getWord(descriptor));
        }
        StringBuilder builder = new StringBuilder();
        for (WORD w : this.spellStructure) {
            if (w == WORD.ACTION) {
                builder.append(" ").append(this.getWord(spell.getSpells()[0].getAction()));
                continue;
            }
            if (w == WORD.SUBJECT) {
                builder.append(" ").append(this.getWord(spell.getSubject()));
                continue;
            }
            if (w != WORD.DESCRIPTOR) continue;
            builder.append((CharSequence)descriptorBuilder);
        }
        for (PartialSpell partialSpell : Arrays.stream(spell.getSpells()).skip(1L).toList()) {
            builder.append(" ").append(this.getWord("other:and"));
            descriptorBuilder = new StringBuilder();
            for (Descriptor descriptor : partialSpell.deduplicatedDescriptors()) {
                descriptorBuilder.append(" ").append(this.getWord(descriptor));
            }
            for (WORD w : this.spellStructure) {
                if (w == WORD.ACTION) {
                    builder.append(" ").append(this.getWord(partialSpell.getAction()));
                    continue;
                }
                if (w != WORD.DESCRIPTOR) continue;
                builder.append((CharSequence)descriptorBuilder);
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        worldCodec.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).ifSuccess(arg_0 -> DictionarySavedData.save$lambda$4(arg_0 -> DictionarySavedData.save$lambda$3(tag, arg_0), arg_0));
        return tag;
    }

    @NotNull
    public String toString() {
        if (ScriptorMod.INSTANCE.getCOMMUNITY_MODE()) {
            return "DictionarySavedData[COMMUNITY_MODE=true]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Structure: ");
        for (WORD w : this.spellStructure) {
            builder.append((Object)w).append(" ");
        }
        builder.append("\nContains ").append(this.words.size()).append(" Words.");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final WORD _init_$lambda$0(String name) {
        String string = name;
        Intrinsics.checkNotNull((Object)string);
        return WORD.valueOf(string);
    }

    private static final WORD _init_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (WORD)((Object)$tmp0.invoke(p0));
    }

    private static final Unit save$lambda$3(CompoundTag $tag, Tag it) {
        Intrinsics.checkNotNullParameter((Object)$tag, (String)"$tag");
        $tag.put("scriptor:dictionary", it);
        return Unit.INSTANCE;
    }

    private static final void save$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final String worldCodec$lambda$12$lambda$7$lambda$5(WORD obj) {
        return String.valueOf((Object)obj);
    }

    private static final String worldCodec$lambda$12$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final List worldCodec$lambda$12$lambda$7(DictionarySavedData worldData) {
        DictionarySavedData dictionarySavedData = worldData;
        Intrinsics.checkNotNull((Object)((Object)dictionarySavedData));
        return dictionarySavedData.spellStructure.stream().map(arg_0 -> DictionarySavedData.worldCodec$lambda$12$lambda$7$lambda$6(DictionarySavedData::worldCodec$lambda$12$lambda$7$lambda$5, arg_0)).toList();
    }

    private static final Pair worldCodec$lambda$12$lambda$11$lambda$10$lambda$8(DictionarySavedData $it, String key) {
        Intrinsics.checkNotNullParameter((Object)((Object)$it), (String)"$it");
        return new Pair((Object)key, $it.words.get((Object)key));
    }

    private static final Pair worldCodec$lambda$12$lambda$11$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }

    private static final List worldCodec$lambda$12$lambda$11(DictionarySavedData it) {
        List<Pair> list;
        DictionarySavedData dictionarySavedData = it;
        if (dictionarySavedData != null) {
            DictionarySavedData it2 = dictionarySavedData;
            boolean bl = false;
            list = it2.words.keySet().stream().map(arg_0 -> DictionarySavedData.worldCodec$lambda$12$lambda$11$lambda$10$lambda$9(arg_0 -> DictionarySavedData.worldCodec$lambda$12$lambda$11$lambda$10$lambda$8(it2, arg_0), arg_0)).toList();
        } else {
            list = null;
        }
        return list;
    }

    private static final App worldCodec$lambda$12(RecordCodecBuilder.Instance instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        return instance.group((App)Codec.STRING.listOf().fieldOf("spellStructure").forGetter(DictionarySavedData::worldCodec$lambda$12$lambda$7), (App)Codec.compoundList((Codec)((Codec)Codec.STRING), (Codec)((Codec)Codec.STRING)).fieldOf("words").forGetter(DictionarySavedData::worldCodec$lambda$12$lambda$11)).apply((Applicative)instance, DictionarySavedData::new);
    }

    @JvmStatic
    @NotNull
    public static final DictionarySavedData computeIfAbsent(@NotNull ServerLevel level) {
        return Companion.computeIfAbsent(level);
    }

    static {
        Codec codec = RecordCodecBuilder.create(DictionarySavedData::worldCodec$lambda$12);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        worldCodec = codec;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/ssblur/scriptor/data/saved_data/DictionarySavedData$Companion;", "", "<init>", "()V", "worldCodec", "Lcom/mojang/serialization/Codec;", "Lcom/ssblur/scriptor/data/saved_data/DictionarySavedData;", "getWorldCodec", "()Lcom/mojang/serialization/Codec;", "load", "tag", "Lnet/minecraft/nbt/CompoundTag;", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "computeIfAbsent", "level", "Lnet/minecraft/server/level/ServerLevel;", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<DictionarySavedData> getWorldCodec() {
            return worldCodec;
        }

        @Nullable
        public final DictionarySavedData load(@NotNull CompoundTag tag, @Nullable HolderLookup.Provider provider) {
            Optional result;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Tag input = tag.get("scriptor:dictionary");
            if (input != null && (result = this.getWorldCodec().decode((DynamicOps)NbtOps.INSTANCE, (Object)input).result()).isPresent() && ((Pair)result.get()).getFirst() != null) {
                return (DictionarySavedData)((Object)((Pair)result.get()).getFirst());
            }
            return null;
        }

        @JvmStatic
        @NotNull
        public final DictionarySavedData computeIfAbsent(@NotNull ServerLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            ServerLevel server = level.getServer().getLevel(Level.OVERWORLD);
            Objects.requireNonNull(server);
            ServerLevel serverLevel = server;
            Intrinsics.checkNotNull((Object)serverLevel);
            SavedData savedData = serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(Companion::computeIfAbsent$lambda$0, Companion::computeIfAbsent$lambda$1, DataFixTypes.SAVED_DATA_MAP_DATA), ScriptorMod.INSTANCE.getCOMMUNITY_MODE() ? "scriptor_community_dictionary" : "scriptor_dictionary");
            Intrinsics.checkNotNullExpressionValue((Object)savedData, (String)"computeIfAbsent(...)");
            return (DictionarySavedData)savedData;
        }

        private static final DictionarySavedData computeIfAbsent$lambda$0() {
            return new DictionarySavedData();
        }

        private static final DictionarySavedData computeIfAbsent$lambda$1(CompoundTag tag, HolderLookup.Provider provider) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return Companion.load(tag, provider);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/ssblur/scriptor/data/saved_data/DictionarySavedData$WORD;", "", "<init>", "(Ljava/lang/String;I)V", "ACTION", "DESCRIPTOR", "SUBJECT", "scriptor"})
    public static final class WORD
    extends Enum<WORD> {
        public static final /* enum */ WORD ACTION = new WORD();
        public static final /* enum */ WORD DESCRIPTOR = new WORD();
        public static final /* enum */ WORD SUBJECT = new WORD();
        private static final /* synthetic */ WORD[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static WORD[] values() {
            return (WORD[])$VALUES.clone();
        }

        public static WORD valueOf(String value) {
            return Enum.valueOf(WORD.class, value);
        }

        @NotNull
        public static EnumEntries<WORD> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = wORDArray = new WORD[]{WORD.ACTION, WORD.DESCRIPTOR, WORD.SUBJECT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WORD.values().length];
            try {
                nArray[WORD.ACTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WORD.DESCRIPTOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WORD.SUBJECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

