/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.color;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.color.interfaces.ColorableItem;
import com.ssblur.scriptor.registry.colorable.ColorableItemRegistry;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0013H\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0006J\u0006\u0010\u001b\u001a\u00020\u0018R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/ssblur/scriptor/color/DyeColorableItem;", "Lcom/ssblur/scriptor/color/interfaces/ColorableItem;", "<init>", "()V", "items", "Lcom/google/common/collect/BiMap;", "Lnet/minecraft/world/item/DyeColor;", "Lnet/minecraft/world/item/Item;", "getItems", "()Lcom/google/common/collect/BiMap;", "setItems", "(Lcom/google/common/collect/BiMap;)V", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "setRandom", "(Ljava/util/Random;)V", "setColor", "Lnet/minecraft/world/item/ItemStack;", "color", "", "itemStack", "add", "", "item", "dyeColor", "register", "scriptor"})
public final class DyeColorableItem
implements ColorableItem {
    @NotNull
    private BiMap<DyeColor, Item> items;
    @NotNull
    private Random random;

    public DyeColorableItem() {
        HashBiMap hashBiMap = HashBiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"create(...)");
        this.items = (BiMap)hashBiMap;
        this.random = new Random();
    }

    @NotNull
    public final BiMap<DyeColor, Item> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull BiMap<DyeColor, Item> biMap) {
        Intrinsics.checkNotNullParameter(biMap, (String)"<set-?>");
        this.items = biMap;
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    public final void setRandom(@NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"<set-?>");
        this.random = random;
    }

    @Override
    @NotNull
    public ItemStack setColor(int color, @Nullable ItemStack itemStack) {
        ItemStack itemStack2 = itemStack;
        Intrinsics.checkNotNull((Object)itemStack2);
        Object object = this.items.get((Object)CustomColors.INSTANCE.getDyeColor(color, this.random.nextFloat(0.0f, Float.MAX_VALUE)));
        Intrinsics.checkNotNull((Object)object);
        ItemStack itemStack3 = itemStack2.transmuteCopy((ItemLike)object);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"transmuteCopy(...)");
        return itemStack3;
    }

    public final void add(@NotNull Item item, @NotNull DyeColor dyeColor) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)dyeColor, (String)"dyeColor");
        ((Map)this.items).put(dyeColor, item);
    }

    public final void register() {
        Iterator iterator = ((Set)this.items.values()).iterator();
        while (iterator.hasNext()) {
            Item entry;
            Item item = entry = (Item)iterator.next();
            Intrinsics.checkNotNull((Object)item);
            ColorableItemRegistry.INSTANCE.register(item, this);
        }
    }
}

