/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.color;

import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.word.descriptor.color.ColorDescriptor;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u001bJ\"\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00132\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0007J\u0016\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001bJ\u000e\u0010!\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0013J\u0016\u0010\"\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\bJ\u0014\u0010\"\u001a\u00020\u00062\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J\u001b\u0010\"\u001a\u00020\u00062\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010'\u00a2\u0006\u0002\u0010(J\u000e\u0010\"\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*J\u001e\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\bJ\u001a\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u00100\u001a\u00020\u001bJ\u0016\u00101\u001a\u0002022\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\bJ\n\u00103\u001a\u000204*\u00020\u0006R2\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R&\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\f\u00a8\u00066"}, d2={"Lcom/ssblur/scriptor/color/CustomColors;", "", "<init>", "()V", "registry", "Ljava/util/HashMap;", "", "Ljava/util/function/Function;", "", "getRegistry", "()Ljava/util/HashMap;", "setRegistry", "(Ljava/util/HashMap;)V", "currentNumber", "getCurrentNumber", "()I", "setCurrentNumber", "(I)V", "colors", "", "getColors", "setColors", "reset", "", "putColor", "index", "key", "", "register", "value", "color", "registerWithEasing", "values", "getKey", "getColor", "tick", "descriptors", "", "Lcom/ssblur/scriptor/api/word/Descriptor;", "", "([Lcom/ssblur/scriptor/api/word/Descriptor;)I", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "ease", "from", "to", "p", "createCustomColor", "list", "getDyeColor", "Lnet/minecraft/world/item/DyeColor;", "splitIntoRGB", "Lcom/ssblur/scriptor/color/CustomColors$RGB;", "RGB", "scriptor"})
public final class CustomColors {
    @NotNull
    public static final CustomColors INSTANCE = new CustomColors();
    @NotNull
    private static HashMap<Integer, Function<Float, Integer>> registry = new HashMap();
    private static int currentNumber;
    @NotNull
    private static HashMap<String, Integer> colors;

    private CustomColors() {
    }

    @NotNull
    public final HashMap<Integer, Function<Float, Integer>> getRegistry() {
        return registry;
    }

    public final void setRegistry(@NotNull HashMap<Integer, Function<Float, Integer>> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        registry = hashMap;
    }

    public final int getCurrentNumber() {
        return currentNumber;
    }

    public final void setCurrentNumber(int n) {
        currentNumber = n;
    }

    @NotNull
    public final HashMap<String, Integer> getColors() {
        return colors;
    }

    public final void setColors(@NotNull HashMap<String, Integer> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        colors = hashMap;
    }

    public final void reset() {
        currentNumber = 0;
        colors = new HashMap();
        registry = new HashMap();
        this.register("rainbow", CustomColors::reset$lambda$0);
    }

    public final void putColor(int index, @NotNull String key, @NotNull int[] colors) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Integer n = index;
        ((Map)CustomColors.colors).put(key, n);
        n = index;
        ((Map)registry).put(n, this.createCustomColor(colors));
    }

    public final int register(@NotNull String value, @NotNull Function<Float, Integer> color) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(color, (String)"color");
        int n = currentNumber;
        currentNumber = n + -1;
        ((Map)colors).put(value, currentNumber);
        ((Map)registry).put(currentNumber, color);
        return currentNumber;
    }

    public final int registerWithEasing(@NotNull String key, @NotNull int[] values) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return this.register(key, this.createCustomColor(values));
    }

    public final int getKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Integer n = colors.get(key);
        Intrinsics.checkNotNull((Object)n);
        return ((Number)n).intValue();
    }

    public final int getColor(int color, float tick) {
        if (color > 0) {
            return color;
        }
        if (registry.containsKey(color)) {
            Function<Float, Integer> function = registry.get(color);
            Intrinsics.checkNotNull(function);
            Integer n = function.apply(Float.valueOf(tick));
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"apply(...)");
            return ((Number)n).intValue();
        }
        return 0;
    }

    public final int getColor(@NotNull Iterable<? extends Descriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        long r = 0L;
        long g = 0L;
        long b = 0L;
        long a = 0L;
        int colorN = 0;
        int c = 0;
        for (Descriptor descriptor : descriptors) {
            if (!(descriptor instanceof ColorDescriptor)) continue;
            if (((ColorDescriptor)descriptor).getColor() >= 0) {
                ++colorN;
                c = ((ColorDescriptor)descriptor).getColor();
                b += (long)(c & 0xFF);
                g += (long)(c >> 8 & 0xFF);
                r += (long)(c >> 16 & 0xFF);
                a += (long)(c >> 24 & 0xFF);
                continue;
            }
            return ((ColorDescriptor)descriptor).getColor();
        }
        if (colorN == 0) {
            return 10494192;
        }
        return (int)(((a /= (long)colorN) << 24) + ((r /= (long)colorN) << 16) + ((g /= (long)colorN) << 8) + (b /= (long)colorN));
    }

    public final int getColor(@Nullable Descriptor[] descriptors) {
        List<Descriptor> list = Arrays.stream(descriptors).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return this.getColor((Iterable<? extends Descriptor>)list);
    }

    public final int getColor(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        ClientLevel clientLevel = Minecraft.getInstance().level;
        Intrinsics.checkNotNull((Object)clientLevel);
        long tick = clientLevel.getGameTime();
        DyedItemColor dye = (DyedItemColor)itemStack.get(DataComponents.DYED_COLOR);
        if (dye != null) {
            return -16777216 + this.getColor(dye.rgb(), tick);
        }
        return -6283024;
    }

    public final int ease(int from, int to, float p) {
        float partial = p;
        partial = (float)Math.pow(partial, 5.0f);
        int bA = from & 0xFF;
        int gA = from >> 8 & 0xFF;
        int rA = from >> 16 & 0xFF;
        int aA = from >> 24 & 0xFF;
        int bB = to & 0xFF;
        int gB = to >> 8 & 0xFF;
        int rB = to >> 16 & 0xFF;
        int aB = to >> 24 & 0xFF;
        int b = (int)((float)bA * partial + (float)bB * (1.0f - partial));
        int g = (int)((float)gA * partial + (float)gB * (1.0f - partial));
        int r = (int)((float)rA * partial + (float)rB * (1.0f - partial));
        int a = (int)((float)aA * partial + (float)aB * (1.0f - partial));
        return (a << 24) + (r << 16) + (g << 8) + b;
    }

    @NotNull
    public final Function<Float, Integer> createCustomColor(@NotNull int[] list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        return arg_0 -> CustomColors.createCustomColor$lambda$1(list, arg_0);
    }

    @NotNull
    public final DyeColor getDyeColor(int color, float tick) {
        int distance = -1;
        DyeColor dyeColor = DyeColor.WHITE;
        int c = this.getColor(color, tick);
        int b = c & 0xFF;
        int g = c >> 8 & 0xFF;
        int r = c >> 16 & 0xFF;
        int cD = 0;
        int bD = 0;
        int gD = 0;
        int rD = 0;
        int d = 0;
        for (DyeColor dye : EntriesMappings.entries$0) {
            cD = dye.getFireworkColor();
            bD = cD & 0xFF;
            gD = cD >> 8 & 0xFF;
            rD = cD >> 16 & 0xFF;
            d = (int)Math.sqrt((float)Math.pow(b - bD, 2.0f) + (float)Math.pow(g - gD, 2.0f) + (float)Math.pow(r - rD, 2.0f));
            if (d >= distance && distance != -1) continue;
            dyeColor = dye;
            distance = d;
        }
        return dyeColor;
    }

    @NotNull
    public final RGB splitIntoRGB(int $this$splitIntoRGB) {
        return new RGB($this$splitIntoRGB >> 16 & 0xFF, $this$splitIntoRGB >> 8 & 0xFF, $this$splitIntoRGB & 0xFF);
    }

    private static final Integer reset$lambda$0(float t) {
        float tick = t;
        float s = tick % (float)31;
        s /= 93.0f;
        float b = tick % (float)23;
        b /= 46.0f;
        return Color.getHSBColor((tick %= 40.0f) / 40.0f, s += 0.75f, b += 0.5f).getRGB();
    }

    private static final Integer createCustomColor$lambda$1(int[] $list, float t) {
        Intrinsics.checkNotNullParameter((Object)$list, (String)"$list");
        float tick = t;
        float partial = tick % (float)60 / (float)60;
        tick /= 60.0f;
        int index = (int)(tick %= (float)$list.length);
        int color = $list[index];
        int nextColor = $list[(index + 1) % $list.length];
        return INSTANCE.ease(nextColor, color, partial);
    }

    static {
        colors = new HashMap();
        INSTANCE.reset();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<DyeColor> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])DyeColor.values()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/ssblur/scriptor/color/CustomColors$RGB;", "", "r", "", "g", "b", "<init>", "(III)V", "getR", "()I", "getG", "getB", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "scriptor"})
    public static final class RGB {
        private final int r;
        private final int g;
        private final int b;

        public RGB(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public final int getR() {
            return this.r;
        }

        public final int getG() {
            return this.g;
        }

        public final int getB() {
            return this.b;
        }

        public final int component1() {
            return this.r;
        }

        public final int component2() {
            return this.g;
        }

        public final int component3() {
            return this.b;
        }

        @NotNull
        public final RGB copy(int r, int g, int b) {
            return new RGB(r, g, b);
        }

        public static /* synthetic */ RGB copy$default(RGB rGB, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = rGB.r;
            }
            if ((n4 & 2) != 0) {
                n2 = rGB.g;
            }
            if ((n4 & 4) != 0) {
                n3 = rGB.b;
            }
            return rGB.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "RGB(r=" + this.r + ", g=" + this.g + ", b=" + this.b + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.r);
            result = result * 31 + Integer.hashCode(this.g);
            result = result * 31 + Integer.hashCode(this.b);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RGB)) {
                return false;
            }
            RGB rGB = (RGB)other;
            if (this.r != rGB.r) {
                return false;
            }
            if (this.g != rGB.g) {
                return false;
            }
            return this.b == rGB.b;
        }
    }
}

