/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.ssblur.scriptor.block.CastingLecternBlock;
import com.ssblur.scriptor.blockentity.CastingLecternBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/ssblur/scriptor/blockentity/renderers/CastingLecternBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lcom/ssblur/scriptor/blockentity/CastingLecternBlockEntity;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "itemRenderer", "Lnet/minecraft/client/renderer/entity/ItemRenderer;", "getItemRenderer", "()Lnet/minecraft/client/renderer/entity/ItemRenderer;", "setItemRenderer", "(Lnet/minecraft/client/renderer/entity/ItemRenderer;)V", "render", "", "lectern", "tickDelta", "", "matrix", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffers", "Lnet/minecraft/client/renderer/MultiBufferSource;", "light", "", "overlay", "scriptor"})
public final class CastingLecternBlockEntityRenderer
implements BlockEntityRenderer<CastingLecternBlockEntity> {
    @NotNull
    private ItemRenderer itemRenderer;

    public CastingLecternBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ItemRenderer itemRenderer = context.getItemRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)itemRenderer, (String)"getItemRenderer(...)");
        this.itemRenderer = itemRenderer;
    }

    @NotNull
    public final ItemRenderer getItemRenderer() {
        return this.itemRenderer;
    }

    public final void setItemRenderer(@NotNull ItemRenderer itemRenderer) {
        Intrinsics.checkNotNullParameter((Object)itemRenderer, (String)"<set-?>");
        this.itemRenderer = itemRenderer;
    }

    public void render(@NotNull CastingLecternBlockEntity lectern, float tickDelta, @NotNull PoseStack matrix, @NotNull MultiBufferSource buffers, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)lectern), (String)"lectern");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)buffers, (String)"buffers");
        Level level = lectern.getLevel();
        if (lectern.isRemoved() || level == null) {
            return;
        }
        float time = (float)level.getGameTime() + tickDelta;
        time %= 101.0f;
        time /= 100.0f;
        matrix.pushPose();
        int combined = lectern.getBlockPos().getX() + lectern.getBlockPos().getY() + lectern.getBlockPos().getZ();
        float translateY = (float)Math.sin(((double)((long)combined + level.getGameTime()) + (double)tickDelta) / (double)8);
        translateY /= 64.0f;
        int rotationY = 0;
        float translateX = 0.0f;
        float translateZ = 0.0f;
        BlockState state = level.getBlockState(lectern.getBlockPos());
        Direction direction = (Direction)state.getValue((Property)CastingLecternBlock.Companion.getFACING());
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                translateZ += 0.2f;
                rotationY += 180;
                break;
            }
            case 2: {
                translateZ -= 0.2f;
                break;
            }
            case 3: {
                rotationY += 270;
                translateX -= 0.2f;
                break;
            }
            default: {
                rotationY += 90;
                translateX += 0.2f;
            }
        }
        matrix.pushPose();
        matrix.translate(0.5f, 1.3f, 0.5f);
        matrix.scale(0.5f, 0.5f, 0.5f);
        matrix.mulPose(Axis.YP.rotationDegrees(time * (float)360));
        this.itemRenderer.renderStatic(lectern.getFocus(), ItemDisplayContext.GROUND, light, overlay, matrix, buffers, level, (int)lectern.getBlockPos().asLong());
        matrix.popPose();
        matrix.translate(0.5f + translateX, 1.3f + translateY, 0.5f + translateZ);
        matrix.mulPose(Axis.ZP.rotationDegrees(180.0f));
        matrix.mulPose(Axis.YP.rotationDegrees((float)rotationY));
        matrix.mulPose(Axis.XP.rotationDegrees(112.0f));
        this.itemRenderer.renderStatic(lectern.getSpellbook(), ItemDisplayContext.FIXED, light, overlay, matrix, buffers, level, (int)lectern.getBlockPos().asLong());
        matrix.popPose();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.SOUTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

