/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity;

import com.ssblur.scriptor.block.WritingTableBlock;
import com.ssblur.scriptor.blockentity.ScriptorBlockEntities;
import com.ssblur.scriptor.item.ScriptorItems;
import com.ssblur.scriptor.item.ScriptorTags;
import com.ssblur.scriptor.screen.menu.WritingTableMenu;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 F2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001FB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0006\u0010%\u001a\u00020\"J\b\u0010&\u001a\u00020\"H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020(H\u0016J\u0018\u0010-\u001a\u00020\f2\u0006\u0010,\u001a\u00020(2\u0006\u0010.\u001a\u00020(H\u0016J\u0010\u0010/\u001a\u00020\f2\u0006\u0010,\u001a\u00020(H\u0016J\u0018\u00100\u001a\u00020\"2\u0006\u0010,\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u00101\u001a\u00020*2\u0006\u00102\u001a\u000203H\u0016J\u0018\u00104\u001a\u0002052\u0006\u0010,\u001a\u00020(2\u0006\u00106\u001a\u000207H\u0014J\b\u00108\u001a\u000209H\u0014J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014J\u0016\u0010;\u001a\u00020\"2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J\"\u0010A\u001a\u00020*2\u0006\u0010,\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010?\u001a\u0004\u0018\u00010@H\u0016J \u0010B\u001a\u00020*2\u0006\u0010,\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010C\u001a\u00020\"2\u0006\u0010D\u001a\u00020EH\u0016R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006G"}, d2={"Lcom/ssblur/scriptor/blockentity/WritingTableBlockEntity;", "Lnet/minecraft/world/level/block/entity/BaseContainerBlockEntity;", "Lnet/minecraft/world/WorldlyContainer;", "Lnet/minecraft/world/inventory/StackedContentsCompatible;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "tableItems", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "getTableItems", "()Lnet/minecraft/core/NonNullList;", "setTableItems", "(Lnet/minecraft/core/NonNullList;)V", "itemStack", "dictionary", "getDictionary", "()Lnet/minecraft/world/item/ItemStack;", "setDictionary", "(Lnet/minecraft/world/item/ItemStack;)V", "book", "getBook", "setBook", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getUpdateTag", "Lnet/minecraft/nbt/CompoundTag;", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "", "tag", "saveAdditional", "tick", "clearContent", "getContainerSize", "", "isEmpty", "", "getItem", "i", "removeItem", "j", "removeItemNoUpdate", "setItem", "stillValid", "player", "Lnet/minecraft/world/entity/player/Player;", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "inventory", "Lnet/minecraft/world/entity/player/Inventory;", "getDefaultName", "Lnet/minecraft/network/chat/Component;", "getItems", "setItems", "nonNullList", "getSlotsForFace", "", "direction", "Lnet/minecraft/core/Direction;", "canPlaceItemThroughFace", "canTakeItemThroughFace", "fillStackedContents", "stackedContents", "Lnet/minecraft/world/entity/player/StackedContents;", "Companion", "scriptor"})
public final class WritingTableBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
StackedContentsCompatible {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private NonNullList<ItemStack> tableItems;
    public static final int DICTIONARY_SLOT = 0;
    public static final int BOOK_SLOT = 1;

    public WritingTableBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super((BlockEntityType)ScriptorBlockEntities.INSTANCE.getWRITING_TABLE().get(), blockPos, blockState);
        this.tableItems = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    }

    @NotNull
    public final NonNullList<ItemStack> getTableItems() {
        return this.tableItems;
    }

    public final void setTableItems(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.tableItems = nonNullList;
    }

    @NotNull
    public final ItemStack getDictionary() {
        Object object = this.tableItems.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    public final void setDictionary(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        this.tableItems.set(0, (Object)itemStack);
        if (this.level != null) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
        this.setChanged();
    }

    @NotNull
    public final ItemStack getBook() {
        Object object = this.tableItems.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    public final void setBook(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        this.tableItems.set(1, (Object)itemStack);
        if (this.level != null) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
        this.setChanged();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return (Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)((BlockEntity)this));
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        CompoundTag tag = super.getUpdateTag(provider);
        Intrinsics.checkNotNull((Object)tag);
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super.loadAdditional(tag, provider);
        this.tableItems = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.tableItems, (HolderLookup.Provider)provider);
        this.setChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super.saveAdditional(tag, provider);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.tableItems, (HolderLookup.Provider)provider);
    }

    public final void tick() {
        block7: {
            block6: {
                block5: {
                    if (this.level == null) break block5;
                    Level level = this.level;
                    Intrinsics.checkNotNull((Object)level);
                    if (!level.isClientSide) break block6;
                }
                return;
            }
            if (!Intrinsics.areEqual((Object)this.getBlockState().getValue((Property)WritingTableBlock.Companion.getBOOK()), (Object)this.getDictionary().isEmpty())) break block7;
            Level level = this.level;
            if (level != null) {
                level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)WritingTableBlock.Companion.getBOOK(), (Comparable)Boolean.valueOf(!this.getDictionary().isEmpty())));
            }
        }
    }

    public void clearContent() {
        this.tableItems.clear();
    }

    public int getContainerSize() {
        return 2;
    }

    public boolean isEmpty() {
        return this.tableItems.isEmpty();
    }

    @NotNull
    public ItemStack getItem(int i) {
        Object object = this.tableItems.get(i);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    @NotNull
    public ItemStack removeItem(int i, int j) {
        this.setChanged();
        ItemStack out = ((ItemStack)this.tableItems.get(i)).copyWithCount(j);
        ((ItemStack)this.tableItems.get(i)).shrink(j);
        Intrinsics.checkNotNull((Object)out);
        return out;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int i) {
        Object object = this.tableItems.get(i);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ItemStack stack = (ItemStack)object;
        this.tableItems.set(i, (Object)ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int i, @NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        this.setChanged();
        this.tableItems.set(i, (Object)itemStack);
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return player.distanceToSqr(this.getBlockPos().getCenter()) < player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int i, @NotNull Inventory inventory) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        return new WritingTableMenu(i, inventory, this);
    }

    @NotNull
    protected Component getDefaultName() {
        MutableComponent mutableComponent = Component.translatable((String)"menu.scriptor.writing_table");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.tableItems;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"nonNullList");
        this.tableItems = nonNullList;
    }

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> {
                int[] var2_2 = new int[]{1};
                yield var2_2;
            }
            case 2 -> {
                int[] var2_3 = new int[]{0};
                yield var2_3;
            }
            default -> new int[]{};
        };
    }

    public boolean canPlaceItemThroughFace(int i, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        if (direction == null || ArraysKt.contains((int[])this.getSlotsForFace(direction), (int)i)) {
            if (i == 1 && itemStack.is(ScriptorTags.INSTANCE.getWRITABLE_SPELLBOOKS())) {
                return true;
            }
            if (i == 0 && itemStack.is((Holder)ScriptorItems.INSTANCE.getDICTIONARY())) {
                return true;
            }
        }
        return false;
    }

    public boolean canTakeItemThroughFace(int i, @NotNull ItemStack itemStack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        if (ArraysKt.contains((int[])this.getSlotsForFace(direction), (int)i)) {
            if (i == 1 && itemStack.is(ScriptorTags.INSTANCE.getWRITABLE_SPELLBOOKS())) {
                return true;
            }
            if (i == 0 && itemStack.is((Holder)ScriptorItems.INSTANCE.getDICTIONARY())) {
                return true;
            }
        }
        return false;
    }

    public void fillStackedContents(@NotNull StackedContents stackedContents) {
        Intrinsics.checkNotNullParameter((Object)stackedContents, (String)"stackedContents");
        Iterator iterator = this.tableItems.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack itemStack = (ItemStack)iterator2.next();
            stackedContents.accountStack(itemStack);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/ssblur/scriptor/blockentity/WritingTableBlockEntity$Companion;", "", "<init>", "()V", "DICTIONARY_SLOT", "", "BOOK_SLOT", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level level, @NotNull BlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
            if (level.isClientSide) {
                return;
            }
            if (blockEntity instanceof WritingTableBlockEntity) {
                ((WritingTableBlockEntity)blockEntity).tick();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

