/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity;

import com.ssblur.scriptor.blockentity.ScriptorBlockEntities;
import com.ssblur.scriptor.config.ScriptorConfig;
import com.ssblur.scriptor.data.saved_data.DictionarySavedData;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.network.client.ParticleNetwork;
import com.ssblur.scriptor.word.Spell;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B%\b\u0016\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0006\u0010\u0017\u001a\u00020\u0018J&\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001fH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010'\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lcom/ssblur/scriptor/blockentity/ChalkBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "word", "", "getWord", "()Ljava/lang/String;", "setWord", "(Ljava/lang/String;)V", "facing", "Lnet/minecraft/core/Direction;", "getFacing", "()Lnet/minecraft/core/Direction;", "setFacing", "(Lnet/minecraft/core/Direction;)V", "cast", "", "visited", "", "initialWords", "primary", "", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getUpdateTag", "Lnet/minecraft/nbt/CompoundTag;", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "tag", "saveAdditional", "scriptor"})
@SourceDebugExtension(value={"SMAP\nChalkBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChalkBlockEntity.kt\ncom/ssblur/scriptor/blockentity/ChalkBlockEntity\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,119:1\n108#2:120\n80#2,22:121\n*S KotlinDebug\n*F\n+ 1 ChalkBlockEntity.kt\ncom/ssblur/scriptor/blockentity/ChalkBlockEntity\n*L\n75#1:120\n75#1:121,22\n*E\n"})
public class ChalkBlockEntity
extends BlockEntity {
    @NotNull
    private String word;
    @NotNull
    private Direction facing;

    @NotNull
    public final String getWord() {
        return this.word;
    }

    public final void setWord(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.word = string;
    }

    @NotNull
    public final Direction getFacing() {
        return this.facing;
    }

    public final void setFacing(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"<set-?>");
        this.facing = direction;
    }

    public ChalkBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super((BlockEntityType)ScriptorBlockEntities.INSTANCE.getCHALK().get(), blockPos, blockState);
        this.word = "";
        this.facing = Direction.EAST;
    }

    public ChalkBlockEntity(@NotNull BlockEntityType<?> blockEntityType, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockEntityType, blockPos, blockState);
        this.word = "";
        this.facing = Direction.EAST;
    }

    public final void cast() {
        this.cast(new ArrayList(), "", true);
    }

    /*
     * WARNING - void declaration
     */
    public void cast(@NotNull List<BlockPos> visited, @NotNull String initialWords, boolean primary) {
        Intrinsics.checkNotNullParameter(visited, (String)"visited");
        Intrinsics.checkNotNullParameter((Object)initialWords, (String)"initialWords");
        Object words = initialWords;
        boolean continued = false;
        BlockPos blockPos = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        visited.add(blockPos);
        if (!visited.contains(this.getBlockPos().north())) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            if (level.getBlockEntity(this.getBlockPos().north()) instanceof ChalkBlockEntity) {
                Level level2 = this.level;
                Intrinsics.checkNotNull((Object)level2);
                BlockEntity blockEntity = level2.getBlockEntity(this.getBlockPos().north());
                Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type com.ssblur.scriptor.blockentity.ChalkBlockEntity");
                ((ChalkBlockEntity)blockEntity).cast(visited, (String)words + " " + this.word, primary);
                continued = true;
            }
        }
        if (!visited.contains(this.getBlockPos().south())) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            if (level.getBlockEntity(this.getBlockPos().south()) instanceof ChalkBlockEntity) {
                Level level3 = this.level;
                Intrinsics.checkNotNull((Object)level3);
                BlockEntity blockEntity = level3.getBlockEntity(this.getBlockPos().south());
                Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type com.ssblur.scriptor.blockentity.ChalkBlockEntity");
                ((ChalkBlockEntity)blockEntity).cast(visited, (String)words + " " + this.word, !continued && primary);
                continued = true;
            }
        }
        if (!visited.contains(this.getBlockPos().east())) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            if (level.getBlockEntity(this.getBlockPos().east()) instanceof ChalkBlockEntity) {
                Level level4 = this.level;
                Intrinsics.checkNotNull((Object)level4);
                BlockEntity blockEntity = level4.getBlockEntity(this.getBlockPos().east());
                Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type com.ssblur.scriptor.blockentity.ChalkBlockEntity");
                ((ChalkBlockEntity)blockEntity).cast(visited, (String)words + " " + this.word, !continued && primary);
                continued = true;
            }
        }
        if (!visited.contains(this.getBlockPos().west())) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            if (level.getBlockEntity(this.getBlockPos().west()) instanceof ChalkBlockEntity) {
                Level level5 = this.level;
                Intrinsics.checkNotNull((Object)level5);
                BlockEntity blockEntity = level5.getBlockEntity(this.getBlockPos().west());
                Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type com.ssblur.scriptor.blockentity.ChalkBlockEntity");
                ((ChalkBlockEntity)blockEntity).cast(visited, (String)words + " " + this.word, !continued && primary);
                continued = true;
            }
        }
        if (continued) {
            return;
        }
        if (this.level instanceof ServerLevel) {
            Spell spell;
            void $this$trim$iv;
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel server = (ServerLevel)level;
            Object object = words = (String)words + " " + this.word;
            DictionarySavedData dictionarySavedData = DictionarySavedData.Companion.computeIfAbsent(server);
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if ((spell = dictionarySavedData.parse(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) != null && spell.cost() < (double)((Number)ScriptorConfig.INSTANCE.getCHALK_MAX_COST().invoke()).intValue()) {
                Level level6 = (Level)server;
                BlockPos blockPos2 = this.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
                Targetable target = new Targetable(level6, blockPos2);
                target.setFacing(this.facing);
                for (BlockPos block : visited) {
                    server.setBlockAndUpdate(block, Blocks.AIR.defaultBlockState());
                }
                server.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
                spell.cast(target);
            } else if (primary) {
                ParticleNetwork.INSTANCE.fizzle((Level)server, visited.get(0));
                server.playSound(null, visited.get(0), SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, server.getRandom().nextFloat() * 0.4f + 0.8f);
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return (Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        CompoundTag tag = super.getUpdateTag(provider);
        tag.putString("scriptor:word", this.word);
        tag.putInt("scriptor:facing", this.facing.ordinal());
        Intrinsics.checkNotNull((Object)tag);
        return tag;
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super.loadAdditional(tag, provider);
        this.word = tag.getString("scriptor:word");
        this.facing = (Direction)EntriesMappings.entries$0.get(tag.getInt("scriptor:facing"));
        this.setChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super.saveAdditional(tag, provider);
        tag.putString("scriptor:word", this.word);
        tag.putInt("scriptor:facing", this.facing.ordinal());
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }
}

