/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity;

import com.ssblur.scriptor.block.CastingLecternBlock;
import com.ssblur.scriptor.blockentity.ScriptorBlockEntities;
import com.ssblur.scriptor.config.ScriptorConfig;
import com.ssblur.scriptor.data.saved_data.DictionarySavedData;
import com.ssblur.scriptor.helpers.LimitedBookSerializer;
import com.ssblur.scriptor.helpers.targetable.LecternTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.item.casters.CasterCrystal;
import com.ssblur.scriptor.network.client.ParticleNetwork;
import com.ssblur.scriptor.word.Spell;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010,\u001a\u00020*2\u0006\u0010+\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014J\u0006\u0010-\u001a\u00020*J\b\u0010.\u001a\u00020*H\u0016R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R$\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001e\u00a8\u00060"}, d2={"Lcom/ssblur/scriptor/blockentity/CastingLecternBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/Clearable;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "items", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "getItems", "()Lnet/minecraft/core/NonNullList;", "setItems", "(Lnet/minecraft/core/NonNullList;)V", "focusTarget", "", "getFocusTarget", "()I", "setFocusTarget", "(I)V", "cooldown", "getCooldown", "setCooldown", "itemStack", "spellbook", "getSpellbook", "()Lnet/minecraft/world/item/ItemStack;", "setSpellbook", "(Lnet/minecraft/world/item/ItemStack;)V", "focus", "getFocus", "setFocus", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getUpdateTag", "Lnet/minecraft/nbt/CompoundTag;", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "", "tag", "saveAdditional", "tick", "clearContent", "Companion", "scriptor"})
public final class CastingLecternBlockEntity
extends BlockEntity
implements Clearable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private NonNullList<ItemStack> items;
    private int focusTarget;
    private int cooldown;
    public static final int SPELLBOOK_SLOT = 0;
    public static final int CASTING_FOCUS_SLOT = 1;

    public CastingLecternBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super((BlockEntityType)ScriptorBlockEntities.INSTANCE.getCASTING_LECTERN().get(), blockPos, blockState);
        this.items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    }

    @NotNull
    public final NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.items = nonNullList;
    }

    public final int getFocusTarget() {
        return this.focusTarget;
    }

    public final void setFocusTarget(int n) {
        this.focusTarget = n;
    }

    public final int getCooldown() {
        return this.cooldown;
    }

    public final void setCooldown(int n) {
        this.cooldown = n;
    }

    @NotNull
    public final ItemStack getSpellbook() {
        Object object = this.items.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    public final void setSpellbook(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        this.items.set(0, (Object)itemStack);
        if (this.level != null) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
        this.setChanged();
    }

    @NotNull
    public final ItemStack getFocus() {
        Object object = this.items.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    public final void setFocus(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        this.items.set(1, (Object)itemStack);
        if (this.level != null) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
        this.setChanged();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return (Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        CompoundTag tag = super.getUpdateTag(provider);
        Intrinsics.checkNotNull((Object)tag);
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super.loadAdditional(tag, provider);
        this.items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
        this.setChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super.saveAdditional(tag, provider);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
    }

    public final void tick() {
        Spell spell;
        ItemStack item;
        WrittenBookContent tag;
        block9: {
            block8: {
                if (this.level == null) break block8;
                Level level = this.level;
                Intrinsics.checkNotNull((Object)level);
                if (!level.isClientSide) break block9;
            }
            return;
        }
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel server = (ServerLevel)level;
        this.cooldown = (int)Math.max(0.0, (double)this.cooldown - 1.0);
        Level level2 = this.level;
        Intrinsics.checkNotNull((Object)level2);
        if (level2.getBestNeighborSignal(this.getBlockPos()) == 0 && !this.getSpellbook().isEmpty() && this.cooldown == 0 && (tag = (WrittenBookContent)(item = this.getSpellbook()).get(DataComponents.WRITTEN_BOOK_CONTENT)) != null && (spell = DictionarySavedData.Companion.computeIfAbsent(server).parse(LimitedBookSerializer.INSTANCE.decodeText(tag))) != null) {
            if (spell.cost() > (double)((Number)ScriptorConfig.INSTANCE.getCASTING_LECTERN_MAX_COST().invoke()).intValue()) {
                Level level3 = this.level;
                Intrinsics.checkNotNull((Object)level3);
                BlockPos blockPos = this.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                ParticleNetwork.INSTANCE.fizzle(level3, blockPos);
                server.playSound(null, this.getBlockPos(), SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, server.getRandom().nextFloat() * 0.4f + 0.8f);
                this.cooldown += (int)Math.round(200.0 * ((double)((Number)ScriptorConfig.INSTANCE.getCASTING_LECTERN_COOLDOWN_MULTIPLIER().invoke()).intValue() / 100.0));
                return;
            }
            BlockState state = server.getBlockState(this.getBlockPos());
            Direction direction = ((Direction)state.getValue((Property)CastingLecternBlock.Companion.getFACING())).getOpposite();
            Vec3 pos = this.getBlockPos().getCenter();
            Level level4 = this.getLevel();
            Intrinsics.checkNotNull((Object)level4);
            Intrinsics.checkNotNull((Object)pos);
            Targetable target = new LecternTargetable(level4, pos).setFacing(direction);
            if (this.getFocus().getItem() instanceof CasterCrystal) {
                Item item2 = this.getFocus().getItem();
                Intrinsics.checkNotNull((Object)item2, (String)"null cannot be cast to non-null type com.ssblur.scriptor.item.casters.CasterCrystal");
                CasterCrystal crystal = (CasterCrystal)item2;
                List<Targetable> foci = crystal.getTargetables(this.getFocus(), (Level)server);
                Collection collection = foci;
                if (!(collection == null || collection.isEmpty())) {
                    int n = this.focusTarget;
                    this.focusTarget = n + 1;
                    this.focusTarget %= foci.size();
                    Targetable focus = foci.get(this.focusTarget);
                    if (focus != null && focus.getTargetPos().distanceTo(target.getTargetPos()) <= 16.0 && focus.getLevel() == this.level) {
                        target.setFinalTargetable(focus);
                    }
                }
            }
            spell.cast(target);
            this.cooldown += RangesKt.coerceAtLeast((int)((int)Math.round(spell.cost() * 10.0 * ((double)((Number)ScriptorConfig.INSTANCE.getCASTING_LECTERN_COOLDOWN_MULTIPLIER().invoke()).intValue() / 100.0))), (int)10);
        }
    }

    public void clearContent() {
        this.items.clear();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/ssblur/scriptor/blockentity/CastingLecternBlockEntity$Companion;", "", "<init>", "()V", "SPELLBOOK_SLOT", "", "CASTING_FOCUS_SLOT", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level level, @NotNull BlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
            if (level.isClientSide) {
                return;
            }
            if (blockEntity instanceof CastingLecternBlockEntity) {
                ((CastingLecternBlockEntity)blockEntity).tick();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

