/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.api;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.registry.words.WordRegistry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lcom/ssblur/scriptor/api/ScriptorRegistry;", "", "<init>", "()V", "register", "Lcom/ssblur/scriptor/api/word/Word;", "key", "", "word", "Lnet/minecraft/resources/ResourceLocation;", "scriptor"})
public final class ScriptorRegistry {
    @NotNull
    public static final ScriptorRegistry INSTANCE = new ScriptorRegistry();

    private ScriptorRegistry() {
    }

    @NotNull
    public final Word register(@NotNull String key, @NotNull Word word) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (word instanceof Action) {
            Action action = WordRegistry.INSTANCE.register(key, (Action)word);
            Intrinsics.checkNotNull((Object)action);
            return action;
        }
        if (word instanceof Subject) {
            Subject subject = WordRegistry.INSTANCE.register(key, (Subject)word);
            Intrinsics.checkNotNull((Object)subject);
            return subject;
        }
        if (word instanceof Descriptor) {
            Descriptor descriptor = WordRegistry.INSTANCE.register(key, (Descriptor)word);
            Intrinsics.checkNotNull((Object)descriptor);
            return descriptor;
        }
        throw new RuntimeException("Unknown Word type! Expected one of Action, Subject, or Descriptor.");
    }

    @NotNull
    public final Word register(@NotNull ResourceLocation key, @NotNull Word word) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        String string = key.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.register(string, word);
    }
}

