/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopeedge;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.misc.MiscDirs;
import xfacthd.framedblocks.common.data.skippreds.pillar.PillarDirs;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabDirs;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeDirs;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.SlopeEdgeDirs;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelDirs;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabDirs;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsDirs;

@CullTest(value={BlockType.FRAMED_ELEVATED_SLOPE_EDGE})
public final class ElevatedSlopeEdgeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            SlopeType type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
            return switch (blockType) {
                case BlockType.FRAMED_ELEVATED_SLOPE_EDGE -> ElevatedSlopeEdgeSkipPredicate.testAgainstElevatedSlopeEdge(dir, type, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> ElevatedSlopeEdgeSkipPredicate.testAgainstHalfSlope(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_SLOPE -> ElevatedSlopeEdgeSkipPredicate.testAgainstVerticalHalfSlope(dir, type, adjState, side);
                case BlockType.FRAMED_SLOPE_EDGE -> ElevatedSlopeEdgeSkipPredicate.testAgainstSlopeEdge(dir, type, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE -> ElevatedSlopeEdgeSkipPredicate.testAgainstInnerCornerSlopeEdge(dir, type, adjState, side);
                case BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE -> ElevatedSlopeEdgeSkipPredicate.testAgainstElevatedCornerSlopeEdge(dir, type, adjState, side);
                case BlockType.FRAMED_ELEVATED_INNER_CORNER_SLOPE_EDGE -> ElevatedSlopeEdgeSkipPredicate.testAgainstElevatedInnerCornerSlopeEdge(dir, type, adjState, side);
                case BlockType.FRAMED_SLAB -> ElevatedSlopeEdgeSkipPredicate.testAgainstSlab(dir, type, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> ElevatedSlopeEdgeSkipPredicate.testAgainstSlabEdge(dir, type, adjState, side);
                case BlockType.FRAMED_PANEL -> ElevatedSlopeEdgeSkipPredicate.testAgainstPanel(dir, type, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> ElevatedSlopeEdgeSkipPredicate.testAgainstCornerPillar(dir, type, adjState, side);
                case BlockType.FRAMED_STAIRS -> ElevatedSlopeEdgeSkipPredicate.testAgainstStairs(dir, type, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> ElevatedSlopeEdgeSkipPredicate.testAgainstHalfStairs(dir, type, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> ElevatedSlopeEdgeSkipPredicate.testAgainstSlopedStairs(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> ElevatedSlopeEdgeSkipPredicate.testAgainstVerticalStairs(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> ElevatedSlopeEdgeSkipPredicate.testAgainstVerticalHalfStairs(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> ElevatedSlopeEdgeSkipPredicate.testAgainstVerticalSlopedStairs(dir, type, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> ElevatedSlopeEdgeSkipPredicate.testAgainstSlopeSlab(dir, type, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> ElevatedSlopeEdgeSkipPredicate.testAgainstElevatedSlopeSlab(dir, type, adjState, side);
                case BlockType.FRAMED_COMPOUND_SLOPE_SLAB -> ElevatedSlopeEdgeSkipPredicate.testAgainstCompoundSlopeSlab(dir, type, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> ElevatedSlopeEdgeSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, type, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> ElevatedSlopeEdgeSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(dir, type, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> ElevatedSlopeEdgeSkipPredicate.testAgainstSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> ElevatedSlopeEdgeSkipPredicate.testAgainstExtendedSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_COMPOUND_SLOPE_PANEL -> ElevatedSlopeEdgeSkipPredicate.testAgainstCompoundSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> ElevatedSlopeEdgeSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, type, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> ElevatedSlopeEdgeSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, type, adjState, side);
                case BlockType.FRAMED_ELEVATED_PYRAMID_SLAB -> ElevatedSlopeEdgeSkipPredicate.testAgainstElevatedPyramidSlab(dir, type, adjState, side);
                case BlockType.FRAMED_MASONRY_CORNER_SEGMENT -> ElevatedSlopeEdgeSkipPredicate.testAgainstMasonryCornerSegment(dir, type, adjState, side);
                case BlockType.FRAMED_LAYERED_CUBE -> ElevatedSlopeEdgeSkipPredicate.testAgainstLayeredCube(dir, type, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_EDGE})
    private static boolean testAgainstElevatedSlopeEdge(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        return SlopeEdgeDirs.ElevatedSlopeEdge.getTriDir(dir, type, side).isEqualTo(SlopeEdgeDirs.ElevatedSlopeEdge.getTriDir(adjDir, adjType, side.getOpposite())) || SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstHalfSlope(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeDirs.HalfSlope.getHalfDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalHalfSlope(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeDirs.VerticalHalfSlope.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_EDGE})
    private static boolean testAgainstSlopeEdge(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeEdgeDirs.SlopeEdge.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerCornerSlopeEdge(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedCornerSlopeEdge(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return SlopeEdgeDirs.ElevatedSlopeEdge.getTriDir(dir, type, side).isEqualTo(SlopeEdgeDirs.ElevatedCornerSlopeEdge.getTriDir(adjDir, adjType, side.getOpposite())) || SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedInnerCornerSlopeEdge(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return SlopeEdgeDirs.ElevatedSlopeEdge.getTriDir(dir, type, side).isEqualTo(SlopeEdgeDirs.ElevatedInnerCornerSlopeEdge.getTriDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB})
    private static boolean testAgainstSlab(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlabDirs.Slab.getHalfDir(adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlabDirs.SlabEdge.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PANEL})
    private static boolean testAgainstPanel(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlabDirs.Panel.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstCornerPillar(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(PillarDirs.CornerPillar.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        StairsShape adjShape = (StairsShape)adjState.getValue((Property)BlockStateProperties.STAIRS_SHAPE);
        Half adjHalf = (Half)adjState.getValue((Property)BlockStateProperties.HALF);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(StairsDirs.Stairs.getHalfDir(adjDir, adjShape, adjHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(StairsDirs.HalfStairs.getHalfDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPED_STAIRS})
    private static boolean testAgainstSlopedStairs(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(StairsDirs.SlopedStairs.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.getValue(PropertyHolder.STAIRS_TYPE));
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(StairsDirs.VerticalStairs.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(StairsDirs.VerticalHalfStairs.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_SLOPED_STAIRS})
    private static boolean testAgainstVerticalSlopedStairs(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(StairsDirs.VerticalSlopedStairs.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstSlopeSlab(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeSlabDirs.SlopeSlab.getHalfDir(adjDir, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_SLAB})
    private static boolean testAgainstElevatedSlopeSlab(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeSlabDirs.ElevatedSlopeSlab.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_COMPOUND_SLOPE_SLAB})
    private static boolean testAgainstCompoundSlopeSlab(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeSlabDirs.CompoundSlopeSlab.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatInnerSlopeSlabCorner(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(adjDir, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedSlopeSlabCorner(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeSlabDirs.FlatElevatedSlopeSlabCorner.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstSlopePanel(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopePanelDirs.SlopePanel.getHalfDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXTENDED_SLOPE_PANEL})
    private static boolean testAgainstExtendedSlopePanel(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopePanelDirs.ExtendedSlopePanel.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_COMPOUND_SLOPE_PANEL})
    private static boolean testAgainstCompoundSlopePanel(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopePanelDirs.CompoundSlopePanel.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInnerSlopePanelCorner(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopePanelDirs.FlatInnerSlopePanelCorner.getHalfDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedSlopePanelCorner(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopePanelDirs.FlatExtendedSlopePanelCorner.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_PYRAMID_SLAB})
    private static boolean testAgainstElevatedPyramidSlab(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlopeDirs.ElevatedPyramidSlab.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_MASONRY_CORNER_SEGMENT})
    private static boolean testAgainstMasonryCornerSegment(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(SlabDirs.MasonryCornerSegment.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LAYERED_CUBE})
    private static boolean testAgainstLayeredCube(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjFacing = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        int adjLayers = (Integer)adjState.getValue((Property)BlockStateProperties.LAYERS);
        return SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(dir, type, side).isEqualTo(MiscDirs.LayeredCube.getHalfDir(adjFacing, adjLayers, side.getOpposite()));
    }
}

