/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.misc.MiscDirs;
import xfacthd.framedblocks.common.data.skippreds.pillar.PillarDirs;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabDirs;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeDirs;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.SlopeEdgeDirs;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelDirs;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SlopePanelCornerDirs;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsDirs;

@CullTest(value={BlockType.FRAMED_CORNER_PILLAR})
public final class CornerPillarSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            return switch (blockType) {
                case BlockType.FRAMED_CORNER_PILLAR -> CornerPillarSkipPredicate.testAgainstCornerPillar(dir, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> CornerPillarSkipPredicate.testAgainstHalfSlope(dir, adjState, side);
                case BlockType.FRAMED_SLOPE_EDGE -> CornerPillarSkipPredicate.testAgainstSlopeEdge(dir, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_EDGE -> CornerPillarSkipPredicate.testAgainstElevatedSlopeEdge(dir, adjState, side);
                case BlockType.FRAMED_CORNER_SLOPE_EDGE -> CornerPillarSkipPredicate.testAgainstCornerSlopeEdge(dir, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE -> CornerPillarSkipPredicate.testAgainstInnerCornerSlopeEdge(dir, adjState, side);
                case BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE -> CornerPillarSkipPredicate.testAgainstElevatedCornerSlopeEdge(dir, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> CornerPillarSkipPredicate.testAgainstSlabCorner(dir, adjState, side);
                case BlockType.FRAMED_PANEL -> CornerPillarSkipPredicate.testAgainstPanel(dir, adjState, side);
                case BlockType.FRAMED_STAIRS -> CornerPillarSkipPredicate.testAgainstStairs(dir, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> CornerPillarSkipPredicate.testAgainstHalfStairs(dir, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> CornerPillarSkipPredicate.testAgainstVerticalStairs(dir, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> CornerPillarSkipPredicate.testAgainstVerticalSlopedStairs(dir, adjState, side);
                case BlockType.FRAMED_THREEWAY_CORNER_PILLAR -> CornerPillarSkipPredicate.testAgainstThreewayCornerPillar(dir, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> CornerPillarSkipPredicate.testAgainstSlopePanel(dir, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> CornerPillarSkipPredicate.testAgainstExtendedSlopePanel(dir, adjState, side);
                case BlockType.FRAMED_COMPOUND_SLOPE_PANEL -> CornerPillarSkipPredicate.testAgainstCompoundSlopePanel(dir, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> CornerPillarSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> CornerPillarSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL -> CornerPillarSkipPredicate.testAgainstSmallCornerSlopePanel(dir, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL -> CornerPillarSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL -> CornerPillarSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, adjState, side);
                case BlockType.FRAMED_ELEVATED_PYRAMID_SLAB -> CornerPillarSkipPredicate.testAgainstElevatedPyramidSlab(dir, adjState, side);
                case BlockType.FRAMED_CHECKERED_PANEL_SEGMENT -> CornerPillarSkipPredicate.testAgainstCheckeredPanelSegment(dir, adjState, side);
                case BlockType.FRAMED_LAYERED_CUBE -> CornerPillarSkipPredicate.testAgainstLayeredCube(dir, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstCornerPillar(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(PillarDirs.CornerPillar.getHalfDir(adjDir, side.getOpposite())) || PillarDirs.CornerPillar.getCornerDir(dir, side).isEqualTo(PillarDirs.CornerPillar.getCornerDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstHalfSlope(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(SlopeDirs.HalfSlope.getHalfDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_EDGE})
    private static boolean testAgainstSlopeEdge(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(SlopeEdgeDirs.SlopeEdge.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_EDGE})
    private static boolean testAgainstElevatedSlopeEdge(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstCornerSlopeEdge(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return PillarDirs.CornerPillar.getCornerDir(dir, side).isEqualTo(SlopeEdgeDirs.CornerSlopeEdge.getCornerDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerCornerSlopeEdge(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedCornerSlopeEdge(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(adjDir, adjType, side.getOpposite())) || PillarDirs.CornerPillar.getCornerDir(dir, side).isEqualTo(SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_CORNER})
    private static boolean testAgainstSlabCorner(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return PillarDirs.CornerPillar.getCornerDir(dir, side).isEqualTo(SlabDirs.SlabCorner.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PANEL})
    private static boolean testAgainstPanel(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(SlabDirs.Panel.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        StairsShape adjShape = (StairsShape)adjState.getValue((Property)BlockStateProperties.STAIRS_SHAPE);
        Half adjHalf = (Half)adjState.getValue((Property)BlockStateProperties.HALF);
        return PillarDirs.CornerPillar.getCornerDir(dir, side).isEqualTo(StairsDirs.Stairs.getCornerDir(adjDir, adjShape, adjHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(StairsDirs.HalfStairs.getHalfDir(adjDir, adjTop, adjRight, side.getOpposite())) || PillarDirs.CornerPillar.getCornerDir(dir, side).isEqualTo(StairsDirs.HalfStairs.getCornerDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.getValue(PropertyHolder.STAIRS_TYPE));
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(StairsDirs.VerticalStairs.getHalfDir(adjDir, adjType, side.getOpposite())) || PillarDirs.CornerPillar.getCornerDir(dir, side).isEqualTo(StairsDirs.VerticalStairs.getCornerDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_SLOPED_STAIRS})
    private static boolean testAgainstVerticalSlopedStairs(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(StairsDirs.VerticalSlopedStairs.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THREEWAY_CORNER_PILLAR})
    private static boolean testAgainstThreewayCornerPillar(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return PillarDirs.CornerPillar.getCornerDir(dir, side).isEqualTo(PillarDirs.ThreewayCornerPillar.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstSlopePanel(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(SlopePanelDirs.SlopePanel.getHalfDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXTENDED_SLOPE_PANEL})
    private static boolean testAgainstExtendedSlopePanel(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(SlopePanelDirs.ExtendedSlopePanel.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_COMPOUND_SLOPE_PANEL})
    private static boolean testAgainstCompoundSlopePanel(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(SlopePanelDirs.CompoundSlopePanel.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInnerSlopePanelCorner(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(SlopePanelDirs.FlatInnerSlopePanelCorner.getHalfDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedSlopePanelCorner(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(SlopePanelDirs.FlatExtendedSlopePanelCorner.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallCornerSlopePanel(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return PillarDirs.CornerPillar.getCornerDir(dir, side).isEqualTo(SlopePanelCornerDirs.SmallCornerSlopePanel.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallInnerCornerSlopePanel(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return PillarDirs.CornerPillar.getCornerDir(dir, side).isEqualTo(SlopePanelCornerDirs.SmallInnerCornerSlopePanel.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedCornerSlopePanel(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return PillarDirs.CornerPillar.getCornerDir(dir, side).isEqualTo(SlopePanelCornerDirs.ExtendedCornerSlopePanel.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_PYRAMID_SLAB})
    private static boolean testAgainstElevatedPyramidSlab(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(SlopeDirs.ElevatedPyramidSlab.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_PANEL_SEGMENT})
    private static boolean testAgainstCheckeredPanelSegment(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjSecond = (Boolean)adjState.getValue((Property)PropertyHolder.SECOND);
        return PillarDirs.CornerPillar.getCornerDir(dir, side).isEqualTo(SlabDirs.CheckeredPanelSegment.getCornerDir(adjDir, adjSecond, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LAYERED_CUBE})
    private static boolean testAgainstLayeredCube(Direction dir, BlockState adjState, Direction side) {
        Direction adjFacing = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        int adjLayers = (Integer)adjState.getValue((Property)BlockStateProperties.LAYERS);
        return PillarDirs.CornerPillar.getHalfDir(dir, side).isEqualTo(MiscDirs.LayeredCube.getHalfDir(adjFacing, adjLayers, side.getOpposite()));
    }
}

