/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.prism;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.prism.IFramedPrismBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;

public class FramedSlopedPrismBlock
extends FramedBlock
implements IFramedPrismBlock {
    public FramedSlopedPrismBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(PropertyHolder.FACING_DIR, (Comparable)((Object)CompoundDirection.NORTH_UP))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PropertyHolder.FACING_DIR, BlockStateProperties.WATERLOGGED, FramedProperties.SOLID, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return FramedSlopedPrismBlock.getStateForPlacement(context, this);
    }

    public static <T extends Block> BlockState getStateForPlacement(BlockPlaceContext context, T block) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(block, context).withCustom((state, modCtx) -> {
            Direction orientation;
            Direction face = modCtx.getClickedFace();
            if (Utils.isY(face)) {
                orientation = modCtx.getHorizontalDirection();
                if (((IFramedPrismBlock)block).isInnerPrism()) {
                    orientation = orientation.getOpposite();
                }
            } else {
                Vec3 subHit = Utils.fraction(modCtx.getClickLocation());
                double xz = (Utils.isX(face) ? subHit.z() : subHit.x()) - 0.5;
                double y = subHit.y() - 0.5;
                orientation = Math.max(Math.abs(xz), Math.abs(y)) == Math.abs(xz) ? (Utils.isX(face) ? (xz < 0.0 ? Direction.SOUTH : Direction.NORTH) : (xz < 0.0 ? Direction.EAST : Direction.WEST)) : (y < 0.0 ? Direction.UP : Direction.DOWN);
            }
            return (BlockState)state.setValue(PropertyHolder.FACING_DIR, (Comparable)((Object)CompoundDirection.of(face, orientation)));
        })).withYSlope(Utils.isY(context.getClickedFace()))).tryWithWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.getValue(PropertyHolder.FACING_DIR));
        return (BlockState)state.setValue(PropertyHolder.FACING_DIR, (Comparable)((Object)cmpDir.rotate(rot)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.getValue(PropertyHolder.FACING_DIR));
        return (BlockState)state.setValue(PropertyHolder.FACING_DIR, (Comparable)((Object)cmpDir.mirror(mirror)));
    }

    @Override
    public BlockState getItemModelSource() {
        boolean outer = this.getBlockType() == BlockType.FRAMED_SLOPED_PRISM;
        CompoundDirection cmpDir = outer ? CompoundDirection.UP_WEST : CompoundDirection.UP_EAST;
        return (BlockState)this.defaultBlockState().setValue(PropertyHolder.FACING_DIR, (Comparable)((Object)cmpDir));
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }

    @Override
    public boolean isInnerPrism() {
        return this.getBlockType() != BlockType.FRAMED_SLOPED_PRISM;
    }
}

