/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectSpliterators;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.CamoContainerHelper;
import xfacthd.framedblocks.api.camo.empty.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.FramedByteBufCodecs;

public final class CamoList
implements Iterable<CamoContainer<?, ?>> {
    public static final Codec<CamoList> CODEC = CamoContainerHelper.CODEC.listOf().xmap(CamoList::of, list -> List.of(list.getCamosForSerialization()));
    public static final StreamCodec<RegistryFriendlyByteBuf, CamoList> STREAM_CODEC = FramedByteBufCodecs.array(CamoContainerHelper.STREAM_CODEC, CamoContainer[]::new, Integer.MAX_VALUE).map(CamoList::new, CamoList::getCamosForSerialization);
    public static final CamoList EMPTY = new CamoList(new CamoContainer[0]);
    private final CamoContainer<?, ?>[] camos;
    private final int offset;
    private final int size;

    private CamoList(CamoContainer<?, ?>[] camos) {
        this.camos = camos;
        this.offset = 0;
        this.size = camos.length;
    }

    private CamoList(CamoContainer<?, ?>[] camos, int from, int to) {
        this.camos = camos;
        this.offset = from;
        this.size = to - from;
    }

    public CamoContainer<?, ?> getCamo(int index) {
        if (this.size > index) {
            return this.camos[this.offset + index];
        }
        return EmptyCamoContainer.EMPTY;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isEmptyOrContentsEmpty() {
        int end = this.offset + this.size;
        for (int i = this.offset; i < end; ++i) {
            if (this.camos[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public CamoList concat(CamoList other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        CamoContainer[] array = new CamoContainer[this.size + other.size];
        System.arraycopy(this.camos, this.offset, array, 0, this.size);
        System.arraycopy(other.camos, other.offset, array, this.size, other.size);
        return new CamoList(array);
    }

    @Override
    public Iterator<CamoContainer<?, ?>> iterator() {
        return ObjectIterators.wrap((Object[])this.camos, (int)this.offset, (int)this.size);
    }

    @Override
    public Spliterator<CamoContainer<?, ?>> spliterator() {
        return ObjectSpliterators.wrap((Object[])this.camos, (int)this.offset, (int)this.size);
    }

    @Override
    public void forEach(Consumer<? super CamoContainer<?, ?>> action) {
        int end = this.offset + this.size;
        for (int i = this.offset; i < end; ++i) {
            action.accept(this.camos[i]);
        }
    }

    public Stream<CamoContainer<?, ?>> stream() {
        return Arrays.stream(this.camos, this.offset, this.offset + this.size);
    }

    public CamoList reversed() {
        return switch (this.size) {
            case 0 -> EMPTY;
            case 1 -> this;
            default -> new CamoList((CamoContainer[])ObjectArrays.reverse((Object[])((CamoContainer[])ObjectArrays.copy((Object[])this.camos, (int)this.offset, (int)this.size))));
        };
    }

    public CamoList subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new IllegalArgumentException("Invalid indizes");
        }
        if (fromIndex >= this.size) {
            return EMPTY;
        }
        return new CamoList(this.camos, fromIndex + this.offset, Math.min(toIndex, this.size) + this.offset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof CamoList)) return false;
        CamoList otherList = (CamoList)obj;
        if (!Arrays.equals(this.camos, this.offset, this.offset + this.size, otherList.camos, otherList.offset, otherList.offset + otherList.size)) return false;
        return true;
    }

    public int hashCode() {
        int result = 1;
        int end = this.offset + this.size;
        for (int i = this.offset; i < end; ++i) {
            result = 31 * result + this.camos[i].hashCode();
        }
        return result;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "CamoList[]";
        }
        StringBuilder builder = new StringBuilder("CamoList[");
        int end = this.offset + this.size;
        for (int i = this.offset; i < end; ++i) {
            if (i > this.offset) {
                builder.append(", ");
            }
            builder.append(this.camos[i]);
        }
        return builder.append("]").toString();
    }

    private CamoContainer<?, ?>[] getCamosForSerialization() {
        if (this.offset > 0 || this.size < this.camos.length) {
            return Arrays.copyOfRange(this.camos, this.offset, this.offset + this.size);
        }
        return this.camos;
    }

    public static CamoList of(CamoContainer<?, ?> camo) {
        return camo.isEmpty() ? EMPTY : new CamoList(new CamoContainer[]{camo});
    }

    public static CamoList of(CamoContainer<?, ?> ... camos) {
        return camos.length == 0 ? EMPTY : new CamoList(Arrays.copyOf(camos, camos.length));
    }

    public static CamoList of(List<CamoContainer<?, ?>> camos) {
        return camos.isEmpty() ? EMPTY : new CamoList((CamoContainer[])camos.toArray(CamoContainer[]::new));
    }
}

