/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.shapes;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.ApiStatus;
import xfacthd.framedblocks.api.internal.InternalAPI;

public final class ShapeCache<K> {
    private final Supplier<Map<K, VoxelShape>> mapFactory;
    private final Consumer<Map<K, VoxelShape>> generator;
    private Map<K, VoxelShape> cache;

    private ShapeCache(Supplier<Map<K, VoxelShape>> mapFactory, Consumer<Map<K, VoxelShape>> generator) {
        this.mapFactory = mapFactory;
        this.generator = generator;
        this.cache = mapFactory.get();
        generator.accept(this.cache);
        if (!FMLEnvironment.production) {
            InternalAPI.INSTANCE.registerShapeCache(this);
        }
    }

    public VoxelShape get(K key) {
        return this.cache.get(key);
    }

    public void forEach(BiConsumer<K, VoxelShape> consumer) {
        this.cache.forEach(consumer);
    }

    @ApiStatus.Internal
    public void reload() {
        Map<K, VoxelShape> map = this.mapFactory.get();
        this.generator.accept(map);
        this.cache = map;
    }

    public static <T> ShapeCache<T> create(Consumer<Map<T, VoxelShape>> generator) {
        return new ShapeCache(HashMap::new, generator);
    }

    public static <T> ShapeCache<T> createIdentity(Consumer<Map<T, VoxelShape>> generator) {
        return new ShapeCache(IdentityHashMap::new, generator);
    }

    public static <T extends Enum<T>> ShapeCache<T> createEnum(Class<T> enumClazz, Consumer<Map<T, VoxelShape>> generator) {
        return new ShapeCache(() -> new EnumMap(enumClazz), generator);
    }
}

