/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.blocks;

import com.kyanite.deeperdarker.content.DDEntities;
import com.kyanite.deeperdarker.content.entities.SculkLeech;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class InfestedSculkBlock
extends Block {
    public InfestedSculkBlock(Block hostBlock, BlockBehaviour.Properties properties) {
        super(properties.destroyTime(hostBlock.defaultDestroyTime() / 2.0f).explosionResistance(0.75f));
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            level.setBlock(pos, Blocks.SCULK.defaultBlockState(), 3);
            player.knockback(1.5, player.getX() - (double)pos.getX(), player.getZ() - (double)pos.getZ());
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ((EntityType)DDEntities.SHRIEK_WORM.get()).spawn(serverLevel, pos, MobSpawnType.TRIGGERED);
            }
        }
        if (level.isClientSide() && entity instanceof LivingEntity) {
            RandomSource random = RandomSource.create();
            for (int i = 0; i < 20; ++i) {
                double sX = random.nextGaussian() * 0.02;
                double sY = random.nextGaussian() * 0.02;
                double sZ = random.nextGaussian() * 0.02;
                level.addParticle((ParticleOptions)ParticleTypes.POOF, (double)pos.getX() + random.nextDouble(), (double)pos.above().getY(), (double)pos.getZ() + random.nextDouble(), sX, sY, sZ);
            }
        }
    }

    public void spawnAfterBreak(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack, boolean dropExperience) {
        SculkLeech leech;
        super.spawnAfterBreak(state, level, pos, stack, dropExperience);
        HolderLookup.RegistryLookup lookup = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        if (stack.getEnchantmentLevel((Holder)lookup.getOrThrow(Enchantments.SILK_TOUCH)) == 0 && (leech = (SculkLeech)((EntityType)DDEntities.SCULK_LEECH.get()).create((Level)level)) != null) {
            leech.moveTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            level.addFreshEntity((Entity)leech);
            leech.spawnAnim();
        }
    }
}

