/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.world.gen.feature.config.UtheriumCrystalConfiguration;

public class UtheriumCrystalFeature
extends Feature<UtheriumCrystalConfiguration> {
    private static final ImmutableList<Block> CAN_PLACE_ON = ImmutableList.of((Object)((Block)UGBlocks.DREADROCK.get()), (Object)((Block)UGBlocks.DREADROCK_ROGDORIUM_ORE.get()), (Object)((Block)UGBlocks.DREADROCK_UTHERIUM_ORE.get()), (Object)((Block)UGBlocks.UTHERIUM_GROWTH.get()), (Object)((Block)UGBlocks.COARSE_DEEPSOIL.get()));

    public UtheriumCrystalFeature(Codec<UtheriumCrystalConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<UtheriumCrystalConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos blockpos = context.origin();
        UtheriumCrystalConfiguration baseConfig = (UtheriumCrystalConfiguration)context.config();
        RandomSource random = context.random();
        if (!this.canPlaceAt((LevelAccessor)level, blockpos.mutable(), baseConfig.ceilingCrystals())) {
            return false;
        }
        if (random.nextFloat() < baseConfig.crystalChance()) {
            Object t;
            LargeDripstoneConfiguration config = baseConfig.crystalConfig();
            Optional optional = Column.scan((LevelSimulatedReader)level, (BlockPos)blockpos, (int)config.floorToCeilingSearchRange, DripstoneUtils::isEmptyOrWater, state -> CAN_PLACE_ON.contains((Object)state.getBlock()));
            if (optional.isPresent() && (t = optional.get()) instanceof Column.Range) {
                Column.Range range = (Column.Range)t;
                if (range.height() < 4) {
                    return false;
                }
                int i = (int)((float)range.height() * config.maxColumnRadiusToCaveHeightRatio);
                int j = Mth.clamp((int)i, (int)config.columnRadius.getMinValue(), (int)config.columnRadius.getMaxValue());
                int k = Mth.randomBetweenInclusive((RandomSource)random, (int)config.columnRadius.getMinValue(), (int)j);
                LargeCrystal crystal = UtheriumCrystalFeature.makeCrystal(blockpos.atY(range.ceiling() - 1), false, random, k, config.stalactiteBluntness, config.heightScale);
                LargeCrystal crystal1 = UtheriumCrystalFeature.makeCrystal(blockpos.atY(range.floor() + 1), true, random, k, config.stalagmiteBluntness, config.heightScale);
                boolean flag = crystal.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(level);
                boolean flag1 = crystal1.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(level);
                if (flag) {
                    crystal.placeBlocks(level, random);
                }
                if (flag1) {
                    crystal1.placeBlocks(level, random);
                }
                return true;
            }
            LargeCrystal crystal = UtheriumCrystalFeature.makeCrystal(blockpos, baseConfig.ceilingCrystals(), random, config.columnRadius.sample(random), config.stalagmiteBluntness, config.heightScale);
            boolean flag = crystal.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(level);
            if (flag) {
                crystal.placeBlocks(level, random);
            }
            return true;
        }
        ColumnFeatureConfiguration config = baseConfig.clusterConfig();
        int heightSample = config.height().sample(random);
        boolean flag = random.nextFloat() < 0.9f;
        int k = Math.min(heightSample, flag ? 5 : 8);
        int l = flag ? 50 : 15;
        boolean flag1 = false;
        for (BlockPos blockpos1 : BlockPos.randomBetweenClosed((RandomSource)random, (int)l, (int)(blockpos.getX() - k), (int)blockpos.getY(), (int)(blockpos.getZ() - k), (int)(blockpos.getX() + k), (int)blockpos.getY(), (int)(blockpos.getZ() + k))) {
            int i1 = heightSample - blockpos1.distManhattan((Vec3i)blockpos);
            if (i1 < 0) continue;
            flag1 |= this.placeColumn((LevelAccessor)level, blockpos1, i1, config.reach().sample(random), baseConfig.ceilingCrystals());
        }
        return flag1;
    }

    private static LargeCrystal makeCrystal(BlockPos rootPos, boolean up, RandomSource random, int radius, FloatProvider bluntness, FloatProvider scale) {
        return new LargeCrystal(rootPos, up, radius, bluntness.sample(random), scale.sample(random));
    }

    private boolean placeColumn(LevelAccessor accessor, BlockPos pos, int distance, int reach, boolean ceiling) {
        boolean flag = false;
        block0: for (BlockPos blockpos : BlockPos.betweenClosed((int)(pos.getX() - reach), (int)pos.getY(), (int)(pos.getZ() - reach), (int)(pos.getX() + reach), (int)pos.getY(), (int)(pos.getZ() + reach))) {
            int i = blockpos.distManhattan((Vec3i)pos);
            BlockPos blockpos1 = UtheriumCrystalFeature.isAir(accessor, blockpos) ? this.findSurface(accessor, blockpos.mutable(), i, ceiling) : UtheriumCrystalFeature.findAir(accessor, blockpos.mutable(), i);
            if (blockpos1 == null) continue;
            BlockPos.MutableBlockPos mutable = blockpos1.mutable();
            for (int j = distance - i / 2; j >= 0; --j) {
                if (UtheriumCrystalFeature.isAir(accessor, (BlockPos)mutable)) {
                    this.setBlock((LevelWriter)accessor, (BlockPos)mutable, ((Block)UGBlocks.UTHERIUM_GROWTH.get()).defaultBlockState());
                    mutable.move(ceiling ? Direction.DOWN : Direction.UP);
                    flag = true;
                    continue;
                }
                if (!accessor.getBlockState((BlockPos)mutable).is((Block)UGBlocks.UTHERIUM_GROWTH.get())) continue block0;
                mutable.move(ceiling ? Direction.DOWN : Direction.UP);
            }
        }
        return flag;
    }

    @Nullable
    private BlockPos findSurface(LevelAccessor accessor, BlockPos.MutableBlockPos pos, int distance, boolean ceiling) {
        while (pos.getY() > accessor.getMinBuildHeight() + 1 && distance > 0) {
            --distance;
            if (this.canPlaceAt(accessor, pos, ceiling)) {
                return pos;
            }
            pos.move(Direction.DOWN);
        }
        return null;
    }

    private boolean canPlaceAt(LevelAccessor accessor, BlockPos.MutableBlockPos pos, boolean ceiling) {
        if (!UtheriumCrystalFeature.isAir(accessor, (BlockPos)pos)) {
            return false;
        }
        BlockState blockstate = accessor.getBlockState((BlockPos)pos.move(ceiling ? Direction.UP : Direction.DOWN));
        pos.move(ceiling ? Direction.DOWN : Direction.UP);
        return !blockstate.isAir() && CAN_PLACE_ON.contains((Object)blockstate.getBlock());
    }

    @Nullable
    private static BlockPos findAir(LevelAccessor accessor, BlockPos.MutableBlockPos pos, int distance) {
        while (pos.getY() < accessor.getMaxBuildHeight() && distance > 0) {
            --distance;
            BlockState blockstate = accessor.getBlockState((BlockPos)pos);
            if (!CAN_PLACE_ON.contains((Object)blockstate.getBlock())) {
                return null;
            }
            if (blockstate.isAir()) {
                return pos;
            }
            pos.move(Direction.UP);
        }
        return null;
    }

    private static boolean isAir(LevelAccessor accessor, BlockPos pos) {
        BlockState blockstate = accessor.getBlockState(pos);
        return blockstate.isAir();
    }

    static final class LargeCrystal {
        private BlockPos root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargeCrystal(BlockPos pRoot, boolean pPointingUp, int radius, double pBluntness, double pScale) {
            this.root = pRoot;
            this.pointingUp = pPointingUp;
            this.radius = radius;
            this.bluntness = pBluntness;
            this.scale = pScale;
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(WorldGenLevel level) {
            while (this.radius > 1) {
                BlockPos.MutableBlockPos pos = this.root.mutable();
                int i = Math.min(10, this.getHeightAtRadius(0.0f));
                for (int j = 0; j < i; ++j) {
                    if (level.getBlockState((BlockPos)pos).is(Blocks.LAVA)) {
                        return false;
                    }
                    if (DripstoneUtils.isCircleMostlyEmbeddedInStone((WorldGenLevel)level, (BlockPos)pos, (int)this.radius)) {
                        this.root = pos;
                        return true;
                    }
                    pos.move(this.pointingUp ? Direction.DOWN : Direction.UP);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float radius) {
            return (int)DripstoneUtils.getDripstoneHeight((double)radius, (double)this.radius, (double)this.scale, (double)this.bluntness);
        }

        void placeBlocks(WorldGenLevel level, RandomSource random) {
            for (int i = -this.radius; i <= this.radius; ++i) {
                block1: for (int j = -this.radius; j <= this.radius; ++j) {
                    int k;
                    float f = Mth.sqrt((float)(i * i + j * j));
                    if (f > (float)this.radius || (k = this.getHeightAtRadius(f)) <= 0) continue;
                    if ((double)random.nextFloat() < 0.2) {
                        k = (int)((float)k * Mth.randomBetween((RandomSource)random, (float)0.8f, (float)1.0f));
                    }
                    BlockPos.MutableBlockPos pos = this.root.offset(i, 0, j).mutable();
                    boolean flag = false;
                    int l = this.pointingUp ? level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, pos.getX(), pos.getZ()) : Integer.MAX_VALUE;
                    for (int i1 = 0; i1 < k && pos.getY() < l; ++i1) {
                        if (level.getBlockState((BlockPos)pos).isAir()) {
                            flag = true;
                            level.setBlock((BlockPos)pos, ((Block)UGBlocks.UTHERIUM_GROWTH.get()).defaultBlockState(), 2);
                        } else if (flag && level.getBlockState((BlockPos)pos).is(UGBlocks.DREADROCK)) continue block1;
                        pos.move(this.pointingUp ? Direction.UP : Direction.DOWN);
                    }
                }
            }
        }
    }
}

