/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import quek.undergarden.component.RogdoriumInfusion;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGDataComponents;
import quek.undergarden.registry.UGEnchantments;
import quek.undergarden.registry.UGItems;

public class UGCreativeModeTabs {
    private static final List<DeferredItem<Item>> DONT_INCLUDE = List.of(UGItems.GLOOMPER_SECRET_DISC);
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"undergarden");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TAB = TABS.register("undergarden_group", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).title((Component)Component.translatable((String)"itemGroup.undergarden_group")).icon(() -> new ItemStack((ItemLike)UGBlocks.DEEPTURF_BLOCK.get())).displayItems((parameters, output) -> {
        parameters.holders().lookup(Registries.ENCHANTMENT).ifPresent(enchantmentRegistryLookup -> {
            output.accept(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance((Holder)enchantmentRegistryLookup.getOrThrow(UGEnchantments.RICOCHET), 3)));
            output.accept(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance((Holder)enchantmentRegistryLookup.getOrThrow(UGEnchantments.LONGEVITY), 3)));
            output.accept(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance((Holder)enchantmentRegistryLookup.getOrThrow(UGEnchantments.SELF_SLING), 1)));
        });
        UGItems.ITEMS.getEntries().forEach(item -> {
            Object patt0$temp;
            if (!DONT_INCLUDE.contains(item) && !item.getKey().location().getPath().contains("tremblecrust")) {
                output.accept((ItemLike)item.get());
            }
            if ((patt0$temp = item.get()) instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)patt0$temp;
                ItemStack armorStack = new ItemStack((ItemLike)armorItem);
                armorStack.set(UGDataComponents.ROGDORIUM_INFUSION, (Object)RogdoriumInfusion.setInfusionAmount(RogdoriumInfusion.DEFAULT.infusionMax()));
                output.accept(armorStack);
            }
        });
    }).build());

    public static void registerBuckets(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == TAB.getKey()) {
            ArrayList<EntityType> usedEntities = new ArrayList<EntityType>();
            ArrayList<Block> usedBlocks = new ArrayList<Block>();
            for (Item item2 : BuiltInRegistries.ITEM.stream().filter(item -> item instanceof MobBucketItem).toList().reversed()) {
                EntityType type = ((MobBucketItem)item2).type;
                if (usedEntities.contains(type)) continue;
                FluidStack stack = new FluidStack(((MobBucketItem)item2).content, 1000);
                ResourceLocation id = EntityType.getKey((EntityType)type);
                event.insertAfter(UGItems.CLOGGRUM_BUCKET.toStack(), new ItemStack(UGItems.CLOGGRUM_BUCKET, 1, DataComponentPatch.builder().set(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.of((CompoundTag)((CompoundTag)Util.make((Object)new CompoundTag(), tag -> tag.putString("id", id.toString()))))).set((DataComponentType)UGDataComponents.STORED_FLUID.get(), (Object)SimpleFluidContent.copyOf((FluidStack)stack)).build()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                usedEntities.add(type);
            }
            for (Item item2 : BuiltInRegistries.ITEM.stream().filter(item -> item instanceof SolidBucketItem).toList().reversed()) {
                Block block = ((SolidBucketItem)item2).getBlock();
                if (usedBlocks.contains(block)) continue;
                event.insertAfter(UGItems.CLOGGRUM_BUCKET.toStack(), new ItemStack(UGItems.CLOGGRUM_BUCKET, 1, DataComponentPatch.builder().set((DataComponentType)UGDataComponents.STORED_BLOCK.get(), (Object)block.defaultBlockState()).build()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                usedBlocks.add(block);
            }
            for (Fluid fluid2 : BuiltInRegistries.FLUID.stream().filter(fluid -> fluid.isSource(fluid.defaultFluidState())).toList().reversed()) {
                FluidStack stack = new FluidStack(fluid2, 1000);
                event.insertAfter(UGItems.CLOGGRUM_BUCKET.toStack(), new ItemStack(UGItems.CLOGGRUM_BUCKET, 1, DataComponentPatch.builder().set((DataComponentType)UGDataComponents.STORED_FLUID.get(), (Object)SimpleFluidContent.copyOf((FluidStack)stack)).build()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }
}

