/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import quek.undergarden.registry.UGAttachments;

public record UthericInfectionPacket(int entityID, double infectionLevel) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UthericInfectionPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"utheric_infection"));
    public static final StreamCodec<FriendlyByteBuf, UthericInfectionPacket> STREAM_CODEC = CustomPacketPayload.codec(UthericInfectionPacket::write, UthericInfectionPacket::new);

    public UthericInfectionPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readDouble());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityID());
        buffer.writeDouble(this.infectionLevel());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(final UthericInfectionPacket message, final IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Level level = context.player().level();
                    Entity entity = level.getEntity(message.entityID());
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        living.setData((AttachmentType)UGAttachments.UTHERIC_INFECTION.get(), (Object)message.infectionLevel());
                    }
                }
            });
        }
    }
}

