/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.data;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import quek.undergarden.block.BlisterberryBushBlock;
import quek.undergarden.block.DepthrockPebblesBlock;
import quek.undergarden.block.DitchbulbBlock;
import quek.undergarden.block.UnderbeanBushBlock;
import quek.undergarden.data.provider.UGBlockLootTableProvider;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;

public class UGLootTables
extends LootTableProvider {
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public UGLootTables(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(Blocks::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(Chests::new, LootContextParamSets.CHEST), new LootTableProvider.SubProviderEntry(Entities::new, LootContextParamSets.ENTITY)), provider);
    }

    public record Chests(HolderLookup.Provider registries) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"chests/catacombs")), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.CLOGGRUM_NUGGET.get())).setWeight(40).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.FROSTSTEEL_NUGGET.get())).setWeight(40).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.UTHERIC_SHARD.get())).setWeight(20).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.REGALIUM_CRYSTAL.get())).setWeight(20).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.SLOP_BOWL.get())).setWeight(40).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)8.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.CLOGGRUM_SWORD.get())).setWeight(10).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)15.0f, (float)20.0f))).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.6f, (float)0.9f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.CLOGGRUM_AXE.get())).setWeight(10).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)15.0f, (float)20.0f))).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.6f, (float)0.9f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.CLOGGRUM_SWORD.get())).setWeight(10).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)25.0f, (float)30.0f)).fromOptions((HolderSet)this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentTags.TREASURE))).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.2f, (float)0.5f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.CLOGGRUM_AXE.get())).setWeight(10).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)25.0f, (float)30.0f)).fromOptions((HolderSet)this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentTags.TREASURE))).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.2f, (float)0.5f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(8)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.MAMMOTH_DISC.get())).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.RELICT_DISC.get())).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.FORGOTTEN_UPGRADE_TEMPLATE.get())).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.FORGOTTEN_NUGGET.get())).setWeight(1))));
            consumer.accept((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"chests/denizen_camp")), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGItems.RAW_DWELLER_MEAT).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGItems.DROOPFRUIT).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)8.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)UGBlocks.DENIZEN_TOTEM.asItem()).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STICK).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)16.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGBlocks.ANCIENT_ROOT).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)16.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGBlocks.ANCIENT_ROOT_PLANKS).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)16.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGItems.DENIZEN_MASK).setWeight(3))));
            consumer.accept((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"chests/depleted_mine/mound")), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGItems.FORGOTTEN_PICKAXE).setWeight(2).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.5f, (float)0.85f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TORCH).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)16.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGBlocks.SMOGSTEM_PLANKS).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)16.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COAL).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGItems.RAW_CLOGGRUM).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)16.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGItems.RAW_FROSTSTEEL).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)16.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGItems.REGALIUM_CRYSTAL).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGItems.UTHERIC_CLUSTER).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))))));
            consumer.accept((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"chests/depleted_mine/normal")), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(7)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGItems.CLOGGRUM_PICKAXE).setWeight(5).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.25f, (float)0.95f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGItems.CLOGGRUM_SHOVEL).setWeight(5).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.25f, (float)0.95f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGItems.DWELLER_STEAK).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TORCH).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STICK).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGBlocks.SMOGSTEM_PLANKS).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COAL).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)16.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGItems.RAW_CLOGGRUM).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UGItems.RAW_FROSTSTEEL).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)8.0f))))));
        }
    }

    public static class Entities
    extends EntityLootSubProvider {
        public Entities(HolderLookup.Provider provider) {
            super(FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate() {
            this.add((EntityType)UGEntityTypes.ROTLING.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.UTHERIC_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).when(LootItemKilledByPlayerCondition.killedByPlayer()))));
            this.add((EntityType)UGEntityTypes.ROTWALKER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.UTHERIC_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).when(LootItemKilledByPlayerCondition.killedByPlayer()))));
            this.add((EntityType)UGEntityTypes.ROTBEAST.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.UTHERIC_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)8.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).when(LootItemKilledByPlayerCondition.killedByPlayer()))));
            this.add((EntityType)UGEntityTypes.ROTBELCHER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.UTHERIC_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)6.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).when(LootItemKilledByPlayerCondition.killedByPlayer()))));
            this.add((EntityType)UGEntityTypes.DWELLER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.RAW_DWELLER_MEAT.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)UGEntityTypes.GREATER_DWELLER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)4.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.RAW_DWELLER_MEAT.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)8.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)UGEntityTypes.GWIBLING.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.RAW_GWIBLING.get())).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot()))).when(LootItemKilledByPlayerCondition.killedByPlayer())).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE_MEAL)).when(LootItemRandomChanceCondition.randomChance((float)0.05f))));
            this.add((EntityType)UGEntityTypes.BRUTE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.BRUTE_TUSK.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)UGEntityTypes.SCINTLING.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.GOO_BALL.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))))));
            this.add((EntityType)UGEntityTypes.GLOOMPER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.RAW_GLOOMPER_LEG.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)UGEntityTypes.STONEBORN.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))));
            this.add((EntityType)UGEntityTypes.NARGOYLE.get(), LootTable.lootTable());
            this.add((EntityType)UGEntityTypes.MUNCHER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.CLOGGRUM_NUGGET.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.FROSTSTEEL_NUGGET.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))))));
            this.add((EntityType)UGEntityTypes.SPLOOGIE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))));
            this.add((EntityType)UGEntityTypes.GWIB.get(), LootTable.lootTable());
            this.add((EntityType)UGEntityTypes.MOG.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.MOGMOSS.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)UGEntityTypes.SMOG_MOG.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.BLUE_MOGMOSS.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)UGEntityTypes.FORGOTTEN.get(), LootTable.lootTable());
            this.add((EntityType)UGEntityTypes.DENIZEN.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.DENIZEN_MASK.get()))).when(LootItemKilledByPlayerCondition.killedByPlayer()).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.05f, (float)0.01f))));
            this.add((EntityType)UGEntityTypes.FORGOTTEN_GUARDIAN.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.FORGOTTEN_NUGGET.get())).when(LootItemKilledByPlayerCondition.killedByPlayer())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)16.0f))))));
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return UGEntityTypes.ENTITIES.getEntries().stream().map(Supplier::get);
        }
    }

    public static class Blocks
    extends UGBlockLootTableProvider {
        protected Blocks(HolderLookup.Provider provider) {
            super(provider);
        }

        protected void generate() {
            HolderLookup.RegistryLookup registryLookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DREADROCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEEPSOIL);
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.DEEPSOIL_FARMLAND, (Supplier<? extends ItemLike>)UGBlocks.DEEPSOIL);
            this.add((Block)UGBlocks.UNDERBEAN_BUSH.get(), LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)UGBlocks.UNDERBEAN_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)UnderbeanBushBlock.AGE, 3))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.UNDERBEANS.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE)))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)UGBlocks.UNDERBEAN_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)UnderbeanBushBlock.AGE, 2))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.UNDERBEANS.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE)))));
            this.add((Block)UGBlocks.BLISTERBERRY_BUSH.get(), LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)UGBlocks.BLISTERBERRY_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlisterberryBushBlock.AGE, 3))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.BLISTERBERRY.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE)))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)UGBlocks.BLISTERBERRY_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlisterberryBushBlock.AGE, 2))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.BLISTERBERRY.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE)))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)UGBlocks.BLISTERBERRY_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlisterberryBushBlock.AGE, 3))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE)))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)UGBlocks.BLISTERBERRY_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlisterberryBushBlock.AGE, 2))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE)))));
            this.add((Block)UGBlocks.DITCHBULB_PLANT.get(), LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)UGBlocks.DITCHBULB_PLANT.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DitchbulbBlock.AGE, 1))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.DITCHBULB.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE)))));
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.DEEPTURF_BLOCK, (Supplier<? extends ItemLike>)UGBlocks.DEEPSOIL);
            this.add((Block)UGBlocks.TALL_DEEPTURF.get(), block -> Blocks.tallGrassDrop(block, (Block)UGBlocks.DEEPTURF.get()));
            this.add((Block)UGBlocks.TALL_SHIMMERWEED.get(), block -> Blocks.tallGrassDrop(block, (Block)UGBlocks.SHIMMERWEED.get()));
            this.add((Block)UGBlocks.DEEPTURF.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.add((Block)UGBlocks.SHIMMERWEED.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.add((Block)UGBlocks.ASHEN_DEEPTURF.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_PLANKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PLANKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_SAPLING);
            this.add((Block)UGBlocks.SMOGSTEM_LEAVES.get(), leaves -> this.createLeavesDrops((Block)leaves, (Block)UGBlocks.SMOGSTEM_SAPLING.get(), DEFAULT_SAPLING_DROP_RATES));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_SAPLING);
            this.add((Block)UGBlocks.WIGGLEWOOD_LEAVES.get(), leaves -> this.createSilkTouchOrShearsDispatchTable((Block)leaves, ((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)leaves, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)UGBlocks.WIGGLEWOOD_SAPLING.get())))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE), (float[])DEFAULT_SAPLING_DROP_RATES))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)leaves, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.TWISTYTWIG.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))));
            this.add((Block)UGBlocks.GRONGLE_LEAVES.get(), leaves -> this.createLeavesDrops((Block)leaves, (Block)UGBlocks.GRONGLE_SAPLING.get(), DEFAULT_SAPLING_DROP_RATES));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.INDIGO_MUSHROOM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.VEIL_MUSHROOM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.INK_MUSHROOM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.BLOOD_MUSHROOM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CRACKED_DEPTHROCK_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GLOOMGOURD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CARVED_GLOOMGOURD);
            this.add((Block)UGBlocks.DEPTHROCK_PEBBLES.get(), pebble -> LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)UGBlocks.DEPTHROCK_PEBBLES.get(), (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)pebble).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DepthrockPebblesBlock.PEBBLES, 1)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)pebble).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DepthrockPebblesBlock.PEBBLES, 2))))))));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GLOOM_O_LANTERN);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHARD_O_LANTERN);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_STAIRS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.DEPTHROCK_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.DEPTHROCK_BRICK_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.SMOGSTEM_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.WIGGLEWOOD_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_FENCE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_FENCE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.FROSTSTEEL_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.UTHERIUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_BARS);
            this.dropOther((Supplier<? extends Block>)UGBlocks.GLITTERKELP, (ItemLike)UGItems.GLITTERKELP.get());
            this.dropOther((Supplier<? extends Block>)UGBlocks.GLITTERKELP_PLANT, (ItemLike)UGItems.GLITTERKELP.get());
            this.add((Block)UGBlocks.SMOGSTEM_DOOR.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
            this.add((Block)UGBlocks.WIGGLEWOOD_DOOR.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_TRAPDOOR);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_TRAPDOOR);
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.SMOG_VENT, (Supplier<? extends ItemLike>)UGBlocks.DEPTHROCK);
            this.add((Block)UGBlocks.GOO.get(), goo -> this.createSingleItemTableWithSilkTouch((Block)goo, (ItemLike)UGItems.GOO_BALL.get(), (NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)));
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.ASHEN_DEEPTURF_BLOCK, (Supplier<? extends ItemLike>)UGBlocks.DEEPSOIL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICKS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.SHIVERSTONE_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.SHIVERSTONE_BRICK_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.REGALIUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CRACKED_TREMBLECRUST_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHARD_TORCH);
            this.dropOther((Supplier<? extends Block>)UGBlocks.SHARD_WALL_TORCH, (ItemLike)UGBlocks.SHARD_TORCH.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_FENCE_GATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_FENCE_GATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.COARSE_DEEPSOIL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_SAPLING);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_PLANKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_STAIRS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.GRONGLE_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_FENCE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_FENCE_GATE);
            this.add((Block)UGBlocks.GRONGLE_DOOR.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_TRAPDOOR);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_SMOGSTEM_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_WIGGLEWOOD_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_GRONGLE_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_SMOGSTEM_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_WIGGLEWOOD_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_GRONGLE_WOOD);
            this.add((Block)UGBlocks.GLOOMGOURD_STEM.get(), stem -> this.createStemDrops((Block)stem, (Item)UGItems.GLOOMGOURD_SEEDS.get()));
            this.add((Block)UGBlocks.GLOOMGOURD_STEM_ATTACHED.get(), stem -> Blocks.dropSeedsForStem(stem, (Item)UGItems.GLOOMGOURD_SEEDS.get()));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CRACKED_SHIVERSTONE_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_WALL);
            this.add((Block)UGBlocks.BLOOD_MUSHROOM_CAP.get(), mushroom -> this.createMushroomBlockDrop((Block)mushroom, (ItemLike)UGBlocks.BLOOD_MUSHROOM.get()));
            this.add((Block)UGBlocks.ENGORGED_BLOOD_MUSHROOM_CAP.get(), block -> LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGBlocks.ENGORGED_BLOOD_MUSHROOM_CAP.get())).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)UGBlocks.ENGORGED_BLOOD_MUSHROOM_CAP.get(), (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.BLOOD_GLOBULE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)6.0f))))).append((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)UGBlocks.ENGORGED_BLOOD_MUSHROOM_CAP.get(), (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)UGBlocks.BLOOD_MUSHROOM.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)-6.0f, (float)2.0f))).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.lowerBound((int)0))))))));
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.BLOOD_MUSHROOM_STEM);
            this.add((Block)UGBlocks.INDIGO_MUSHROOM_CAP.get(), mushroom -> this.createMushroomBlockDrop((Block)mushroom, (ItemLike)UGBlocks.INDIGO_MUSHROOM.get()));
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.INDIGO_MUSHROOM_STEM);
            this.add((Block)UGBlocks.VEIL_MUSHROOM_CAP.get(), mushroom -> this.createMushroomBlockDrop((Block)mushroom, (ItemLike)UGBlocks.VEIL_MUSHROOM.get()));
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.VEIL_MUSHROOM_STEM);
            this.add((Block)UGBlocks.INK_MUSHROOM_CAP.get(), mushroom -> this.createMushroomBlockDrop((Block)mushroom, (ItemLike)UGBlocks.INK_MUSHROOM.get()));
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.INK_MUSHROOM_STEM);
            this.add((Block)UGBlocks.SEEPING_INK.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.FORGOTTEN_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CHISELED_DEPTHROCK_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CHISELED_SHIVERSTONE_BRICKS);
            this.dropPottedContents((Block)UGBlocks.POTTED_SMOGSTEM_SAPLING.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_WIGGLEWOOD_SAPLING.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_SHIMMERWEED.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_INDIGO_MUSHROOM.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_VEIL_MUSHROOM.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_INK_MUSHROOM.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_BLOOD_MUSHROOM.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_PUFF_MUSHROOM.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_GRONGLE_SAPLING.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_AMOROUS_BRISTLE.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_MISERABELL.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_BUTTERBUNCH.get());
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.FROZEN_DEEPTURF_BLOCK, (Supplier<? extends ItemLike>)UGBlocks.DEEPSOIL);
            this.add((Block)UGBlocks.FROZEN_DEEPTURF.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CHISELED_TREMBLECRUST_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICK_STAIRS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.TREMBLECRUST_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.TREMBLECRUST_BRICK_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.SMOGSTEM_WALL_SIGN, (ItemLike)UGBlocks.SMOGSTEM_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_WALL_SIGN, (ItemLike)UGBlocks.WIGGLEWOOD_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.GRONGLE_WALL_SIGN, (ItemLike)UGBlocks.GRONGLE_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_HANGING_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.SMOGSTEM_WALL_HANGING_SIGN, (ItemLike)UGBlocks.SMOGSTEM_HANGING_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_HANGING_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_WALL_HANGING_SIGN, (ItemLike)UGBlocks.WIGGLEWOOD_HANGING_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_HANGING_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.GRONGLE_WALL_HANGING_SIGN, (ItemLike)UGBlocks.GRONGLE_HANGING_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GOO_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SEDIMENT);
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.SEDIMENT_GLASS);
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.SEDIMENT_GLASS_PANE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_TILES);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_TILE_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_TILE_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_TILES);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_TILE_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_TILE_SLAB);
            this.add((Block)UGBlocks.DEPTHROCK_BED.get(), bed -> this.createSinglePropConditionTable((Block)bed, (Property)BedBlock.PART, (Comparable)BedPart.HEAD));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.MOGMOSS_RUG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.BLUE_MOGMOSS_RUG);
            this.ore((Supplier<? extends Block>)UGBlocks.DEPTHROCK_COAL_ORE, Items.COAL);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_COAL_ORE, Items.COAL);
            this.nuggetOre((Supplier<? extends Block>)UGBlocks.DEPTHROCK_IRON_ORE, Items.IRON_NUGGET);
            this.nuggetOre((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_IRON_ORE, Items.IRON_NUGGET);
            this.nuggetOre((Supplier<? extends Block>)UGBlocks.DEPTHROCK_GOLD_ORE, Items.GOLD_NUGGET);
            this.ore((Supplier<? extends Block>)UGBlocks.DEPTHROCK_DIAMOND_ORE, Items.DIAMOND);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_DIAMOND_ORE, Items.DIAMOND);
            this.ore((Supplier<? extends Block>)UGBlocks.DEPTHROCK_CLOGGRUM_ORE, (Supplier<? extends Item>)UGItems.RAW_CLOGGRUM);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_CLOGGRUM_ORE, (Supplier<? extends Item>)UGItems.RAW_CLOGGRUM);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_FROSTSTEEL_ORE, (Supplier<? extends Item>)UGItems.RAW_FROSTSTEEL);
            this.ore((Supplier<? extends Block>)UGBlocks.DEPTHROCK_UTHERIUM_ORE, (Supplier<? extends Item>)UGItems.UTHERIC_CLUSTER);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_UTHERIUM_ORE, (Supplier<? extends Item>)UGItems.UTHERIC_CLUSTER);
            this.ore((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_UTHERIUM_ORE, (Supplier<? extends Item>)UGItems.UTHERIC_CLUSTER);
            this.ore((Supplier<? extends Block>)UGBlocks.DEPTHROCK_REGALIUM_ORE, (Supplier<? extends Item>)UGItems.REGALIUM_CRYSTAL);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_REGALIUM_ORE, (Supplier<? extends Item>)UGItems.REGALIUM_CRYSTAL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.RAW_CLOGGRUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.RAW_FROSTSTEEL_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_LANTERN);
            this.add((Block)UGBlocks.HANGING_GRONGLE_LEAVES.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.add((Block)UGBlocks.DROOPVINE.get(), UGBlockLootTableProvider::droopvine);
            this.add((Block)UGBlocks.DROOPVINE_PLANT.get(), UGBlockLootTableProvider::droopvine);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLET);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.UTHERIC_GRONGLET);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.ROGDORIC_GRONGLET);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.BOOMGOURD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.AMOROUS_BRISTLE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.MISERABELL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.BUTTERBUNCH);
            this.dropOther((Supplier<? extends Block>)UGBlocks.VIRULENT_MIX_CAULDRON, (ItemLike)Items.CAULDRON);
            this.add((Block)UGBlocks.MUSHROOM_VEIL.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.ore((Supplier<? extends Block>)UGBlocks.DREADROCK_ROGDORIUM_ORE, (Supplier<? extends Item>)UGItems.ROGDORIUM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.ROGDORIUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.UTHERIUM_GROWTH);
            this.ore((Supplier<? extends Block>)UGBlocks.DREADROCK_UTHERIUM_ORE, (Supplier<? extends Item>)UGItems.UTHERIC_CLUSTER);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.ANCIENT_ROOT);
            this.add((Block)UGBlocks.ROGDORIC_ANCIENT_ROOT.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem(UGItems.ROGDORIUM_NUGGET).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE))))));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.ANCIENT_ROOT_PLANKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.ANCIENT_ROOT_STAIRS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.ANCIENT_ROOT_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.ANCIENT_ROOT_FENCE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.ANCIENT_ROOT_FENCE_GATE);
            this.add((Block)UGBlocks.ANCIENT_ROOT_DOOR.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.ANCIENT_ROOT_TRAPDOOR);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.ANCIENT_ROOT_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.ANCIENT_ROOT_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.ANCIENT_ROOT_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.ANCIENT_ROOT_WALL_SIGN, (ItemLike)UGBlocks.ANCIENT_ROOT_SIGN);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.ANCIENT_ROOT_HANGING_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.ANCIENT_ROOT_WALL_HANGING_SIGN, (ItemLike)UGBlocks.ANCIENT_ROOT_HANGING_SIGN);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DENIZEN_TOTEM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.PUFF_MUSHROOM);
            this.add((Block)UGBlocks.PUFF_MUSHROOM_CAP.get(), mushroom -> this.createMushroomBlockDrop((Block)mushroom, (ItemLike)UGBlocks.PUFF_MUSHROOM.get()));
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.PUFF_MUSHROOM_STEM);
            this.add((Block)UGBlocks.INFUSER.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DREADROCK_BRICKS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.DREADROCK_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.DREADROCK_BRICK_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DREADROCK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DREADROCK_BRICK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DREADROCK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DREADROCK_BRICK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DREADROCK_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DREADROCK_PRESSURE_PLATE);
        }

        protected Iterable<Block> getKnownBlocks() {
            return UGBlocks.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

