/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.compat.jei;

import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import quek.undergarden.client.gui.screen.inventory.InfuserScreen;
import quek.undergarden.compat.jei.category.InfusingJEIRecipeCategory;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGRecipeTypes;

@JeiPlugin
public class UGJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new InfusingJEIRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        registration.addRecipes(InfusingJEIRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)UGRecipeTypes.INFUSING.get()).stream().map(RecipeHolder::value).toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack(UGBlocks.INFUSER), new RecipeType[]{InfusingJEIRecipeCategory.RECIPE_TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(InfuserScreen.class, 32, 17, 41, 30, new RecipeType[]{InfusingJEIRecipeCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(InfuserScreen.class, 103, 17, 41, 30, new RecipeType[]{InfusingJEIRecipeCategory.RECIPE_TYPE});
    }
}

