/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import quek.undergarden.client.model.GwiblingModel;
import quek.undergarden.client.model.UGModelLayers;
import quek.undergarden.client.render.layer.GwiblingEyesLayer;
import quek.undergarden.entity.animal.Gwibling;

public class GwiblingRenderer
extends MobRenderer<Gwibling, GwiblingModel<Gwibling>> {
    private static final ResourceLocation GWIBLING = ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"textures/entity/gwibling.png");

    public GwiblingRenderer(EntityRendererProvider.Context context) {
        super(context, new GwiblingModel(context.bakeLayer(UGModelLayers.GWIBLING)), 0.3f);
        this.addLayer((RenderLayer)new GwiblingEyesLayer(this));
    }

    public ResourceLocation getTextureLocation(Gwibling entity) {
        return GWIBLING;
    }

    protected void setupRotations(Gwibling entity, PoseStack stack, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        super.setupRotations((LivingEntity)entity, stack, ageInTicks, rotationYaw, partialTicks, scale);
        float f = 4.3f * Mth.sin((float)(0.6f * ageInTicks));
        stack.mulPose(Axis.YP.rotationDegrees(f));
        if (!entity.isInWater()) {
            stack.translate(0.1f, 0.1f, -0.1f);
            stack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }
}

