/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model.item;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.CompositeModel;
import net.neoforged.neoforge.client.model.DynamicFluidContainerModel;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import quek.undergarden.item.bucket.UGBucketItem;
import quek.undergarden.registry.UGDataComponents;

public class CloggrumBucketModel
implements IUnbakedGeometry<CloggrumBucketModel> {
    private static final Map<ResourceLocation, ResourceLocation> TEXTURE_MAP = Maps.newHashMap();
    private static final Transformation DEPTH_OFFSET_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.002f, 1.002f, 1.002f), new Quaternionf());
    private final Fluid fluid;
    @Nullable
    private final ResourceLocation otherContent;
    private final boolean flipGas;
    private final boolean applyFluidLuminosity;
    private final boolean isLower;

    private CloggrumBucketModel(Fluid fluid, @Nullable ResourceLocation otherContent, boolean flipGas, boolean applyFluidLuminosity, boolean isLower) {
        this.fluid = fluid;
        this.otherContent = otherContent;
        this.flipGas = flipGas;
        this.applyFluidLuminosity = applyFluidLuminosity;
        this.isLower = isLower;
    }

    public CloggrumBucketModel withFluid(Fluid newFluid) {
        return new CloggrumBucketModel(newFluid, this.otherContent, this.flipGas, this.applyFluidLuminosity, this.isLower);
    }

    public CloggrumBucketModel withOtherContent(ResourceLocation otherContent, boolean isLower) {
        return new CloggrumBucketModel(Fluids.EMPTY, otherContent, this.flipGas, this.applyFluidLuminosity, isLower);
    }

    public static ResourceLocation getContentTexture(ResourceLocation otherContentLocation) {
        ResourceLocation texture = TEXTURE_MAP.get(otherContentLocation);
        if (texture == null) {
            String textureLocation = String.format("item/bucket_content/%s", otherContentLocation.getPath());
            texture = otherContentLocation.withPath(textureLocation);
            TEXTURE_MAP.put(otherContentLocation, texture);
        }
        return texture;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        TextureAtlasSprite templateSprite;
        List quads;
        List unbaked;
        TextureAtlasSprite particleSprite;
        Material particleLocation = context.hasMaterial("particle") ? context.getMaterial("particle") : null;
        Material baseLocation = context.hasMaterial("base") ? context.getMaterial("base") : null;
        Material otherContentLocation = null;
        Material fluidLocation = null;
        Material fluidMaskLocation = null;
        if (this.otherContent != null) {
            otherContentLocation = new Material(InventoryMenu.BLOCK_ATLAS, CloggrumBucketModel.getContentTexture(this.otherContent));
        }
        if (this.fluid != Fluids.EMPTY) {
            fluidLocation = new Material(InventoryMenu.BLOCK_ATLAS, CloggrumBucketModel.getContentTexture(BuiltInRegistries.FLUID.getKey((Object)this.fluid)));
            if (context.hasMaterial("fluid")) {
                fluidMaskLocation = context.getMaterial("fluid");
            }
        }
        if (otherContentLocation == null && fluidLocation != null && !MissingTextureAtlasSprite.getLocation().equals((Object)spriteGetter.apply(fluidLocation).contents().name())) {
            otherContentLocation = fluidLocation;
        }
        TextureAtlasSprite baseSprite = baseLocation != null ? spriteGetter.apply(baseLocation) : null;
        TextureAtlasSprite otherContentSprite = null;
        if (otherContentLocation != null) {
            otherContentSprite = spriteGetter.apply(otherContentLocation);
        }
        TextureAtlasSprite fluidSprite = this.fluid != Fluids.EMPTY ? spriteGetter.apply(ClientHooks.getBlockMaterial((ResourceLocation)IClientFluidTypeExtensions.of((Fluid)this.fluid).getStillTexture())) : null;
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = baseSprite;
        }
        if (particleSprite == null) {
            particleSprite = otherContentSprite;
        }
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        boolean flip = this.flipGas && this.fluid != Fluids.EMPTY && this.fluid.getFluidType().isLighterThanAir();
        modelState = new SimpleModelState(modelState.getRotation().compose(new Transformation(null, flip ? new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f) : null, null, null)));
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"cloggrum_bucket"));
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)particleSprite, (ItemOverrides)new ContainedFluidOverrideHandler(overrides, baker, (IGeometryBakingContext)itemContext, this), (ItemTransforms)context.getTransforms());
        RenderTypeGroup normalRenderTypes = DynamicFluidContainerModel.getLayerRenderTypes((boolean)false);
        if (baseSprite != null) {
            Vector3f lowered = this.isLower ? new Vector3f(0.0f, -0.0625f, 0.0f) : null;
            SimpleModelState baseState = new SimpleModelState(modelState.getRotation().compose(new Transformation(lowered, null, null, null)));
            unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)baseSprite);
            quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> baseSprite, (ModelState)baseState);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        }
        if (otherContentSprite != null) {
            SimpleModelState transformedState = new SimpleModelState(modelState.getRotation().compose(DEPTH_OFFSET_TRANSFORM), modelState.isUvLocked());
            List unbaked2 = UnbakedGeometryHelper.createUnbakedItemElements((int)2, (TextureAtlasSprite)otherContentSprite);
            TextureAtlasSprite finalOtherContentSprite = otherContentSprite;
            quads = UnbakedGeometryHelper.bakeElements((List)unbaked2, $ -> finalOtherContentSprite, (ModelState)transformedState);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        } else if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            SimpleModelState transformedState = new SimpleModelState(modelState.getRotation().compose(DEPTH_OFFSET_TRANSFORM), modelState.isUvLocked());
            unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)1, (TextureAtlasSprite)templateSprite);
            quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> fluidSprite, (ModelState)transformedState);
            boolean emissive = this.applyFluidLuminosity && this.fluid.getFluidType().getLightLevel() > 0;
            RenderTypeGroup renderTypes = DynamicFluidContainerModel.getLayerRenderTypes((boolean)emissive);
            if (emissive) {
                QuadTransformers.settingEmissivity((int)this.fluid.getFluidType().getLightLevel()).processInPlace(quads);
            }
            modelBuilder.addQuads(renderTypes, (Collection)quads);
        }
        modelBuilder.setParticle(particleSprite);
        return modelBuilder.build();
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrides {
        private final Map<ResourceLocation, BakedModel> cache = Maps.newHashMap();
        private final ItemOverrides nested;
        private final ModelBaker baker;
        private final IGeometryBakingContext owner;
        private final CloggrumBucketModel parent;

        private ContainedFluidOverrideHandler(ItemOverrides nested, ModelBaker baker, IGeometryBakingContext owner, CloggrumBucketModel parent) {
            this.nested = nested;
            this.baker = baker;
            this.owner = owner;
            this.parent = parent;
        }

        @Nullable
        public BakedModel resolve(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int number) {
            BakedModel overridden = this.nested.resolve(originalModel, stack, level, entity, number);
            if (overridden != originalModel) {
                return overridden;
            }
            if (stack.getItem() instanceof UGBucketItem) {
                BakedModel bakedModel;
                boolean containsEntityType = false;
                ResourceLocation content = null;
                if (stack.get(DataComponents.BUCKET_ENTITY_DATA) != null) {
                    ResourceLocation id = ResourceLocation.parse((String)((CustomData)stack.get(DataComponents.BUCKET_ENTITY_DATA)).copyTag().getString("id"));
                    content = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)id.getPath());
                    containsEntityType = true;
                } else if (stack.get(UGDataComponents.STORED_BLOCK) != null) {
                    content = BuiltInRegistries.BLOCK.getKey((Object)((BlockState)stack.get(UGDataComponents.STORED_BLOCK)).getBlock());
                }
                SimpleFluidContent fluid = null;
                if (content == null) {
                    fluid = (SimpleFluidContent)stack.getOrDefault(UGDataComponents.STORED_FLUID, (Object)SimpleFluidContent.EMPTY);
                    ResourceLocation location = BuiltInRegistries.FLUID.getKey((Object)fluid.getFluid());
                    Object object = content = location != BuiltInRegistries.FLUID.getDefaultKey() ? location : null;
                }
                if ((bakedModel = this.cache.get(content)) == null && content != null) {
                    CloggrumBucketModel unbaked = fluid == null ? this.parent.withOtherContent(content, containsEntityType) : this.parent.withFluid(fluid.getFluid());
                    bakedModel = unbaked.bake(this.owner, this.baker, Material::sprite, (ModelState)BlockModelRotation.X0_Y0, this);
                    this.cache.put(content, bakedModel);
                }
                return bakedModel;
            }
            return originalModel;
        }
    }

    public static final class Loader
    implements IGeometryLoader<CloggrumBucketModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public CloggrumBucketModel read(JsonObject jsonObject, JsonDeserializationContext context) {
            if (!jsonObject.has("fluid")) {
                throw new RuntimeException("Bucket model requires 'fluid' value.");
            }
            ResourceLocation fluidName = ResourceLocation.parse((String)jsonObject.get("fluid").getAsString());
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(fluidName);
            boolean flip = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"flip_gas", (boolean)false);
            boolean applyFluidLuminosity = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"apply_fluid_luminosity", (boolean)true);
            return new CloggrumBucketModel(fluid, null, flip, applyFluidLuminosity, false);
        }
    }
}

