/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.network;

import dev.xkmc.l2backpack.content.capability.PickupModeCap;
import dev.xkmc.l2backpack.content.capability.PickupTrace;
import dev.xkmc.l2backpack.content.click.DrawerQuickInsert;
import dev.xkmc.l2backpack.content.click.VanillaQuickInsert;
import dev.xkmc.l2backpack.content.insert.OverlayInsertItem;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.init.registrate.LBMisc;
import dev.xkmc.l2backpack.network.CreativeSetCarryToClient;
import dev.xkmc.l2serial.network.SerialPacketBase;
import dev.xkmc.l2serial.network.SimplePacketBase;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public record ClickInteractToServer(Type type, int wid, int slot, ItemStack stack, Callback suppress, int limit) implements SerialPacketBase<ClickInteractToServer>
{
    public void handle(Player pl) {
        PickupModeCap cap;
        if (!(pl instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)pl;
        AbstractContainerMenu menu = player.containerMenu;
        if (menu.containerId != this.wid) {
            return;
        }
        if (this.wid != 0 && !menu.getSlot(this.slot).allowModification((Player)player)) {
            return;
        }
        ItemStack storage = this.wid == 0 ? player.getInventory().getItem(this.slot) : menu.getSlot(this.slot).getItem();
        Item item = storage.getItem();
        if (!(item instanceof OverlayInsertItem)) {
            return;
        }
        OverlayInsertItem drawerItem = (OverlayInsertItem)item;
        drawerItem.serverTrigger(storage, player);
        ItemStack carried = menu.getCarried();
        if (player.isCreative() && this.wid == 0) {
            carried = this.stack;
        }
        if (this.type == Type.TAKE) {
            if (!carried.isEmpty()) {
                return;
            }
            ItemStack stack = drawerItem.takeItem(storage, player);
            if (player.isCreative() && this.wid == 0) {
                carried = stack;
            } else {
                menu.setCarried(stack);
                if (this.suppress == Callback.SUPPRESS) {
                    menu.setRemoteCarried(stack.copy());
                }
            }
        } else if (this.type == Type.QUICK_MOVE) {
            ItemStack stack;
            DrawerQuickInsert ins;
            if (menu instanceof DrawerQuickInsert) {
                ins = (DrawerQuickInsert)menu;
                stack = drawerItem.takeItem(storage, player);
                ins.quickMove((Player)player, menu, stack, this.slot);
                if (!stack.isEmpty()) {
                    drawerItem.attemptInsert(storage, stack, player);
                }
            }
            if (menu instanceof ChestMenu) {
                ins = (ChestMenu)menu;
                stack = drawerItem.takeItem(storage, player);
                ((VanillaQuickInsert)((Object)ins)).l2backpack$quickMove(player, menu, stack, this.slot);
                if (!stack.isEmpty()) {
                    drawerItem.attemptInsert(storage, stack, player);
                }
            }
        } else if (this.type == Type.INSERT) {
            if (this.limit == 0) {
                drawerItem.attemptInsert(storage, carried, player);
            } else {
                ItemStack split = carried.split(this.limit);
                drawerItem.attemptInsert(storage, split, player);
                carried.grow(split.getCount());
            }
            if (this.suppress == Callback.SUPPRESS) {
                menu.setRemoteCarried(menu.getCarried().copy());
            }
        } else if (this.type == Type.PICKUP && (cap = (PickupModeCap)storage.getCapability(LBMisc.PICKUP)) != null) {
            if (this.limit == 0) {
                cap.doPickup(carried, new PickupTrace(false, player));
            } else {
                ItemStack split = carried.split(this.limit);
                cap.doPickup(split, new PickupTrace(false, player));
                carried.grow(split.getCount());
            }
            if (this.suppress == Callback.SUPPRESS) {
                menu.setRemoteCarried(menu.getCarried().copy());
            }
        }
        if (this.wid != 0) {
            menu.getSlot(this.slot).set(storage);
        }
        if (player.isCreative() && this.wid == 0) {
            L2Backpack.HANDLER.toClientPlayer((SimplePacketBase)new CreativeSetCarryToClient(carried), player);
        } else if (this.suppress == Callback.SCRAMBLE) {
            ClickInteractToServer.scramble(menu);
        }
    }

    private static void scramble(AbstractContainerMenu menu) {
        ItemStack carried = menu.getCarried();
        if (carried.isEmpty()) {
            menu.setRemoteCarried(new ItemStack((ItemLike)Items.FARMLAND, 65));
        } else {
            menu.setRemoteCarried(ItemStack.EMPTY);
        }
        menu.broadcastChanges();
    }

    public static enum Type {
        INSERT,
        TAKE,
        QUICK_MOVE,
        PICKUP;

    }

    public static enum Callback {
        REGULAR,
        SUPPRESS,
        SCRAMBLE;

    }
}

