/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.init.registrate;

import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.l2backpack.content.backpack.BackpackItem;
import dev.xkmc.l2backpack.content.bag.BookBag;
import dev.xkmc.l2backpack.content.bag.EquipmentBag;
import dev.xkmc.l2backpack.content.capability.PickupConfig;
import dev.xkmc.l2backpack.content.client.LBBEWLR;
import dev.xkmc.l2backpack.content.drawer.DrawerItem;
import dev.xkmc.l2backpack.content.quickswap.handswap.HandswapItem;
import dev.xkmc.l2backpack.content.quickswap.handswap.MatcherData;
import dev.xkmc.l2backpack.content.quickswap.set.ArmorSetSwap;
import dev.xkmc.l2backpack.content.quickswap.single.ArmorSwap;
import dev.xkmc.l2backpack.content.quickswap.single.Quiver;
import dev.xkmc.l2backpack.content.quickswap.single.Scabbard;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalItem;
import dev.xkmc.l2backpack.content.remote.drawer.EnderDrawerItem;
import dev.xkmc.l2backpack.content.remote.player.EnderBackpackItem;
import dev.xkmc.l2backpack.content.tool.DestroyTweakerTool;
import dev.xkmc.l2backpack.content.tool.PickupTweakerTool;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.init.data.LBTagGen;
import dev.xkmc.l2backpack.init.registrate.LBBlocks;
import dev.xkmc.l2core.init.reg.registrate.SimpleEntry;
import dev.xkmc.l2core.init.reg.simple.DCReg;
import dev.xkmc.l2core.init.reg.simple.DCVal;
import dev.xkmc.l2core.init.reg.simple.Reg;
import dev.xkmc.l2core.util.DCStack;
import java.util.UUID;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;

@MethodsReturnNonnullByDefault
public class LBItems {
    public static final SimpleEntry<CreativeModeTab> TAB;
    public static final ItemEntry<BackpackItem>[] BACKPACKS;
    public static final ItemEntry<DimensionalItem>[] DIMENSIONAL_STORAGE;
    public static final ItemEntry<EnderBackpackItem> ENDER_BACKPACK;
    public static final ItemEntry<Item> ENDER_POCKET;
    public static final ItemEntry<PickupTweakerTool> PICKUP_TWEAKER;
    public static final ItemEntry<DestroyTweakerTool> DESTROY_TWEAKER;
    public static final ItemEntry<EquipmentBag> ARMOR_BAG;
    public static final ItemEntry<BookBag> BOOK_BAG;
    public static final ItemEntry<Quiver> QUIVER;
    public static final ItemEntry<Scabbard> SCABBARD;
    public static final ItemEntry<ArmorSwap> ARMOR_SWAP;
    public static final ItemEntry<ArmorSetSwap> SUIT_SWAP;
    public static final ItemEntry<HandswapItem> HANDSWAP;
    public static final ItemEntry<DrawerItem> DRAWER;
    public static final ItemEntry<EnderDrawerItem> ENDER_DRAWER;
    private static final DCReg DC;
    public static final DCVal<Integer> DC_ROW;
    public static final DCVal<Integer> DC_SEL;
    public static final DCVal<UUID> DC_CONT_ID;
    public static final DCVal<UUID> DC_OWNER_ID;
    public static final DCVal<Component> DC_OWNER_NAME;
    public static final DCVal<Long> DC_PASSWORD;
    public static final DCVal<String> DC_LOOT_ID;
    public static final DCVal<Long> DC_LOOT_SEED;
    public static final DCVal<PickupConfig> DC_PICKUP;
    public static final DCVal<Item> DC_ENDER_DRAWER_ITEM;
    public static final DCVal<DCStack> DC_DRAWER_STACK;
    public static final DCVal<Integer> DC_DRAWER_COUNT;
    public static final DCVal<Integer> DC_DRAWER_STACKING;
    public static final DCVal<Long> DC_SWAP_TOGGLE;
    public static final DCVal<MatcherData> DC_MATCHER;
    public static final DCVal<ItemContainerContents> BAG_CONTENT;
    public static final DCVal<ItemContainerContents> BACKPACK_CONTENT;

    public static <T extends Quiver> void createArrowBagModel(DataGenContext<Item, T> ctx, RegistrateItemModelProvider pvd) {
        ItemModelBuilder builder = (ItemModelBuilder)pvd.withExistingParent(ctx.getName(), "generated");
        builder.texture("layer0", "item/" + ctx.getName() + "_0");
        for (int i = 1; i < 4; ++i) {
            String name = ctx.getName() + "_" + i;
            ItemModelBuilder ret = (ItemModelBuilder)pvd.withExistingParent(name, "generated");
            ret.texture("layer0", "item/" + name);
            ItemModelBuilder.OverrideBuilder override = builder.override();
            override.predicate(L2Backpack.loc("arrow"), (float)i);
            override.model((ModelFile)new ModelFile.UncheckedModelFile("l2backpack:item/" + name));
        }
    }

    public static void register() {
    }

    public static ItemEntry<Item> simpleItem(String id) {
        return L2Backpack.REGISTRATE.item(id, Item::new).defaultModel().defaultLang().register();
    }

    static {
        DyeColor color;
        int i;
        TAB = L2Backpack.REGISTRATE.buildL2CreativeTab("backpack", "L2 Backpack", e -> e.icon(() -> ENDER_BACKPACK.asStack()));
        DC = DCReg.of((Reg)L2Backpack.REG);
        DC_ROW = DC.intVal("row");
        DC_SEL = DC.intVal("selected");
        DC_CONT_ID = DC.uuid("container_id");
        DC_OWNER_ID = DC.uuid("owner_id");
        DC_OWNER_NAME = DC.component("owner_name");
        DC_PASSWORD = DC.longVal("password");
        DC_LOOT_ID = DC.str("loot_table");
        DC_LOOT_SEED = DC.longVal("loot_seed");
        DC_PICKUP = DC.reg("pickup", PickupConfig.class, true);
        DC_ENDER_DRAWER_ITEM = DC.reg("ender_drawer_item", BuiltInRegistries.ITEM.byNameCodec(), ByteBufCodecs.registry((ResourceKey)Registries.ITEM), true);
        DC_DRAWER_STACK = DC.stack("drawer_stack");
        DC_DRAWER_COUNT = DC.intVal("drawer_count");
        DC_DRAWER_STACKING = DC.intVal("drawer_upgrade");
        DC_SWAP_TOGGLE = DC.longVal("set_swap_toggle");
        DC_MATCHER = DC.reg("matcher", MatcherData.class, true);
        BAG_CONTENT = DC.reg("bag_content", ItemContainerContents.CODEC, ItemContainerContents.STREAM_CODEC, true);
        BACKPACK_CONTENT = DC.reg("backpack_content", ItemContainerContents.CODEC, ItemContainerContents.STREAM_CODEC, true);
        TagKey back = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"back"));
        TagKey belt = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"belt"));
        BACKPACKS = new ItemEntry[16];
        for (i = 0; i < 16; ++i) {
            color = DyeColor.values()[i];
            LBItems.BACKPACKS[i] = L2Backpack.REGISTRATE.item("backpack_" + color.getName(), p -> new BackpackItem(color, (Item.Properties)p)).tag(new TagKey[]{LBTagGen.BACKPACKS, back}).model((ctx, pvd) -> ((ItemModelBuilder)pvd.getBuilder(ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).lang(RegistrateLangProvider.toEnglishName((String)(color.getName() + "_backpack"))).clientExtension(() -> () -> LBBEWLR.EXTENSIONS).register();
        }
        DIMENSIONAL_STORAGE = new ItemEntry[16];
        for (i = 0; i < 16; ++i) {
            color = DyeColor.values()[i];
            LBItems.DIMENSIONAL_STORAGE[i] = L2Backpack.REGISTRATE.item("dimensional_storage_" + color.getName(), p -> new DimensionalItem(color, (Item.Properties)p)).tag(new TagKey[]{LBTagGen.DIMENSIONAL_STORAGES, back}).model((ctx, pvd) -> ((ItemModelBuilder)pvd.getBuilder(ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).lang(RegistrateLangProvider.toEnglishName((String)(color.getName() + "_dimensional_backpack"))).clientExtension(() -> () -> LBBEWLR.EXTENSIONS).register();
        }
        ENDER_BACKPACK = L2Backpack.REGISTRATE.item("ender_backpack", EnderBackpackItem::new).model((ctx, pvd) -> ((ItemModelBuilder)pvd.getBuilder(ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).tag(new TagKey[]{back, LBTagGen.ENDER_CHEST}).defaultLang().clientExtension(() -> () -> LBBEWLR.EXTENSIONS).register();
        ENDER_POCKET = LBItems.simpleItem("ender_pocket");
        PICKUP_TWEAKER = L2Backpack.REGISTRATE.item("pickup_tweaker_tool", p -> new PickupTweakerTool(p.stacksTo(1))).defaultModel().defaultLang().register();
        DESTROY_TWEAKER = L2Backpack.REGISTRATE.item("destroy_tweaker_tool", p -> new DestroyTweakerTool(p.stacksTo(1))).defaultModel().defaultLang().register();
        ARMOR_BAG = L2Backpack.REGISTRATE.item("armor_bag", EquipmentBag::new).tag(new TagKey[]{LBTagGen.BAGS}).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx).override().predicate(L2Backpack.loc("fill"), 1.0f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)pvd.getBuilder(ctx.getName() + "_filled")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", pvd.modLoc("item/" + ctx.getName() + "_filled")))).lang("Equipment Bag").register();
        BOOK_BAG = L2Backpack.REGISTRATE.item("book_bag", BookBag::new).tag(new TagKey[]{LBTagGen.BAGS}).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx).override().predicate(L2Backpack.loc("fill"), 1.0f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)pvd.getBuilder(ctx.getName() + "_filled")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", pvd.modLoc("item/" + ctx.getName() + "_filled")))).defaultLang().register();
        QUIVER = L2Backpack.REGISTRATE.item("arrow_bag", Quiver::new).model(LBItems::createArrowBagModel).tag(new TagKey[]{back, LBTagGen.SWAPS}).lang("Quiver").register();
        SCABBARD = L2Backpack.REGISTRATE.item("tool_swap", Scabbard::new).defaultModel().tag(new TagKey[]{back, LBTagGen.SWAPS}).defaultLang().register();
        ARMOR_SWAP = L2Backpack.REGISTRATE.item("armor_swap", ArmorSwap::new).defaultModel().tag(new TagKey[]{back, LBTagGen.SWAPS}).defaultLang().register();
        SUIT_SWAP = L2Backpack.REGISTRATE.item("suit_swap", ArmorSetSwap::new).defaultModel().tag(new TagKey[]{back, LBTagGen.SWAPS}).defaultLang().register();
        HANDSWAP = L2Backpack.REGISTRATE.item("hand_swap", HandswapItem::new).defaultModel().tag(new TagKey[]{belt}).defaultLang().register();
        DRAWER = L2Backpack.REGISTRATE.item("drawer", p -> new DrawerItem((Block)LBBlocks.DRAWER.get(), (Item.Properties)p)).model((ctx, pvd) -> ((ItemModelBuilder)pvd.getBuilder(ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).tag(new TagKey[]{LBTagGen.DRAWERS}).defaultLang().clientExtension(() -> () -> LBBEWLR.EXTENSIONS).register();
        ENDER_DRAWER = L2Backpack.REGISTRATE.item("ender_drawer", p -> new EnderDrawerItem((Block)LBBlocks.ENDER_DRAWER.get(), (Item.Properties)p)).model((ctx, pvd) -> ((ItemModelBuilder)pvd.getBuilder(ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).tag(new TagKey[]{LBTagGen.DRAWERS}).defaultLang().clientExtension(() -> () -> LBBEWLR.EXTENSIONS).register();
    }
}

