/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.init.loot;

import com.tterrag.registrate.providers.loot.RegistrateLootTableProvider;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2core.serial.loot.LootTableTemplate;
import dev.xkmc.l2core.util.MathHelper;
import java.util.Locale;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class LootGen {
    private static LootTable.Builder buildEndCityExtraLoot() {
        return LootTable.lootTable().withPool(LootTableTemplate.getPool((int)1, (int)0).add((LootPoolEntryContainer.Builder)LootTableTemplate.getItem((Item)Items.ELYTRA, (int)1))).withPool(LootTableTemplate.getPool((int)2, (int)1).add((LootPoolEntryContainer.Builder)LootTableTemplate.getItem((Item)Items.ENCHANTED_GOLDEN_APPLE, (int)2, (int)4)).add((LootPoolEntryContainer.Builder)LootTableTemplate.getItem((Item)Items.NETHERITE_INGOT, (int)2, (int)4)).add((LootPoolEntryContainer.Builder)LootTableTemplate.getItem((Item)Items.NETHER_STAR, (int)1))).withPool(LootTableTemplate.getPool((int)5, (int)2).add((LootPoolEntryContainer.Builder)LootTableTemplate.getItem((Item)Items.GLOWSTONE_DUST, (int)16, (int)32)).add((LootPoolEntryContainer.Builder)LootTableTemplate.getItem((Item)Items.REDSTONE, (int)16, (int)32)).add((LootPoolEntryContainer.Builder)LootTableTemplate.getItem((Item)Items.LAPIS_LAZULI, (int)16, (int)32)).add((LootPoolEntryContainer.Builder)LootTableTemplate.getItem((Item)Items.AMETHYST_SHARD, (int)16, (int)32)).add((LootPoolEntryContainer.Builder)LootTableTemplate.getItem((Item)Items.QUARTZ, (int)16, (int)32)).add((LootPoolEntryContainer.Builder)LootTableTemplate.getItem((Item)Items.EMERALD, (int)16, (int)32)));
    }

    private static LootTable.Builder buildPlaceholderLoot() {
        return LootTable.lootTable().withPool(LootTableTemplate.getPool((int)1, (int)0).add((LootPoolEntryContainer.Builder)LootTableTemplate.getItem((Item)Items.COAL, (int)1, (int)16)));
    }

    private static void genBagLoot(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> map) {
        for (LootDefinition def : LootDefinition.values()) {
            map.accept((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)L2Backpack.loc(def.id)), def.loot.get());
        }
    }

    public static void genLoot(RegistrateLootTableProvider pvd) {
        pvd.addLootAction(LootContextParamSets.EMPTY, LootGen::genBagLoot);
    }

    public static enum LootDefinition {
        END_CITY_TREASURE(1.0, HiddenPlayer.UNNAMED, DyeColor.MAGENTA, (ResourceKey<LootTable>)BuiltInLootTables.END_CITY_TREASURE, LootGen::buildEndCityExtraLoot),
        BASTION_TREASURE(1.0, HiddenPlayer.UNNAMED, DyeColor.BLACK, (ResourceKey<LootTable>)BuiltInLootTables.BASTION_TREASURE, LootGen::buildPlaceholderLoot),
        DESERT_PYRAMID(1.0, HiddenPlayer.UNNAMED, DyeColor.YELLOW, (ResourceKey<LootTable>)BuiltInLootTables.DESERT_PYRAMID, LootGen::buildPlaceholderLoot),
        ANCIENT_CITY(1.0, HiddenPlayer.UNNAMED, DyeColor.CYAN, (ResourceKey<LootTable>)BuiltInLootTables.ANCIENT_CITY, LootGen::buildPlaceholderLoot),
        SHIPWRECK_TREASURE(1.0, HiddenPlayer.UNNAMED, DyeColor.BLUE, (ResourceKey<LootTable>)BuiltInLootTables.SHIPWRECK_TREASURE, LootGen::buildPlaceholderLoot),
        UNDERWATER_RUIN_BIG(1.0, HiddenPlayer.UNNAMED, DyeColor.LIGHT_BLUE, (ResourceKey<LootTable>)BuiltInLootTables.UNDERWATER_RUIN_BIG, LootGen::buildPlaceholderLoot),
        VILLAGE_CARTOGRAPHER(1.0, HiddenPlayer.UNNAMED, DyeColor.WHITE, (ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_CARTOGRAPHER, LootGen::buildPlaceholderLoot),
        IGLOO_CHEST(1.0, HiddenPlayer.UNNAMED, DyeColor.LIGHT_GRAY, (ResourceKey<LootTable>)BuiltInLootTables.IGLOO_CHEST, LootGen::buildPlaceholderLoot),
        STRONGHOLD_CORRIDOR(1.0, HiddenPlayer.UNNAMED, DyeColor.GRAY, (ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_CORRIDOR, LootGen::buildPlaceholderLoot),
        WOODLAND_MANSION(1.0, HiddenPlayer.UNNAMED, DyeColor.BROWN, (ResourceKey<LootTable>)BuiltInLootTables.WOODLAND_MANSION, LootGen::buildPlaceholderLoot),
        NETHER_BRIDGE(1.0, HiddenPlayer.UNNAMED, DyeColor.RED, (ResourceKey<LootTable>)BuiltInLootTables.NETHER_BRIDGE, LootGen::buildPlaceholderLoot),
        PILLAGER_OUTPOST(1.0, HiddenPlayer.UNNAMED, DyeColor.ORANGE, (ResourceKey<LootTable>)BuiltInLootTables.PILLAGER_OUTPOST, LootGen::buildPlaceholderLoot),
        RUINED_PORTAL(1.0, HiddenPlayer.UNNAMED, DyeColor.MAGENTA, (ResourceKey<LootTable>)BuiltInLootTables.RUINED_PORTAL, LootGen::buildPlaceholderLoot),
        ABANDONED_MINESHAFT(1.0, HiddenPlayer.UNNAMED, DyeColor.PINK, (ResourceKey<LootTable>)BuiltInLootTables.ABANDONED_MINESHAFT, LootGen::buildPlaceholderLoot),
        JUNGLE_TEMPLE(1.0, HiddenPlayer.UNNAMED, DyeColor.GRAY, (ResourceKey<LootTable>)BuiltInLootTables.JUNGLE_TEMPLE, LootGen::buildPlaceholderLoot),
        SIMPLE_DUNGEON(1.0, HiddenPlayer.UNNAMED, DyeColor.LIME, (ResourceKey<LootTable>)BuiltInLootTables.SIMPLE_DUNGEON, LootGen::buildPlaceholderLoot);

        public final String id;
        public final double chance;
        public final HiddenPlayer player;
        public final DyeColor color;
        public final ResourceLocation target;
        public final Supplier<LootTable.Builder> loot;

        private LootDefinition(double chance, HiddenPlayer player, DyeColor color, ResourceKey<LootTable> target, Supplier<LootTable.Builder> loot) {
            this.chance = chance;
            this.id = this.name().toLowerCase(Locale.ROOT);
            this.player = player;
            this.color = color;
            this.target = target.location();
            this.loot = loot;
        }
    }

    public static enum HiddenPlayer {
        UNNAMED("unnamed", "the Unnamed Explorer", "Backpack of the Unnamed Explorer");

        public final String id;
        public final String pname;
        public final String bname;
        public final UUID uuid;

        private HiddenPlayer(String id, String def, String bname) {
            this.id = id;
            this.pname = def;
            this.bname = bname;
            this.uuid = MathHelper.getUUIDFromString((String)id);
        }
    }
}

