/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.init.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalItem;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.init.loot.LootGen;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2core.util.MathHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class BackpackLootModifier
extends LootModifier {
    public static final Codec<BackpackLootModifier> CODEC = RecordCodecBuilder.create(i -> BackpackLootModifier.codecStart((RecordCodecBuilder.Instance)i).and(i.group((App)Codec.DOUBLE.fieldOf("chance").forGetter(e -> e.chance), (App)Codec.INT.fieldOf("color").forGetter(e -> e.color.ordinal()), (App)Codec.STRING.fieldOf("name").forGetter(e -> e.name), (App)Codec.STRING.fieldOf("loot").forGetter(e -> e.loot.toString()), (App)Codec.LONG.fieldOf("seed").forGetter(e -> e.seed))).apply((Applicative)i, BackpackLootModifier::new));
    public static final MapCodec<BackpackLootModifier> MAP_CODEC = CODEC.dispatchMap(e -> e, e -> e.codec());
    private final double chance;
    private final DyeColor color;
    private final String name;
    private final ResourceLocation loot;
    private final long seed;

    private BackpackLootModifier(LootItemCondition[] conditionsIn, double chance, int color, String name, String loot, long seed) {
        super(conditionsIn);
        this.chance = chance;
        this.color = DyeColor.values()[color % DyeColor.values().length];
        this.name = name;
        this.loot = ResourceLocation.parse((String)loot);
        this.seed = seed;
    }

    public BackpackLootModifier(double chance, LootGen.LootDefinition def, long seed, LootItemCondition ... conditionsIn) {
        super(conditionsIn);
        this.chance = chance;
        this.color = def.color;
        this.name = def.player.id;
        this.loot = L2Backpack.loc(def.id);
        this.seed = seed;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> list, LootContext context) {
        if (this.chance > context.getRandom().nextDouble()) {
            ItemStack stack;
            if (!this.name.isEmpty()) {
                stack = LBItems.DIMENSIONAL_STORAGE[this.color.ordinal()].asStack();
                UUID uuid = MathHelper.getUUIDFromString((String)this.name);
                MutableComponent comp = Component.translatable((String)("l2backpack.loot." + this.name + ".name"));
                DimensionalItem.initLootGen(stack, uuid, (Component)comp, this.color, this.loot, this.seed);
            } else {
                stack = LBItems.BACKPACKS[this.color.ordinal()].asStack();
                stack.set(LBItems.DC_LOOT_ID, (Object)this.loot.toString());
            }
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("l2backpack.loot." + this.name + ".item")).withStyle(ChatFormatting.GOLD));
            list.add((Object)stack);
        }
        return list;
    }

    public MapCodec<BackpackLootModifier> codec() {
        return MAP_CODEC;
    }
}

