/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.init.data;

import dev.xkmc.l2backpack.init.data.LBKeys;
import dev.xkmc.l2backpack.init.loot.LootGen;
import dev.xkmc.l2itemselector.init.data.L2Keys;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.fml.ModList;

public class LBLang {
    public static void addInfo(TooltipFlag flag, List<Component> list, Info ... text) {
        if (flag.hasShiftDown()) {
            boolean col = false;
            for (Info info : text) {
                list.add((Component)info.get().withStyle(col ? Style.EMPTY.withColor(6995504) : Style.EMPTY.withColor(6278628)));
                col = !col;
            }
        } else {
            list.add((Component)Info.SHIFT.get().withStyle(ChatFormatting.GRAY));
            list.add((Component)Info.PATCHOULI.get().withStyle(ModList.get().isLoaded("patchouli") ? ChatFormatting.GRAY : ChatFormatting.YELLOW));
        }
    }

    public static void altInsert(TooltipFlag flag, List<Component> list) {
        if (flag.hasShiftDown()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        AbstractContainerMenu menu = player.containerMenu;
        if (!menu.getCarried().isEmpty()) {
            list.add((Component)Info.ALT_INSERT.get().withStyle(ChatFormatting.YELLOW));
        }
    }

    public static void addTranslations(BiConsumer<String, String> pvd) {
        for (IDS iDS : IDS.values()) {
            pvd.accept("l2backpack." + iDS.id, iDS.def);
        }
        for (Enum enum_ : Info.values()) {
            pvd.accept("l2backpack." + ((Info)enum_).id, ((Info)enum_).def);
        }
        for (Enum enum_ : LootGen.HiddenPlayer.values()) {
            pvd.accept("l2backpack.loot." + ((LootGen.HiddenPlayer)enum_).id + ".name", ((LootGen.HiddenPlayer)enum_).pname);
            pvd.accept("l2backpack.loot." + ((LootGen.HiddenPlayer)enum_).id + ".item", ((LootGen.HiddenPlayer)enum_).bname);
        }
        pvd.accept(LBKeys.OPEN.id, "Open backpack on back");
    }

    public static String asId(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public static enum Info {
        SHIFT("tooltip.shift", "Press [SHIFT] to show usage", new L2Keys[0]),
        ALT_CONTENT("tooltip.alt_content", "Press [ALT] to show content", new L2Keys[0]),
        ALT_INSERT("tooltip.alt_insert", "Left Click with [ALT] to insert as Pickup", new L2Keys[0]),
        PATCHOULI("tooltip.patchouli", "Read Patchouli Book for details", new L2Keys[0]),
        COLLECT_BAG("tooltip.collect.item", "Right click to store matching items in inventory, other than hotbar", new L2Keys[0]),
        COLLECT_DRAWER("tooltip.collect.drawer", "Shift + right click to store matching items on inventory", new L2Keys[0]),
        EXTRACT_BAG("tooltip.extract.item", "Shift + right click to throw out stored items. Would at most throw 16 at a time.", new L2Keys[0]),
        EXTRACT_DRAWER("tooltip.extract.drawer", "Right click to take one stack item out", new L2Keys[0]),
        LOAD("tooltip.load", "Supports Load / Dump with Chest", new L2Keys[0]),
        PLACE("tooltip.place", "Shift + right click to place it as a block", new L2Keys[0]),
        KEYBIND("tooltip.keybind", "This can be put on chest slot (or back slot of Curios), and can be opened via key bind.", new L2Keys[0]),
        QUICK_INV_ACCESS("tooltip.info.quick_inv", "Right click to open. Or right click in inventory / ender chest / dimensional storage GUI to open directly.", new L2Keys[0]),
        QUICK_ANY_ACCESS("tooltip.info.quick_any", "Right click to open. Or right click in any GUI to open directly.", new L2Keys[0]),
        ARROW_INFO("tooltip.info.arrow_bag", "Put in off hand or chest slot (or back slot of Curios) and hold bow in main hand to preview, choose, and shoot arrows from quiver. Press up/down or [%s] + number to switch arrows", L2Keys.SHIFT),
        DRAWER_USE("tooltip.info.drawer", "In inventory, left click drawer with a stack to store item. Right click drawer to take item out. Drawer can only store 1 kind of simple item that has no NBT, but can store up to 64 stacks, or 512 stacks with full upgrades.", new L2Keys[0]),
        ENDER_DRAWER_USE("tooltip.info.ender_drawer_block", "For ender drawer block, right click it with item to store, and right click it with empty hand to retrieve a stack. For bulk transport, use drawer item to interact with it.", new L2Keys[0]),
        DIMENSIONAL("tooltip.info.dimensional", "All dimensional storage with the same color and owned by the same player shares the same inventory space, for both item and block form.", new L2Keys[0]),
        ENDER_DRAWER("tooltip.info.ender_drawer", "Same usage as drawer. All ender drawer set to the same item and owned by the same player shares the same inventory space, for both item and block form. Has same pickup option as regular drawer.", new L2Keys[0]),
        UPGRADE("tooltip.info.upgrade", "Upgrade by applying an Ender Pocket in Smithing Table. Content and name will be preserved.", new L2Keys[0]),
        EXIT("tooltip.info.exit", "When exiting GUI, it will return to the previous GUI if opened in accessible GUI. Press Shift + Esc to close all.", new L2Keys[0]),
        SCABBARD_INFO("tooltip.info.tool_bag", "Put in off hand or chest slot (or back slot of Curios).  Hold tools or weapons in main hand and press [%1$s] (or hold nothing and press [%2$s]) to preview, choose, and swap tools from scabbard. Press up/down or [%1$s] + number to switch tools. Press %3$s to swap", L2Keys.SHIFT, L2Keys.ALT, L2Keys.SWAP),
        ARMORBAG_INFO("tooltip.info.armor_bag", "Put in off hand or chest slot (or back slot of Curios). Hold nothing in main hand and press [%1$s] to preview, choose, and swap armors. Press up/down or [%1$s] + number to switch armors. Press %2$s to swap", L2Keys.SHIFT, L2Keys.SWAP),
        SUIT_BAG_INFO("tooltip.info.suit_bag", "Same as Armor Swap but swaps full set at a time. It will exchange equipped items and selected items. Takes down player armor if the selected row has empty slot.", new L2Keys[0]),
        HANDSWAP("tooltip.info.handswap", "Put in legging/belt/ender backpack. Automatically pop up preset off offhand item when you switch to corresponding mainhand slot.", new L2Keys[0]),
        INHERIT("tooltip.info.inherit", "Inherit all properties of a regular backpack, except that it cannot be upgraded. Can be placed in regular backpacks, but cannot open directly in regular backpack. Put it in dimensional storage for quick access.", new L2Keys[0]),
        PICKUP("tooltip.info.pickup", "Supports recursive pickup", new L2Keys[0]),
        PICKUP_TWEAKER("tooltip.info.pickup_tweaker", "Right click backpack / drawer / bag in inventory with this item to switch pickup mode.", new L2Keys[0]),
        DESTROY_TWEAKER("tooltip.info.destroy_tweaker", "Right click backpack / drawer / bag in inventory with this item to switch destroy mode.", new L2Keys[0]),
        TWEAKER_BACK("tooltip.info.tweaker_back", "Right click in hand to adjust mode for backpacks on your back.", new L2Keys[0]),
        TWEAKER_BLOCK("tooltip.info.tweaker_block", "Right click dimensional storage block to adjust mode for that block.", new L2Keys[0]);

        private final String id;
        private final String def;
        private final L2Keys[] key;

        private Info(String id, String def, L2Keys ... key) {
            this.id = id;
            this.def = def;
            this.key = key;
        }

        public MutableComponent get() {
            Object[] arr = new Object[this.key.length];
            for (int i = 0; i < this.key.length; ++i) {
                arr[i] = this.key[i].map.getKey().getDisplayName().copy().withStyle(ChatFormatting.YELLOW);
            }
            return Component.translatable((String)("l2backpack." + this.id), (Object[])arr);
        }
    }

    public static enum IDS {
        BACKPACK_SLOT("tooltip.backpack_slot", 2, "Upgrade: %s/%s"),
        STORAGE_OWNER("tooltip.owner", 1, "Owner: %s"),
        BAG_SIZE("tooltip.item.size", 2, "Content: %s/%s"),
        DRAWER_CONTENT("tooltip.drawer.content", 2, "Content: %s x%s"),
        DUMP_FEEDBACK("chat.feedback.dump", 1, "Dumped %s items into target block"),
        LOAD_FEEDBACK("chat.feedback.load", 1, "Loaded %s items from target block"),
        EXTRACT_FEEDBACK("chat.feedback.extract", 1, "Extracted %s items"),
        COLLECT_FEEDBACK("chat.feedback.collect", 1, "Collected %s items"),
        NO_ITEM("chat.feedback.no_item", 0, "No item set for ender drawer. Cannot be placed."),
        LOOT("tooltip.info.loot", 0, "It may have loots inside"),
        MODE_NONE("tooltip.mode.none", 0, "No Pickup"),
        MODE_STACKING("tooltip.mode.stacking", 0, "Pickup to Stacking Slots Only"),
        MODE_ALL("tooltip.mode.all", 0, "Pickup all Fitting Items"),
        DESTROY_NONE("tooltip.destroy.none", 0, "No Destroy"),
        DESTROY_EXCESS("tooltip.destroy.excess", 0, "Destroy excess item"),
        DESTROY_MATCH("tooltip.destroy.matching", 0, "Destroy matching item"),
        DESTROY_ALL("tooltip.destroy.all", 0, "Destroy all items inserted");

        final String id;
        final String def;
        final int count;

        private IDS(String id, int count, String def) {
            this.id = id;
            this.def = def;
            this.count = count;
        }

        public MutableComponent get(Object ... objs) {
            if (objs.length != this.count) {
                throw new IllegalArgumentException("for " + this.name() + ": expect " + this.count + " parameters, got " + objs.length);
            }
            return Component.translatable((String)("l2backpack." + this.id), (Object[])objs);
        }
    }
}

