/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.init.data;

import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2core.util.ConfigInit;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.neoforge.common.ModConfigSpec;

public class LBConfig {
    public static final Client CLIENT = (Client)L2Backpack.REGISTRATE.registerClient(Client::new);
    public static final Server SERVER = (Server)L2Backpack.REGISTRATE.registerSynced(Server::new);

    public static void init() {
    }

    public static class Client
    extends ConfigInit {
        public final ModConfigSpec.BooleanValue previewOnCenter;
        public final ModConfigSpec.BooleanValue popupArrowOnSwitch;
        public final ModConfigSpec.BooleanValue popupToolOnSwitch;
        public final ModConfigSpec.BooleanValue popupArmorOnSwitch;
        public final ModConfigSpec.BooleanValue drawerAlwaysRenderFlat;
        public final ModConfigSpec.BooleanValue reverseScroll;
        public final ModConfigSpec.BooleanValue backpackInsertRequiresShift;
        public final ModConfigSpec.BooleanValue backpackEnableLeftClickInsert;
        public final ModConfigSpec.BooleanValue backpackEnableRightClickInsert;

        Client(ConfigInit.Builder builder) {
            this.markL2();
            this.previewOnCenter = builder.text("Arrow Display on Center").comment("Put quiver preview near the center of the screen, rather than edge of the screen").define("previewOnCenter", true);
            this.popupArrowOnSwitch = builder.text("Popup quiver on bow switch").comment("Show arrow quick swap when switching to a bow").define("popupArrowOnSwitch", true);
            this.popupToolOnSwitch = builder.text("Popup tool swap on switch").comment("Show tool quick swap when switching to a tool").define("popupToolOnSwitch", false);
            this.popupArmorOnSwitch = builder.text("Popup armor swap on switch").comment("Show armor quick swap when switching to empty hand").define("popupArmorOnSwitch", false);
            this.reverseScroll = builder.text("Reverse scroll").comment("Reverse scrolling direction for quick swap").define("reverseScroll", false);
            this.backpackInsertRequiresShift = builder.text("Require SHIFT to insert").comment("Backpack inventory quick insert requires shift click").define("backpackInsertRequiresShift", false);
            this.backpackEnableLeftClickInsert = builder.text("Allow backpack left click insert").comment("Backpack inventory quick insert allows left click insert").define("backpackEnableLeftClickInsert", true);
            this.backpackEnableRightClickInsert = builder.text("Allow backpack right click insert").comment("Backpack inventory quick insert allows right click insert").define("backpackEnableRightClickInsert", true);
            this.drawerAlwaysRenderFlat = builder.text("Draws Always render content directly").define("drawerAlwaysRenderFlat", false);
        }

        public boolean allowBackpackInsert(int button) {
            if (((Boolean)this.backpackInsertRequiresShift.get()).booleanValue() && !Screen.hasShiftDown()) {
                return false;
            }
            boolean allow = false;
            if (((Boolean)this.backpackEnableLeftClickInsert.get()).booleanValue() && button == 0) {
                allow = true;
            }
            if (((Boolean)this.backpackEnableRightClickInsert.get()).booleanValue() && button == 1) {
                allow = true;
            }
            return allow;
        }
    }

    public static class Server
    extends ConfigInit {
        public final ModConfigSpec.IntValue initialRows;
        public final ModConfigSpec.IntValue startupBackpackCondition;
        public final ModConfigSpec.BooleanValue sophisticatedEnderTicking;
        public final ModConfigSpec.BooleanValue sophisticatedRightClickOpen;

        Server(ConfigInit.Builder builder) {
            this.markL2();
            this.initialRows = builder.text("Initial Rows for backpack").defineInRange("initialRows", 2, 1, 8);
            this.startupBackpackCondition = builder.text("Startup packing count").comment("How many items do players need to spawn with to have the privilege of having them in a backpack").defineInRange("startupBackpackCondition", 6, 1, 36);
            this.sophisticatedEnderTicking = builder.text("Tick Sophisticated backpacks in ender backpack").define("sophisticatedEnderTicking", true);
            this.sophisticatedRightClickOpen = builder.text("Right click Sophisticated backpacks to open in inventory and ender backpack").define("sophisticatedRightClickOpen", true);
        }
    }
}

