/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.init;

import dev.xkmc.l2backpack.content.bag.AbstractBag;
import dev.xkmc.l2backpack.content.client.BackpackModel;
import dev.xkmc.l2backpack.content.client.BagCountDeco;
import dev.xkmc.l2backpack.content.client.DrawerCountDeco;
import dev.xkmc.l2backpack.content.client.EnderPreviewOverlay;
import dev.xkmc.l2backpack.content.client.RenderEvents;
import dev.xkmc.l2backpack.content.common.InvClientTooltip;
import dev.xkmc.l2backpack.content.common.InvTooltip;
import dev.xkmc.l2backpack.content.quickswap.common.QuickSwapOverlay;
import dev.xkmc.l2backpack.content.quickswap.single.Quiver;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.init.data.LBKeys;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.IItemDecorator;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(value={Dist.CLIENT}, modid="l2backpack", bus=EventBusSubscriber.Bus.MOD)
public class L2BackpackClient {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)LBItems.QUIVER.get()), (ResourceLocation)L2Backpack.loc("arrow"), (stack, level, entity, i) -> Quiver.displayArrow(stack));
            ClampedItemPropertyFunction func = (stack, level, entity, i) -> AbstractBag.isFilled(stack) ? 1.0f : 0.0f;
            ItemProperties.register((Item)((Item)LBItems.ARMOR_BAG.get()), (ResourceLocation)L2Backpack.loc("fill"), (ItemPropertyFunction)func);
            ItemProperties.register((Item)((Item)LBItems.BOOK_BAG.get()), (ResourceLocation)L2Backpack.loc("fill"), (ItemPropertyFunction)func);
        });
    }

    @SubscribeEvent
    public static void registerClientTooltip(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(InvTooltip.class, InvClientTooltip::new);
    }

    @SubscribeEvent
    public static void registerOverlay(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, L2Backpack.loc("arrow_bag"), (LayeredDraw.Layer)new QuickSwapOverlay());
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, L2Backpack.loc("ender_drawer"), (LayeredDraw.Layer)new EnderPreviewOverlay());
    }

    @SubscribeEvent
    public static void registerDeco(RegisterItemDecorationsEvent event) {
        Object deco = new DrawerCountDeco();
        event.register((ItemLike)LBItems.DRAWER.get(), (IItemDecorator)deco);
        event.register((ItemLike)LBItems.ENDER_DRAWER.get(), (IItemDecorator)deco);
        deco = new BagCountDeco();
        event.register((ItemLike)LBItems.ARMOR_BAG.get(), (IItemDecorator)deco);
        event.register((ItemLike)LBItems.BOOK_BAG.get(), (IItemDecorator)deco);
    }

    @SubscribeEvent
    public static void registerReloadListener(EntityRenderersEvent.AddLayers event) {
        RenderEvents.registerBackpackLayer(event);
    }

    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(RenderEvents.BACKPACK_LAYER, BackpackModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        for (LBKeys e : LBKeys.values()) {
            event.register(e.map);
        }
    }
}

